/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.ByteBuffer;

public class RTPMulticastListener
extends Thread {
    private boolean running = true;
    private boolean quit = false;
    private MulticastSocket multicastSocket = null;
    private RTPUDPDatagramConfig datagramConfig = null;
    private IUDPMessageHandler handler = null;
    private String ipAddress = null;
    private int port = 0;
    private AtomicLong packetCount = new AtomicLong();

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unbind() {
        try {
            if (this.multicastSocket != null) {
                this.multicastSocket.leaveGroup(InetAddress.getByName(this.ipAddress));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.unbind: " + exception.toString());
        }
        finally {
            this.quit = true;
        }
    }

    public synchronized void bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, Executor executor, IUDPMessageHandler iUDPMessageHandler, String string, int n) {
        try {
            this.datagramConfig = rTPUDPDatagramConfig;
            this.handler = iUDPMessageHandler;
            this.ipAddress = string;
            this.port = n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.bind: " + exception.toString());
        }
    }

    private void init() {
        try {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.bind: " + this.ipAddress + "/" + this.port);
            InetAddress inetAddress = InetAddress.getByName(this.ipAddress);
            this.multicastSocket = null;
            if (this.datagramConfig.isMulticastBindToAddress() && this.multicastSocket == null) {
                try {
                    this.multicastSocket = new MulticastSocket(new InetSocketAddress(inetAddress, this.port));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.multicastSocket == null) {
                try {
                    this.multicastSocket = new MulticastSocket(this.port);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.multicastSocket.setTrafficClass(this.datagramConfig.getTrafficClass());
            this.multicastSocket.setReceiveBufferSize(this.datagramConfig.getReceiveBufferSize());
            this.multicastSocket.setReuseAddress(this.datagramConfig.isReuseAddress());
            this.multicastSocket.setSoTimeout(this.datagramConfig.getMulticastTimeout());
            this.multicastSocket.joinGroup(inetAddress);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.init: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.init();
        int n = this.datagramConfig.getDatagramMaximumPacketSize();
        while (true) {
            Object object;
            Object object2;
            if (this.multicastSocket == null) {
                object2 = this;
                synchronized (object2) {
                    this.running = false;
                    break;
                }
            }
            try {
                RTPMulticastListener rTPMulticastListener;
                object2 = new byte[n];
                object = new DatagramPacket((byte[])object2, n);
                this.multicastSocket.receive((DatagramPacket)object);
                int n2 = ((DatagramPacket)object).getLength();
                if (n2 > 0) {
                    rTPMulticastListener = ByteBuffer.wrap((byte[])object2, (int)0, (int)n2);
                    this.handler.handleMessage(((DatagramPacket)object).getSocketAddress(), rTPMulticastListener);
                    long l = this.packetCount.incrementAndGet();
                    if (l == 1L) {
                        WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.firstPacket: " + this.ipAddress + "/" + this.port);
                    }
                }
                rTPMulticastListener = this;
                synchronized (rTPMulticastListener) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                object = this;
                synchronized (object) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                object = this;
                synchronized (object) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
        try {
            if (this.multicastSocket != null) {
                this.multicastSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WMSLoggerFactory.getLogger(RTPMulticastListener.class).info("RTPMulticastListener.run(stop)");
    }
}

