/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastListener;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class RTPMulticastTransport
implements IUDPTransport {
    private Map<InetSocketAddress, MulticastListener> listeners = new HashMap<InetSocketAddress, MulticastListener>();

    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, Executor executor, IUDPMessageHandler iUDPMessageHandler, String string, int n) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
            RTPMulticastListener rTPMulticastListener = new RTPMulticastListener();
            rTPMulticastListener.bind(rTPUDPDatagramConfig, executor, iUDPMessageHandler, string, n);
            this.listeners.put(inetSocketAddress, new MulticastListener(inetSocketAddress, rTPMulticastListener));
            rTPMulticastListener.setDaemon(true);
            rTPMulticastListener.setPriority(10);
            rTPMulticastListener.start();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.bind: " + exception.toString());
            exception.printStackTrace();
        }
        return inetSocketAddress;
    }

    public void unbindAll() {
        try {
            for (InetSocketAddress inetSocketAddress : this.listeners.keySet()) {
                MulticastListener multicastListener = this.listeners.get(inetSocketAddress);
                if (multicastListener == null) continue;
                multicastListener.listener.unbind();
            }
            this.listeners.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.unbindAll: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void unbind(InetSocketAddress inetSocketAddress) {
        try {
            MulticastListener multicastListener = this.listeners.remove(inetSocketAddress);
            if (multicastListener != null) {
                multicastListener.listener.unbind();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.unbind: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class MulticastListener {
        public InetSocketAddress socketAddress = null;
        public RTPMulticastListener listener = null;

        public MulticastListener(InetSocketAddress inetSocketAddress, RTPMulticastListener rTPMulticastListener) {
            this.socketAddress = inetSocketAddress;
            this.listener = rTPMulticastListener;
        }
    }
}

