/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.RTPUDPTransportMinaSession;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;

public class RTPUDPHandler
extends IoHandlerAdapter {
    public static final String TRANSPORTSESSION = "RTPTRANSPORTSESSION";
    private AtomicReference<IUDPMessageHandler> handler = new AtomicReference<Object>(null);
    private AtomicLong packetCount = new AtomicLong();
    private InetSocketAddress bindAddress = null;

    public RTPUDPHandler(IUDPMessageHandler iUDPMessageHandler, InetSocketAddress inetSocketAddress) {
        this.handler.set(iUDPMessageHandler);
        this.bindAddress = inetSocketAddress;
        WMSLoggerFactory.getLogger(RTPUDPHandler.class).debug("IN: UDPHandler: create");
    }

    public void sessionCreated(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPUDPHandler.class).debug("IN: UDPHandler: sessionCreated");
    }

    public void sessionOpened(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPUDPHandler.class).debug("IN: UDPHandler: sessionOpened");
        IUDPMessageHandler iUDPMessageHandler = this.handler.get();
        if (iUDPMessageHandler != null) {
            RTPUDPTransportMinaSession rTPUDPTransportMinaSession = new RTPUDPTransportMinaSession();
            rTPUDPTransportMinaSession.init(ioSession);
            ioSession.setAttribute(TRANSPORTSESSION, (Object)rTPUDPTransportMinaSession);
            iUDPMessageHandler.sessionOpened(rTPUDPTransportMinaSession);
        }
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        RTPUDPTransportMinaSession rTPUDPTransportMinaSession;
        WMSLoggerFactory.getLogger(RTPUDPHandler.class).debug("IN: UDPHandler: sessionClosed");
        IUDPMessageHandler iUDPMessageHandler = this.handler.get();
        if (iUDPMessageHandler != null && (rTPUDPTransportMinaSession = (RTPUDPTransportMinaSession)ioSession.getAttribute(TRANSPORTSESSION)) != null) {
            iUDPMessageHandler.sessionClosed(rTPUDPTransportMinaSession);
        }
    }

    public void unbind() {
        this.handler.set(null);
    }

    public void messageReceived(IoSession ioSession, Object object) {
        IUDPMessageHandler iUDPMessageHandler = this.handler.get();
        if (iUDPMessageHandler != null) {
            SocketAddress socketAddress = null;
            if (ioSession instanceof DatagramSessionImpl) {
                socketAddress = ((DatagramSessionImpl)ioSession).getRemoteAddress();
            }
            iUDPMessageHandler.handleMessage(socketAddress, object);
            long l = this.packetCount.incrementAndGet();
            if (l == 1L) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("UDPTransport.firstPacket: " + this.bindAddress);
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
    }
}

