/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;

public class RTPUDPTransportMina
implements IUDPTransport {
    Map<InetSocketAddress, AcceptorHolder> handlers = new HashMap<InetSocketAddress, AcceptorHolder>();

    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, Executor executor, IUDPMessageHandler iUDPMessageHandler, String string, int n) {
        InetSocketAddress inetSocketAddress = null;
        try {
            Object object;
            inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
            DatagramAcceptorConfig datagramAcceptorConfig = new DatagramAcceptorConfig();
            if (executor != null) {
                datagramAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
                datagramAcceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(executor)));
            }
            IoSessionConfig ioSessionConfig = datagramAcceptorConfig.getSessionConfig();
            if (rTPUDPDatagramConfig != null && ioSessionConfig instanceof DatagramSessionConfig) {
                object = (DatagramSessionConfig)ioSessionConfig;
                rTPUDPDatagramConfig.configureSessionConfig((DatagramSessionConfig)object);
            }
            object = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress);
            DatagramAcceptor datagramAcceptor = new DatagramAcceptor(executor);
            boolean bl = false;
            String string2 = "Cause unknown";
            try {
                datagramAcceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)object, (IoServiceConfig)datagramAcceptorConfig);
                bl = true;
            }
            catch (Exception exception) {
                string2 = exception.toString();
            }
            if (!bl && inetSocketAddress.getAddress() != null) {
                inetSocketAddress = new InetSocketAddress(inetSocketAddress.getPort());
                object = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress);
                try {
                    datagramAcceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)object, (IoServiceConfig)datagramAcceptorConfig);
                    bl = true;
                }
                catch (Exception exception) {
                    string2 = exception.toString();
                }
            }
            if (bl) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("RTPUDPTransportMina.bind: " + inetSocketAddress.toString());
            } else {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("RTPUDPTransportMina.bind: Failure to bind to address[" + inetSocketAddress.toString() + "]: " + string2);
            }
            this.handlers.put(inetSocketAddress, new AcceptorHolder(datagramAcceptor, (RTPUDPHandler)((Object)object)));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.bind: " + exception.toString());
            exception.printStackTrace();
        }
        return inetSocketAddress;
    }

    public void unbindAll() {
        try {
            for (AcceptorHolder acceptorHolder : this.handlers.values()) {
                acceptorHolder.handlerAdapter.unbind();
            }
            for (AcceptorHolder acceptorHolder : this.handlers.values()) {
                acceptorHolder.acceptor.unbindAll();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.unbindAll: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void unbind(InetSocketAddress inetSocketAddress) {
        try {
            AcceptorHolder acceptorHolder = this.handlers.get(inetSocketAddress);
            if (acceptorHolder != null) {
                acceptorHolder.handlerAdapter.unbind();
                acceptorHolder.acceptor.unbindAll();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.unbind: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class AcceptorHolder {
        public DatagramAcceptor acceptor = null;
        public RTPUDPHandler handlerAdapter = null;

        public AcceptorHolder(DatagramAcceptor datagramAcceptor, RTPUDPHandler rTPUDPHandler) {
            this.acceptor = datagramAcceptor;
            this.handlerAdapter = rTPUDPHandler;
        }
    }
}

