/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class RTSPCore {
    public static final String HEADER_SESSION = "session";
    public static final String HEADER_CONTEXT = "context";
    public static final String HEADER_PUBLIC = "public";
    public static final String HEADER_USERAGENT = "user-agent";
    public static final String HEADER_TRANSPORT = "transport";

    public static void describe(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
    }

    public static void announce(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            Object object;
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (!rTPSession.isSessionValid()) {
                RTSPStatics.setStatus(rTPRequestStatus, 403);
            } else {
                object = RTSPRequestAdapter.getRTPUrl(rTSPRequestMessage, false);
                String string = ((RTPUrl)object).getUrlId();
                String string2 = rTSPRequestMessage.getBodyAsString();
                IVHost iVHost = rTSPRequestMessage.getVHost();
                RTPContext rTPContext = iVHost.getRTPContext();
                RTPStream rTPStream = RTPUtils.decodeStreamInfo(rTPContext, string, string2);
                rTPStream.setRTSP(true);
                rTPStream.setPublish(true);
                if (rTPSession == null) {
                    rTPContext.cacheRTPStream(rTPStream);
                } else {
                    rTPSession.addRTSPStream(rTPStream);
                }
                if (rTPStream.getHost() == null) {
                    rTPStream.setHost(((RTPUrl)object).getHost());
                }
                rTPStream.setAppName(((RTPUrl)object).getAppName());
                rTPStream.setAppInstanceName(((RTPUrl)object).getAppInstanceName());
                String string3 = ((RTPUrl)object).getQueryStr();
                String string4 = ((RTPUrl)object).getStreamName();
                String string5 = "mp4";
                String[] stringArray = ModuleUtils.decodeStreamExtension(string4, string5);
                string4 = stringArray[0];
                string5 = stringArray[1];
                rTPStream.setStreamName(string4);
                rTPStream.setStreamExt(string5);
                rTPStream.setStreamQueryStr(string3);
                IApplicationInstance iApplicationInstance = rTPStream.getAppInstance();
                if (iApplicationInstance == null) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).warn("Application folder ([install-location]/applications/" + rTPStream.getAppName() + ") is missing");
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    rTPSession.setSessionValid(false);
                } else {
                    rTPStream.announce(rTPRequestStatus);
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "rtsp", "announce", 200, string);
                }
            }
            if (!rTPRequestStatus.isGood()) {
                rTPSession.setSessionValid(false);
                rTPSession.shutdown(rTPRequestStatus);
                rTSPResponseMessages.setIsDidClose(true);
            }
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(rTPRequestStatus.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(rTPRequestStatus.getResponseMessage());
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.announce: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void getParameter(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.getParameter: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void setParameter(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setParameter: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void options(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessage.setHeader("Public", "DESCRIBE, SETUP, TEARDOWN, PAUSE, OPTIONS, ANNOUNCE, RECORD, GET_PARAMETER, SET_PARAMETER");
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.announce: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void pause(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            Object object;
            String string = rTSPRequestMessage.getTrackId();
            Object var4_5 = null;
            boolean bl = false;
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (!rTPSession.isSessionValid()) {
                RTSPStatics.setStatus(rTPRequestStatus, 403);
            } else {
                object = rTPSession.getRTSPStream();
                if (object == null) {
                    String string2 = rTSPRequestMessage.getHeader(HEADER_CONTEXT);
                    WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + string2);
                } else {
                    ((RTPStream)object).pause(rTPRequestStatus);
                }
            }
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(rTPRequestStatus.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(rTPRequestStatus.getResponseMessage());
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.play: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void play(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            Object object;
            String string = rTSPRequestMessage.getTrackId();
            Object var4_5 = null;
            boolean bl = false;
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (!rTPSession.isSessionValid()) {
                RTSPStatics.setStatus(rTPRequestStatus, 403);
            } else {
                object = rTPSession.getRTSPStream();
                if (object == null) {
                    String string2 = rTSPRequestMessage.getHeader(HEADER_CONTEXT);
                    WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + string2);
                } else {
                    ((RTPStream)object).record(rTPRequestStatus);
                    ((RTPStream)object).attachToWMSSession(rTSPRequestMessage.getWMSSessionInfo());
                }
            }
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(rTPRequestStatus.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(rTPRequestStatus.getResponseMessage());
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.play: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void record(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            Object object;
            String string = rTSPRequestMessage.getTrackId();
            Object var4_5 = null;
            boolean bl = false;
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (!rTPSession.isSessionValid()) {
                RTSPStatics.setStatus(rTPRequestStatus, 403);
            } else {
                object = rTPSession.getRTSPStream();
                if (object == null) {
                    String string2 = rTSPRequestMessage.getHeader(HEADER_CONTEXT);
                    WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + string2);
                } else {
                    ((RTPStream)object).record(rTPRequestStatus);
                    ((RTPStream)object).attachToWMSSession(rTSPRequestMessage.getWMSSessionInfo());
                }
            }
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(rTPRequestStatus.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(rTPRequestStatus.getResponseMessage());
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.record: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void redirect(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
    }

    public static void setup(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2 = rTSPRequestMessage.getTrackId();
            String string3 = null;
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            if (!rTPSession.isSessionValid()) {
                RTSPStatics.setStatus(rTPRequestStatus, 403);
            } else {
                object3 = rTPSession.getRTSPStream();
                if (object3 == null) {
                    object2 = RTSPRequestAdapter.getRTPUrl(rTSPRequestMessage, true);
                    string = ((RTPUrl)object2).getUrlId();
                    object = rTSPRequestMessage.getVHost();
                    RTPContext rTPContext = object.getRTPContext();
                    object3 = rTPContext.uncacheRTPStream(string);
                    if (object3 != null) {
                        rTPSession.addRTSPStream((RTPStream)object3);
                    }
                }
                if (object3 == null) {
                    object2 = rTSPRequestMessage.getHeader(HEADER_CONTEXT);
                    WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: stream missing: " + (String)object2);
                } else {
                    object2 = ((RTPStream)object3).getTrack(string2);
                    if (object2 == null) {
                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: track missing: " + string2);
                    } else {
                        string3 = rTSPRequestMessage.getHeader(HEADER_TRANSPORT);
                        if (string3 == null) {
                            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: transport missing: " + string2);
                        } else {
                            if (!((RTPStream)object3).streamExists()) {
                                ((RTPStream)object3).createStream(rTPRequestStatus);
                            }
                            ((RTPTrack)object2).clearPorts();
                            ((RTPTrack)object2).setup(rTPRequestStatus, string3);
                            if (rTPRequestStatus.isGood()) {
                                string3 = ((RTPTrack)object2).getTransportStr(string3);
                            }
                        }
                    }
                }
            }
            if (!rTPRequestStatus.isGood()) {
                rTPSession.setSessionValid(false);
                rTPSession.shutdown(rTPRequestStatus);
                rTSPResponseMessages.setIsDidClose(true);
            }
            object3 = new RTSPResponseMessage();
            ((RTSPResponseMessage)object3).setResponseCode(rTPRequestStatus.getResponseCode());
            ((RTSPResponseMessage)object3).setResponseMessage(rTPRequestStatus.getResponseMessage());
            ((RTSPResponseMessage)object3).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object3).setSession(rTPSession.getSessionId());
            if (rTPRequestStatus.isGood()) {
                object2 = new Date();
                ((RTSPResponseMessage)object3).setHeader("Transport", string3);
                string = FastDateFormat.getInstance((String)"EEE, d MMM yyyy HH:mm:ss z");
                object = string.format((Date)object2);
                ((RTSPResponseMessage)object3).setHeader("Date", (String)object);
                ((RTSPResponseMessage)object3).setHeader("Expires", (String)object);
            }
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object3);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.setup: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void teardown(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        try {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            RTPStream rTPStream = rTPSession.getRTSPStream();
            if (rTPStream != null) {
                rTPStream.detachFromWMSSession(rTSPRequestMessage.getWMSSessionInfo());
            }
            if (rTPSession != null) {
                rTPSession.shutdown(rTPRequestStatus);
            }
            rTSPResponseMessages.setIsDidClose(true);
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setResponseCode(rTPRequestStatus.getResponseCode());
            rTSPResponseMessage.setResponseMessage(rTPRequestStatus.getResponseMessage());
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            if (rTPSession != null) {
                rTSPResponseMessage.setSession(rTPSession.getSessionId());
            }
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.teardown: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

