/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationFactory;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpLeftover;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import org.apache.mina.common.IoSession;

public class RTSPRequestAdapter {
    public static RTPSession getSessionNoCreate(RtmpRequestMessage rtmpRequestMessage) {
        RTPSession rTPSession;
        block2: {
            RtmpSessionInfo rtmpSessionInfo;
            RTPSessions rTPSessions;
            RTPContext rTPContext;
            rTPSession = null;
            IVHost iVHost = rtmpRequestMessage.getVHost();
            if (iVHost == null || (rTPContext = iVHost.getRTPContext()) == null || (rTPSessions = rTPContext.getSessions()) == null) break block2;
            String string = null;
            if (string == null && (rtmpSessionInfo = rtmpRequestMessage.getSessionInfo()) != null) {
                string = rtmpSessionInfo.getRTSPSessionId();
            }
            if (string != null) {
                rTPSession = rTPSessions.getSession(string);
            }
        }
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RTPSession getSession(RTSPRequestMessage rTSPRequestMessage) {
        RTPSession rTPSession = null;
        IVHost iVHost = rTSPRequestMessage.getVHost();
        RTPContext rTPContext = iVHost.getRTPContext();
        RTPSessions rTPSessions = rTPContext.getSessions();
        String string = null;
        boolean bl = true;
        if (string == null && (string = rTSPRequestMessage.getSessionId()) != null) {
            bl = false;
        }
        if (string == null) {
            string = rTSPRequestMessage.getHeader("session");
        }
        if (string != null) {
            rTPSession = rTPSessions.getSession(string);
        } else if (string == null) {
            IAuthenticate iAuthenticate;
            String string2;
            RTPUrl rTPUrl = RTSPRequestAdapter.getRTPUrl(rTSPRequestMessage, false);
            String string3 = rTPUrl.getAppName();
            String string4 = rTPUrl.getAppInstanceName();
            IApplication iApplication = null;
            IApplicationInstance iApplicationInstance = null;
            IAuthenticateRTSP iAuthenticateRTSP = null;
            WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                iApplication = iVHost.getApplication(string3);
                if (iApplication != null) {
                    iApplicationInstance = iApplication.getAppInstance(string4);
                } else {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("Application folder ([install-location]/applications/" + string3 + ") is missing");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).error("RTSPRequestAdapter.getSession: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
            if (iApplicationInstance != null && (string2 = iApplicationInstance.getRTPAuthenticationMethod()) != null && (iAuthenticate = AuthenticationFactory.createInstance(iApplicationInstance, string2)) != null && iAuthenticate instanceof IAuthenticateRTSP) {
                iAuthenticateRTSP = (IAuthenticateRTSP)((Object)iAuthenticate);
            }
            string = rTPSessions.getNextSessionId();
            rTPSession = new RTPSession(string);
            string2 = rTSPRequestMessage.getHeader("user-agent");
            if (string2 != null) {
                rTPSession.setUserAgent(string2);
            }
            rTPSession.setAppInstance(iApplicationInstance);
            rTPSession.setAuthenticateHandler(iAuthenticateRTSP);
            if (iApplicationInstance == null) {
                rTPSession.setSessionValid(false);
            }
            rTPSession.setIp(rTSPRequestMessage.getIp());
            rTPSessions.addSession(rTPSession);
            rTPSessions.notifySessionCreate(rTPSession);
        }
        if (bl) {
            rTSPRequestMessage.setSessionId(string);
        }
        if (rTPSession != null) {
            rTPSession.touch();
        }
        return rTPSession;
    }

    public static RTPUrl getRTPUrl(RTSPRequestMessage rTSPRequestMessage, boolean bl) {
        RTPUrl rTPUrl = null;
        try {
            String string = rTSPRequestMessage.getHeader("context");
            if (string == null) {
                WMSLoggerFactory.getLogger(RTSPResponseMessage.class).warn("RTSPCore.getRTPUrl: context url is missing");
            } else {
                rTPUrl = new RTPUrl(string, bl);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.getRTPUrl: " + exception.toString());
            exception.printStackTrace();
        }
        return rTPUrl;
    }

    public static void service(RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        switch (rtmpRequestMessage.getType()) {
            case 2: {
                RTSPRequestAdapter.decodeMessage(rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            case 3: {
                RTSPRequestAdapter.handleIdle(rtmpRequestMessage, rtmpResponseMessage);
            }
        }
    }

    public static void decodeMessage(RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        Object object;
        Object object2;
        RtmpSessionInfo rtmpSessionInfo = rtmpRequestMessage.getSessionInfo();
        byte[] byArray = rtmpRequestMessage.getBody().array();
        int n = rtmpRequestMessage.getBody().limit();
        int n2 = 0;
        if (rtmpSessionInfo.isLeftover()) {
            object2 = rtmpSessionInfo.getLeftovers().get(0);
            rtmpSessionInfo.clearLeftover();
            object = new byte[n + ((RtmpLeftover)object2).len];
            System.arraycopy(((RtmpLeftover)object2).buffer, ((RtmpLeftover)object2).offset, object, 0, ((RtmpLeftover)object2).len);
            System.arraycopy(byArray, 0, object, ((RtmpLeftover)object2).len, n);
            byArray = object;
            n = byArray.length;
        }
        do {
            if (byArray[n2] == 36) {
                if (n - n2 < 4) break;
                int n3 = byArray[n2 + 2] & 0xFF;
                n3 <<= 8;
                if (n - n2 < (n3 += byArray[n2 + 3] & 0xFF) + 4) break;
                int n4 = byArray[n2 + 1] & 0xFF;
                IRTPMessageHandler iRTPMessageHandler = rtmpSessionInfo.getRTPInterleaveHandler(n4);
                if (iRTPMessageHandler != null) {
                    iRTPMessageHandler.handleMessage(null, byArray, n2 + 4, n3);
                }
                n2 += n3 + 4;
                continue;
            }
            object2 = RTSPRequestMessage.quickParseHeader(byArray, n2, n - n2);
            if (object2 == null || n - n2 < object2[0] + object2[1]) break;
            RTSPRequestAdapter.handleMessage(rtmpRequestMessage, rtmpResponseMessage, byArray, n2, (int)(object2[0] + object2[1]));
            n2 += object2[0] + object2[1];
        } while (n2 < n);
        if (n2 < n) {
            byte[] byArray2 = new byte[n - n2];
            System.arraycopy(byArray, n2, byArray2, 0, n - n2);
            object = new RtmpLeftover();
            object.buffer = byArray2;
            object.offset = 0;
            object.len = byArray2.length;
            rtmpSessionInfo.addLeftover((RtmpLeftover)object);
        }
    }

    public static void handleMessage(RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage, byte[] byArray, int n, int n2) {
        RTSPRequestMessage rTSPRequestMessage = new RTSPRequestMessage(rtmpRequestMessage, byArray, n, n2);
        RTSPResponseMessages rTSPResponseMessages = new RTSPResponseMessages(rtmpResponseMessage);
        RTPSession rTPSession = RTSPRequestAdapter.getSession(rTSPRequestMessage);
        boolean bl = true;
        IAuthenticateRTSP iAuthenticateRTSP = rTPSession.getAuthenticateHandler();
        if (iAuthenticateRTSP != null) {
            bl = iAuthenticateRTSP.authenticateRTSP(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
        } else {
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            RTSPStatics.setStatus(rTPRequestStatus, 403);
            RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
            rTSPResponseMessage.setResponseCode(rTPRequestStatus.getResponseCode());
            rTSPResponseMessage.setResponseMessage(rTPRequestStatus.getResponseMessage());
            rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
            rTSPResponseMessages.addMessage(rTSPResponseMessage);
            bl = false;
        }
        if (bl) {
            if (!rTPSession.isLoggedConnect()) {
                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "rtsp", "connect", 200, rTPSession.getSessionId());
                rTPSession.setLoggedConnect(true);
            }
            int n3 = rTSPRequestMessage.getMethod();
            switch (n3) {
                case 0: {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPRequestAdapter.service: Unknown method: " + rTSPRequestMessage.getMethodString());
                    break;
                }
                case 1: {
                    RTSPCore.describe(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 2: {
                    RTSPCore.announce(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 3: {
                    RTSPCore.getParameter(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 4: {
                    RTSPCore.options(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 5: {
                    RTSPCore.pause(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 6: {
                    RTSPCore.play(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 7: {
                    RTSPCore.record(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 8: {
                    RTSPCore.redirect(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 9: {
                    RTSPCore.setup(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 10: {
                    RTSPCore.setParameter(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    break;
                }
                case 11: {
                    RTSPCore.teardown(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                    if (!rTPSession.isLoggedConnect()) break;
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "rtsp", "disconnect", 200, rTPSession.getSessionId());
                }
            }
        }
        if (rTSPResponseMessages.getMessageCount() > 0) {
            rTSPResponseMessages.serialize();
        }
    }

    public static void handleIdle(RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        block4: {
            Long l;
            long l2;
            WMSProperties wMSProperties;
            RTPSession rTPSession;
            block5: {
                boolean bl;
                IMediaStream iMediaStream;
                RTPStream rTPStream;
                rTPSession = RTSPRequestAdapter.getSessionNoCreate(rtmpRequestMessage);
                if (rTPSession == null || !rTPSession.isSessionValid() || (rTPStream = rTPSession.getRTSPStream()) == null || (iMediaStream = rTPStream.getStream()) == null || !(bl = (wMSProperties = iMediaStream.getProperties()).getPropertyBoolean("doRTSPKeepAlive", false))) break block4;
                l2 = System.currentTimeMillis();
                l = wMSProperties.getPropertyLong("RTSPKEEPALIVE_lastPing", -1L);
                if (l != -1L) break block5;
                wMSProperties.setProperty("RTSPKEEPALIVE_lastPing", new Long(l2));
                break block4;
            }
            if (l2 - l < 10000L) break block4;
            wMSProperties.setProperty("RTSPKEEPALIVE_lastPing", new Long(l2));
            try {
                System.out.println("ping: " + l2);
                RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
                rTSPResponseMessage.setCSeq(-1);
                if (rTPSession != null) {
                    rTSPResponseMessage.setSession(rTPSession.getSessionId());
                }
                RTSPResponseMessages rTSPResponseMessages = new RTSPResponseMessages(rtmpResponseMessage);
                rTSPResponseMessages.addMessage(rTSPResponseMessage);
                if (rTSPResponseMessages.getMessageCount() > 0) {
                    rTSPResponseMessages.serialize();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPCore.handleIdle: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void closeSession(IVHost iVHost, IoSession ioSession) {
        RTPContext rTPContext;
        RTPSessions rTPSessions;
        RTPSession rTPSession;
        String string;
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        if (rtmpSessionInfo != null && (string = rtmpSessionInfo.getRTSPSessionId()) != null && (rTPSession = (rTPSessions = (rTPContext = iVHost.getRTPContext()).getSessions()).getSession(string)) != null) {
            rTPSessions.notifySessionDestroy(rTPSession);
            rTPSession.shutdown();
            rTPSessions.removeSession(rTPSession);
        }
    }
}

