/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import org.apache.mina.common.ByteBuffer;

public class RtmpRequestMessage {
    public static final int REQTYPE_UNKNOWN = 0;
    public static final int REQTYPE_OPEN = 1;
    public static final int REQTYPE_SEND = 2;
    public static final int REQTYPE_IDLE = 3;
    public static final int REQTYPE_CLOSE = 4;
    public static final int REQTYPE_FCS = 5;
    public static final int REQTYPE_RTSP = 6;
    public static final String[] REQUSERAGENT_FLASH = new String[]{"Shockwave Flash", "CFNetwork", "MacNetwork/1.0 (Macintosh)"};
    private ByteBuffer body = null;
    private int protocol = 3;
    private boolean isSSL = false;
    private String vhostName = "_defaultVHost_";
    private RtmpSessionInfo sessionInfo = null;
    private long lastReadTime = 0L;
    private int type = 2;
    private int clientId = -1;
    private int sequence = -1;
    private int contentLength = 0;
    private int headerLength = 0;
    private String userAgent = "unknown";
    private HostPort hostPort = null;
    private IVHost vhost = null;
    private String fcsCommand = null;
    private String protocolStr = "HTTP/1.1";
    private String contentType = "";

    public RtmpRequestMessage() {
    }

    public RtmpRequestMessage(RtmpSessionInfo rtmpSessionInfo, String string, int n, boolean bl) {
        this.sessionInfo = rtmpSessionInfo;
        this.vhostName = string;
        this.protocol = n;
        this.isSSL = bl;
    }

    public ByteBuffer getBody() {
        return this.body;
    }

    public void setBody(ByteBuffer byteBuffer) {
        this.body = byteBuffer;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public String getVHostName() {
        return this.vhostName;
    }

    public void setVHostName(String string) {
        this.vhostName = string;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    public RtmpSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(RtmpSessionInfo rtmpSessionInfo) {
        this.sessionInfo = rtmpSessionInfo;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void setLastReadTime(long l) {
        this.lastReadTime = l;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void decodeHeader(String string, String[] stringArray, String string2) {
        String string3;
        this.type = 2;
        if (this.protocol == 32 && string != null) {
            if (stringArray == null) {
                stringArray = REQUSERAGENT_FLASH;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                this.protocol = 3;
                break;
            }
            if (this.protocol == 3 && string2 != null) {
                String[] stringArray2 = string2.split("/");
                if (stringArray2 == null) {
                    this.protocol = 32;
                } else {
                    string3 = stringArray2[0];
                    if (!(string3.equals("idle") || string3.equals("send") || string3.equals("open") || string3.equals("close") || string3.equals("fcs"))) {
                        this.protocol = 32;
                    }
                }
            }
        }
        if (this.protocol == 32) {
            if (this.protocolStr.startsWith("RTSP")) {
                this.protocol = 34;
            } else if (this.contentType.equalsIgnoreCase("application/x-rtsp-tunnelled")) {
                this.protocol = 35;
            }
        }
        if (this.protocol == 3) {
            this.type = 0;
            String[] stringArray3 = string2.split("/");
            string3 = stringArray3[0];
            if (stringArray3.length == 3) {
                this.clientId = Integer.parseInt(stringArray3[1]);
                this.sequence = Integer.parseInt(stringArray3[2]);
            }
            if (string3.equals("idle")) {
                this.type = 3;
            } else if (string3.equals("send")) {
                this.type = 2;
            } else if (string3.equals("open")) {
                this.type = 1;
            } else if (string3.equals("close")) {
                this.type = 4;
            } else if (string3.equals("fcs")) {
                this.type = 5;
                this.fcsCommand = "unknown";
                if (stringArray3.length >= 2) {
                    this.fcsCommand = stringArray3[1];
                }
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public String getFcsCommand() {
        return this.fcsCommand;
    }

    public void setFcsCommand(String string) {
        this.fcsCommand = string;
    }

    public String getProtocolStr() {
        return this.protocolStr;
    }

    public void setProtocolStr(String string) {
        this.protocolStr = string;
    }

    public boolean isHTTP10() {
        return this.protocolStr == null ? false : this.protocolStr.equals("HTTP/1.0");
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }
}

