/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.DebugUtils;
import com.wowza.util.FasterByteArrayOutputStream;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IResponseListener;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class RtmpResponseMessage {
    public static final int HTTP_STATUS_SUCCESS = 200;
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    private Map headers = null;
    private IFasterByteArrayOutputStream body = null;
    private int responseCode = 200;
    private int clientId = -1;
    private int contentLength = 0;
    private IClient client = null;
    private boolean didClose = false;
    private boolean immediateIdle = false;
    private String vhostName = "";
    private List responseListeners = new ArrayList();
    private boolean sendBody = true;
    private String protocolStr = "HTTP/1.1";

    public RtmpResponseMessage(String string) {
        this.vhostName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(IResponseListener iResponseListener) {
        List list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.add(iResponseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponseListener(IResponseListener iResponseListener) {
        List list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.remove(iResponseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponseStart() {
        ArrayList arrayList = null;
        List list = this.responseListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.responseListeners);
        }
        for (IResponseListener iResponseListener : arrayList) {
            iResponseListener.onResponseWriteStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponseStop() {
        ArrayList arrayList = null;
        List list = this.responseListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.responseListeners);
        }
        for (IResponseListener iResponseListener : arrayList) {
            iResponseListener.onResponseWriteStop(this);
        }
    }

    private void initHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap();
            this.headers.put("Cache-Control", "no-cache");
            this.headers.put("Connection", "Keep-Alive");
            this.headers.put("Server", "FlashCom/3.0.2");
            this.headers.put("Content-Type", "application/x-fcs");
        }
    }

    public void initHeadersHTTP() {
        if (this.headers == null) {
            this.headers = new HashMap();
            this.headers.put("Cache-Control", "no-cache");
            this.headers.put("Connection", "Keep-Alive");
            this.headers.put("Server", "FlashCom/3.0.2");
            this.headers.put("Content-Type", "text/html");
        }
    }

    private IFasterByteArrayOutputStream initBody() {
        if (this.body == null) {
            VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
            this.body = vHost == null ? new FasterByteArrayOutputStream(10240) : vHost.getOutputStream();
        }
        return this.body;
    }

    public void setHeader(String string, String string2) {
        this.initHeaders();
        this.headers.put(string, string2);
    }

    public Map getHeaders() {
        this.initHeaders();
        return this.headers;
    }

    public void setContentType(String string) {
        this.initHeaders();
        this.headers.put("Content-Type", string);
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void appendBody(byte[] byArray) {
        try {
            this.initBody();
            this.body.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OutputStream getOutputStream() {
        return this.initBody();
    }

    public void appendBody(String string) {
        try {
            this.initBody();
            byte[] byArray = string.getBytes();
            this.body.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ByteBuffer getBody() {
        return this.body == null ? null : this.body.toByteBuffer();
    }

    public List getBodyList() {
        return this.body == null ? new ArrayList() : this.body.getBuffers();
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.reset();
        }
        this.body = null;
    }

    public int getBodyLength() {
        return this.body == null ? 0 : this.body.size();
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public int getContentLength() {
        return this.body == null ? 0 : this.body.size();
    }

    public IClient getClient() {
        return this.client;
    }

    public void setClient(IClient iClient) {
        this.client = iClient;
    }

    public boolean isDidClose() {
        return this.didClose;
    }

    public void setDidClose(boolean bl) {
        this.didClose = bl;
    }

    public void checkContentLength() {
        if (this.getContentLength() != this.getBodyLength()) {
            WMSLoggerFactory.getLogger(RtmpResponseMessage.class).error("Bad Content Length: " + this.getContentLength() + ":" + this.getBodyLength());
            if (this.body != null) {
                WMSLoggerFactory.getLogger(RtmpResponseMessage.class).info("msg\n" + DebugUtils.formatBytes(this.body.toByteArray()));
            }
        }
    }

    public boolean isImmediateIdle() {
        return this.immediateIdle;
    }

    public void setImmediateIdle(boolean bl) {
        this.immediateIdle = bl;
    }

    public boolean isSendBody() {
        return this.sendBody;
    }

    public void setSendBody(boolean bl) {
        this.sendBody = bl;
    }

    public String getProtocolStr() {
        return this.protocolStr;
    }

    public void setProtocolStr(String string) {
        this.protocolStr = string;
    }

    public boolean isHTTP10() {
        return this.protocolStr == null ? false : this.protocolStr.equals("HTTP/1.0");
    }
}

