/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.RtmpLeftover;
import com.wowza.wms.vhost.HostPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtmpSessionInfo {
    public static final byte PROTOCOL_UNKNOWN = 0;
    public static final byte PROTOCOL_RTMP = 1;
    public static final byte PROTOCOL_RTMPT = 3;
    public static final byte PROTOCOL_MEDIACASTER = 16;
    public static final byte PROTOCOL_NETCONNECTION = 17;
    public static final byte PROTOCOL_UNKNOWNHTTP = 32;
    public static final byte PROTOCOL_HTTP = 33;
    public static final byte PROTOCOL_RTSP = 34;
    public static final byte PROTOCOL_RTSPHTTP = 35;
    public static final byte PROTOCOL_MMSH = 36;
    private boolean isOpen = false;
    private boolean isClosed = false;
    private int reqIndex = 0;
    private int clientId = -1;
    private int protocol = 0;
    private int headerLength = 0;
    private int contentLength = 0;
    private boolean isIdleRunning = false;
    private boolean isSSL = false;
    private String ipAddress = "";
    private int inHandler = 0;
    private List messageQueue = new ArrayList();
    private String path = "";
    private String userAgent = null;
    private String protocolStr = "HTTP/1.1";
    private IServer server = null;
    private HostPort hostPort = null;
    private boolean didNotifySessionOpen = false;
    private String contentType = "";
    private String rtspSessionId = null;
    private boolean isRTSPPacket = false;
    private List<RtmpLeftover> leftovers = new ArrayList<RtmpLeftover>();
    private Map<Integer, IRTPMessageHandler> rtpInterleaveHandler = new HashMap<Integer, IRTPMessageHandler>();

    public RtmpSessionInfo(boolean bl, String string) {
        this.isSSL = bl;
        this.ipAddress = string;
    }

    public void resetHeader() {
        this.headerLength = 0;
        this.contentLength = 0;
        this.path = "";
        this.userAgent = null;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean bl) {
        this.isOpen = bl;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public int getReqIndex() {
        return this.reqIndex;
    }

    public void setReqIndex(int n) {
        this.reqIndex = n;
    }

    public int incReqIndex() {
        return ++this.reqIndex;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public boolean gotHeader() {
        return this.headerLength > 0;
    }

    public int getReqSize() {
        return this.headerLength + this.contentLength;
    }

    public boolean isIdleRunning() {
        return this.isIdleRunning;
    }

    public void setIdleRunning(boolean bl) {
        this.isIdleRunning = bl;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public int getInHandler() {
        return this.inHandler;
    }

    public int incInHandler() {
        return ++this.inHandler;
    }

    public int decInHandler() {
        return --this.inHandler;
    }

    public Object getFirstMessageQueue() {
        return this.messageQueue.remove(0);
    }

    public boolean isMessageQueueEmpty() {
        return this.messageQueue.size() == 0;
    }

    public void addMessageQueue(Object object) {
        boolean bl = true;
        if (object == null && this.messageQueue.size() > 0) {
            boolean bl2 = bl = this.messageQueue.get(this.messageQueue.size() - 1) != null;
        }
        if (bl) {
            this.messageQueue.add(object);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer iServer) {
        this.server = iServer;
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    public boolean isDidNotifySessionOpen() {
        return this.didNotifySessionOpen;
    }

    public void setDidNotifySessionOpen(boolean bl) {
        this.didNotifySessionOpen = bl;
    }

    public String getProtocolStr() {
        return this.protocolStr;
    }

    public void setProtocolStr(String string) {
        this.protocolStr = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getRTSPSessionId() {
        return this.rtspSessionId;
    }

    public void setRTSPSessionId(String string) {
        this.rtspSessionId = string;
    }

    public boolean isRTSPPacket() {
        return this.isRTSPPacket;
    }

    public void setRTSPPacket(boolean bl) {
        this.isRTSPPacket = bl;
    }

    public void addLeftover(RtmpLeftover rtmpLeftover) {
        this.leftovers.add(rtmpLeftover);
    }

    public boolean isLeftover() {
        return this.leftovers.size() > 0;
    }

    public void clearLeftover() {
        this.leftovers.clear();
    }

    public List<RtmpLeftover> getLeftovers() {
        return this.leftovers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRTPMessageHandler getRTPInterleaveHandler(int n) {
        IRTPMessageHandler iRTPMessageHandler = null;
        Map<Integer, IRTPMessageHandler> map = this.rtpInterleaveHandler;
        synchronized (map) {
            iRTPMessageHandler = this.rtpInterleaveHandler.get(new Integer(n));
        }
        return iRTPMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTPInterleaveHandler(int n, IRTPMessageHandler iRTPMessageHandler) {
        Map<Integer, IRTPMessageHandler> map = this.rtpInterleaveHandler;
        synchronized (map) {
            this.rtpInterleaveHandler.put(new Integer(n), iRTPMessageHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRTPInterleaveHandler() {
        Map<Integer, IRTPMessageHandler> map = this.rtpInterleaveHandler;
        synchronized (map) {
            this.rtpInterleaveHandler.clear();
        }
    }
}

