/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.Base64;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.util.RandomIdGenerator;
import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.admin.AdminServerNotifier;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.logging.ILogNotify;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.request.RequestConnectHandshake;
import com.wowza.wms.request.RequestConnectHandshakeCryptoSingleton;
import com.wowza.wms.server.CommandInterface;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.server.JMXRemoteConfig;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.server.RtmpServerProtocolCodecFactory;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.server.ServerHandlerThreaded;
import com.wowza.wms.server.ServerShutdownHook;
import com.wowza.wms.server.ServerWatchdog;
import com.wowza.wms.server.SubCL;
import com.wowza.wms.stream.MediaIndexCacheSingleton;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.transport.udp.UDPPortManager;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.ServerUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.ThreadPool;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostItem;
import com.wowza.wms.vhost.VHostList;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class Server
implements IServer {
    public static final String DHP = "9780aaa709d35ee3239bb81ac7f785163bc76cfc8943838607e8d5845ca2328cafa4906b0a24b2aaa82c30999b57af33b69f76d34a2446a3a5d092435976f489b95229711c0cbf26ea22e502671eebbdba50fa88d01f96b9ed2db0103e69ce027f871b9a753a0e5158a79d23690ec01b2246f3a0c934b4802780d94d329bd591";
    public static final String SHAREDSECRET = "9441e67c5fb449c503c813";
    private static Server instance = null;
    public static ILogNotify logNotifier = null;
    private ServerShutdownHook shutdownHook = null;
    private AdminAgent adminAgent = null;
    private List vhosts = new ArrayList();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private ServerWatchdog serverWatchdog = null;
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private HostPort commandInterfaceHostPort = null;
    private Object commandInterface = null;
    private VHostList vhostList = new VHostList();
    private int coreTransportPoolSize = 16;
    private int coreHandlerPoolSize = 16;
    private ThreadPool transportThreadPool = null;
    private ThreadPool handlerThreadPool = null;
    private String clusterClassName = null;
    private String[] userAgents = new String[]{"Shockwave Flash", "CFNetwork"};
    private List serverListeners = new ArrayList();
    private JMXRemoteConfig jmxRemoteConfig = new JMXRemoteConfig();
    private List adminInterfaceObjectList = new ArrayList();
    private String vhostConfigurationUrl = null;
    private WMSProperties properties = new WMSProperties();
    private RandomIdGenerator clientIdGenerator = new RandomIdGenerator();
    private Properties dynamicLogProperties = null;
    private Set<String> dynamicLogContext = new HashSet<String>();
    private String guid = null;
    private UDPPortManager udpPortManager = new UDPPortManager();

    public Server() {
        this.adminInterfaceObjectList.add("Server".toLowerCase());
        this.adminInterfaceObjectList.add("VHost".toLowerCase());
        this.adminInterfaceObjectList.add("VHostItem".toLowerCase());
        this.adminInterfaceObjectList.add("Application".toLowerCase());
        this.adminInterfaceObjectList.add("ApplicationInstance".toLowerCase());
        this.adminInterfaceObjectList.add("Module".toLowerCase());
        this.adminInterfaceObjectList.add("MediaCaster".toLowerCase());
    }

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        Server.start();
    }

    private void loadConfig() {
        String string = Bootstrap.getServerXMLURL();
        if (string != null) {
            ServerUtils.loadConfigFile(this, string);
        } else {
            System.out.println("ERROR: Server.xml missing.");
        }
    }

    @NoMBean
    public static void start() {
        Server server = Server.getInstance();
        server.initLogging();
        server.loadConfig();
        server.notifyConfigLoaded();
        server.transportThreadPool = new ThreadPool(null, "ServerTransport");
        server.transportThreadPool.init(server.getCoreTransportPoolSize());
        server.handlerThreadPool = new ThreadPool(null, "ServerHandler");
        server.handlerThreadPool.init(server.getCoreHandlerPoolSize());
        server.createAdminAgent();
        server.vhostList.loadConfig();
        server.notifyServerCreate();
        server.startMediaIndexCache();
        server.startServer();
        server.startAdminAgent(server.getJmxRemoteConfig());
        server.startCommandInterface();
        server.startVHosts();
        server.startShutdownHook();
        server.notifyServerInit();
    }

    private void initLogging() {
        String string = Bootstrap.getServerLog4jPropertiesURL();
        if (string != null) {
            String string2 = System.getProperty("com.wowza.wms.logging.LogNotify");
            if (string2 != null) {
                System.out.println("Setup LogNotify class: " + string2);
                try {
                    Class<?> clazz = Class.forName(string2);
                    if (clazz != null) {
                        logNotifier = (ILogNotify)clazz.newInstance();
                        System.out.println("Setup LogNotify successful");
                    } else {
                        System.out.println("ERROR: Error creating com.wowza.wms.logging.LogNotify (" + string2 + "): Can't find class.");
                    }
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Error creating com.wowza.wms.logging.LogNotify (" + string2 + "): " + exception.toString());
                }
            }
            WMSLoggerFactory.initializeLogging(string);
        } else {
            System.out.println("ERROR: log4j.properties not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void stopServer() {
        this.notifyServerShutdownStart();
        this.stopShutdownHook();
        this.stopVHosts();
        this.stopCommandInterface();
        this.stopAdminAgent(false);
        this.stopMediaIndexCache();
        if (this.transportThreadPool != null) {
            try {
                this.transportThreadPool.terminate();
            }
            catch (Exception exception) {
            }
            finally {
                this.transportThreadPool = null;
            }
        }
        if (this.handlerThreadPool != null) {
            try {
                this.handlerThreadPool.terminate();
            }
            catch (Exception exception) {
            }
            finally {
                this.handlerThreadPool = null;
            }
        }
        this.notifyServerShutdownComplete();
        WMSLoggerFactory.getLogger(Application.class).info(null, null, "server", "server-stop", 200, null);
    }

    private void startMediaIndexCache() {
        MediaIndexCacheSingleton.getInstance().start();
    }

    private void stopMediaIndexCache() {
        MediaIndexCacheSingleton.getInstance().shutdown();
    }

    private void startShutdownHook() {
        this.shutdownHook = new ServerShutdownHook(this);
        this.shutdownHook.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.serverWatchdog = new ServerWatchdog(this, 500);
        this.serverWatchdog.setDaemon(true);
        this.serverWatchdog.start();
    }

    private void stopShutdownHook() {
        try {
            if (this.serverWatchdog != null) {
                this.serverWatchdog.halt();
            }
            this.serverWatchdog = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.shutdownHook = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getHeapSize() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        Long l3 = new Long((l - l2) / 1024L);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l3);
        stringBuffer.append(" KB");
        return stringBuffer.toString();
    }

    private void createAdminAgent() {
        this.adminAgent = new AdminAgent(this, this.vhostList);
    }

    private void startAdminAgent(JMXRemoteConfig jMXRemoteConfig) {
        if (this.adminAgent != null) {
            this.adminAgent.start(jMXRemoteConfig);
        }
    }

    public void stopAdminAgent() {
        this.stopAdminAgent(true);
    }

    private void stopAdminAgent(boolean bl) {
        if (bl) {
            AgentShutdown agentShutdown = new AgentShutdown();
            agentShutdown.setDaemon(true);
            agentShutdown.start();
        } else {
            if (this.adminAgent != null) {
                this.adminAgent.shutdown();
            }
            this.adminAgent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVHost(VHost vHost) {
        List list = this.vhosts;
        synchronized (list) {
            this.vhosts.add(vHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVHost(VHost vHost) {
        List list = this.vhosts;
        synchronized (list) {
            this.vhosts.remove(vHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getVHosts() {
        List list = this.vhosts;
        synchronized (list) {
            return new ArrayList(this.vhosts);
        }
    }

    public void suspendCommandInterface() {
        try {
            IoAcceptor ioAcceptor = (IoAcceptor)this.getCommandInterface();
            if (ioAcceptor != null) {
                Set set = ioAcceptor.getManagedServiceAddresses();
                for (SocketAddress socketAddress : set) {
                    WMSLoggerFactory.getLogger(VHost.class).info("Server.suspendCommandInterface: " + socketAddress);
                    try {
                        if (!(ioAcceptor instanceof SocketAcceptor)) continue;
                        ((SocketAcceptor)ioAcceptor).suspend(socketAddress);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(VHost.class).error("Server.suspendCommandInterface: " + socketAddress + ": " + exception.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("Server.suspendCommandInterface: " + exception.toString(), "server", "comment");
        }
    }

    public void startCommandInterface() {
        try {
            HostPort hostPort = this.getCommandInterfaceHostPort();
            if (hostPort != null) {
                InetAddress inetAddress = hostPort.getAddress();
                int n = hostPort.getPort();
                InetSocketAddress inetSocketAddress = inetAddress == null ? new InetSocketAddress(n) : new InetSocketAddress(inetAddress, n);
                SocketAcceptor socketAcceptor = new SocketAcceptor();
                SocketAcceptorConfig socketAcceptorConfig = new SocketAcceptorConfig();
                hostPort.configureSocketAcceptor(socketAcceptorConfig);
                socketAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
                socketAcceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(this.transportThreadPool.getExecutor())));
                WMSLoggerFactory.getLogger(Server.class).info("CMDInterface now listening: " + hostPort.toString(), "server", "comment");
                socketAcceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)new CommandInterface(this), (IoServiceConfig)socketAcceptorConfig);
                this.setCommandInterface(socketAcceptor);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString(), "server", "comment");
            exception.printStackTrace();
            Server.doWait();
        }
    }

    public void stopCommandInterface() {
        try {
            IoAcceptor ioAcceptor = (IoAcceptor)this.getCommandInterface();
            if (ioAcceptor != null) {
                WMSLoggerFactory.getLogger(Server.class).debug("Close CMDInterface", "server", "comment");
                ioAcceptor.unbindAll();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString(), "server", "comment");
            exception.printStackTrace();
            Server.doWait();
        }
    }

    @NoMBean
    public void startServer() {
        Object object6;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        try {
            object5 = Bootstrap.getServerHome((int)2);
            object5 = (String)object5 + File.separatorChar + "conf" + File.separatorChar + RTMPRequestAdapter.fN(ModuleConnect.getN(0));
            object4 = new File((String)object5);
            while (true) {
                object32 = "";
                if (((File)object4).exists()) {
                    object2 = new BufferedReader(new FileReader((File)object4));
                    boolean bl = true;
                    while (true) {
                        String string = ((BufferedReader)object2).readLine();
                        object6 = string;
                        if (string == null) break;
                        if (((String)(object6 = ((String)object6).trim())).length() == 0 || ((String)object6).charAt(0) == '-') continue;
                        if (((String)object32).length() == 0) {
                            object32 = (String)object32 + (String)object6;
                            continue;
                        }
                        if (bl) {
                            object32 = (String)object32 + "-";
                        }
                        bl = false;
                        object32 = (String)object32 + (String)object6;
                    }
                    ((BufferedReader)object2).close();
                    object32 = ((String)object32).toUpperCase();
                    Client.decodeS((String)object32);
                }
                if (!ApplicationUtils.isGood()) {
                    ApplicationUtils.gs((String)object32);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object5 = (Map)MediaStreamBase.sinfo.get("sl");
            if (object5 != null) {
                block12: for (Object object32 : object5.keySet()) {
                    if (!((String)object32).equals(RTMPRequestAdapter.fN(ModuleConnect.getN(16))) || (object6 = HTTPUtils.HTTPRequestToByteArray((String)(object2 = RTMPRequestAdapter.fN(ModuleConnect.getN(15))), "GET", null, null)) == null) continue;
                    String string = new String((byte[])object6);
                    List list = (List)object5.get(object32);
                    for (String string2 : list) {
                        if (!string2.equals(string)) continue;
                        MediaStreamBase.sinfo.put("slp", "1");
                        MediaStreamBase.sinfo.put("l", new Integer(-1));
                        MediaStreamBase.sinfo.put("b", new Integer(-1));
                        continue block12;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RequestConnectHandshake.serverHandshakeResponseKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(17)));
        RequestConnectHandshake.clientHandshakeSignKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(103)));
        RequestConnectHandshake.clientHandshakeResponseKey = Base64.decode(RTMPRequestAdapter.fN(ModuleConnect.getN(104)));
        RequestConnectHandshake.magicStrServer = RTMPRequestAdapter.fN(ModuleConnect.getN(24));
        RequestConnectHandshake.magicStrPlayer = RTMPRequestAdapter.fN(ModuleConnect.getN(25));
        RequestConnectHandshake.dhpKeyStr = RTMPRequestAdapter.fN(ModuleConnect.getN(26));
        RequestConnectHandshake.initHandshake();
        try {
            object5 = null;
            object4 = null;
            object32 = "_defaultVHost_";
            object2 = WMSLoggerFactory.getLogger(Server.class);
            ((WMSLogger)((Object)object2)).info(null, null, "server", "server-start", 200, MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber());
            object6 = (String)MediaStreamBase.sinfo.get("ss");
            ((WMSLogger)((Object)object2)).info(RTMPRequestAdapter.fN(ModuleConnect.getN(3)) + ": " + RTMPRequestAdapter.fN(ModuleConnect.getN(6)) + ((String)object6).substring(((String)object6).length() - 5, ((String)object6).length()), "server", "comment");
            String string = "";
            int n = (Integer)MediaStreamBase.sinfo.get("l");
            int n2 = (Integer)MediaStreamBase.sinfo.get("b");
            if (n >= 0) {
                string = n + "";
                if (n != n2) {
                    string = n + " (" + n2 + " burst)";
                }
            }
            ((WMSLogger)((Object)object2)).info(RTMPRequestAdapter.fN(ModuleConnect.getN(4)) + ": " + (ApplicationUtils.isGood() ? ((Integer)MediaStreamBase.sinfo.get("l") == -1 ? RTMPRequestAdapter.fN(ModuleConnect.getN(5)) : string) : "0"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Hardware Available Processors: " + Runtime.getRuntime().availableProcessors(), "server", "comment");
            if (AdminAgent.isMBeanServerRunning()) {
                long l = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", -1L);
                long l2 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "TotalSwapSpaceSize", -1L);
                long l3 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "FreePhysicalMemorySize", -1L);
                long l4 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "FreeSwapSpaceSize", -1L);
                if (l > 0L && l3 > 0L) {
                    ((WMSLogger)((Object)object2)).info("Hardware Physical Memory: " + l3 / 0x100000L + "MB" + "/" + l / 0x100000L + "MB", "server", "comment");
                }
                if (l2 > 0L && l4 > 0L) {
                    ((WMSLogger)((Object)object2)).info("Hardware Swap Space: " + l4 / 0x100000L + "MB" + "/" + l2 / 0x100000L + "MB", "server", "comment");
                }
                long l5 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "MaxFileDescriptorCount", -1L);
                ((WMSLogger)((Object)object2)).info("Max File Descriptor Count: " + (l5 <= 0L ? "Unlimited" : Long.valueOf(l5)), "server", "comment");
                if (l5 > 0L) {
                    long l6 = AdminAgent.getMBeanValueLong("java.lang:type=OperatingSystem", "OpenFileDescriptorCount", -1L);
                    ((WMSLogger)((Object)object2)).info("Open File Descriptor Count: " + l6, "server", "comment");
                }
            }
            ((WMSLogger)((Object)object2)).info("OS Name: " + System.getProperty("os.name"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("OS Version: " + System.getProperty("os.version"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("OS Architecture: " + System.getProperty("os.arch"), "server", "comment");
            if (System.getProperty("sun.cpu.isalist") != null) {
                try {
                    String string3 = System.getProperty("sun.cpu.isalist");
                    if (string3.length() > 0) {
                        ((WMSLogger)((Object)object2)).info("OS CPU: " + string3, "server", "comment");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((WMSLogger)((Object)object2)).info("Java Name: " + System.getProperty("java.vm.name"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Vendor: " + System.getProperty("java.vm.vendor"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Version: " + System.getProperty("java.version"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java VM Version: " + System.getProperty("java.vm.version"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Spec Version: " + System.getProperty("java.specification.version"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Home: " + System.getProperty("java.home"), "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Max Heap Size: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB", "server", "comment");
            ((WMSLogger)((Object)object2)).info("Java Architecture: " + System.getProperty("sun.arch.data.model"), "server", "comment");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + exception.toString());
            exception.printStackTrace();
            Server.doWait();
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            object32 = (String)MediaStreamBase.sinfo.get("s");
            object2 = (BigInteger)MediaStreamBase.sinfo.get("k");
            object6 = RTMPRequestAdapter.fS(((BigInteger)object2).toByteArray(), (String)object32);
            bl = ((String)object6).indexOf("s=" + RTMPRequestAdapter.fN(ModuleConnect.getN(64))) >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object32 = (Map)MediaStreamBase.sinfo.get("sl");
        if (object32 != null) {
            for (Object object6 : object32.keySet()) {
                if (!((String)object6).equals(RTMPRequestAdapter.fN(ModuleConnect.getN(64)))) continue;
                bl2 = true;
                byte[] byArray = new byte[ModuleConnect.lc.length];
                System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
                BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
                BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
                byte[] byArray2 = bigInteger.toByteArray();
                byte[] byArray3 = bigInteger2.toByteArray();
                for (int i = 0; i < byArray.length; ++i) {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
                }
                SubCL subCL = new SubCL();
                subCL.cs(byArray);
                byte[] byArray4 = new byte[ModuleConnect.lc.length];
                System.arraycopy(ModuleConnect.lc, 0, byArray4, 0, ModuleConnect.lc.length);
                for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                    int n = i;
                    byArray4[n] = (byte)(byArray4[n] ^ byArray2[(i + 11) % byArray2.length]);
                    int n3 = i;
                    byArray4[n3] = (byte)(byArray4[n3] ^ byArray3[(i + 8) % byArray3.length]);
                    if (byArray4[i] == byArray[i]) continue;
                    System.exit(1);
                }
            }
        }
        if (bl != bl2) {
            System.exit(1);
        }
    }

    public String getVersion() {
        return MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber();
    }

    public void reloadVHostConfig() {
        try {
            this.vhostList.reloadConfig();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("reloadVHostConfig: " + exception.toString());
        }
    }

    public void stopVHost(String string) {
        try {
            Map map2;
            VHost vHost = (VHost)VHostSingleton.getInstance(string, false);
            if (vHost == null) {
                WMSLoggerFactory.getLogger(Server.class).error("vhost not found: " + string, "server", "comment");
                return;
            }
            WMSLoggerFactory.getLogger(Server.class).debug("Shutdown vhost: " + string, "vhost", "comment");
            vHost.setShuttingDown(true);
            List list = vHost.getSessions();
            WMSLoggerFactory.getLogger(Server.class).debug("Close sessions: " + list.size(), "server", "comment");
            for (Map map2 : list) {
                map2.close();
            }
            map2 = vHost.getAcceptors();
            WMSLoggerFactory.getLogger(Server.class).debug("Close acceptors: " + map2.size(), "server", "comment");
            for (HostPort hostPort : map2.keySet()) {
                Map map3 = (Map)map2.get(hostPort);
                IoAcceptor ioAcceptor = (IoAcceptor)map3.get("acceptor");
                ioAcceptor.unbindAll();
                vHost.removeAcceptor(hostPort);
                IHTTPProvider iHTTPProvider = hostPort.getHttpProvider();
                if (iHTTPProvider == null) continue;
                iHTTPProvider.onUnbind(vHost, hostPort);
            }
            vHost.stopWinMedia();
            VHostSingleton.shutdown(string);
            this.removeVHost(vHost);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("Problem shutting down: " + exception.toString());
            exception.printStackTrace();
            Server.doWait();
        }
    }

    public void stopVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            this.stopVHost(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void startVHost(String var1_1) {
        var2_2 = null;
        var3_3 = null;
        try {
            var4_4 = this.vhostList.getVHostMap().get(var1_1);
            if (var4_4 == null) {
                WMSLoggerFactory.getLogger(Server.class).error("vhost not found: " + var1_1, "server", "comment");
                return;
            }
            var5_6 = var4_4.getConfigDir();
            VHostSingleton.setServer(this);
            var6_7 = (VHost)VHostSingleton.getInstance(var1_1, true);
            WMSLoggerFactory.getLogger(Server.class).info("vhost home directory: " + var5_6, "server", "comment");
            var6_7.setServer(this);
            var6_7.setConnectionLimit(var4_4.getConnectionLimit());
            VHostSingleton.init(var1_1, var5_6);
            var7_8 = var6_7.getHostPortsList();
            var8_9 = 0;
            var9_10 = 0;
            try {
                var10_11 = (String)MediaStreamBase.sinfo.get("s");
                var11_13 = (BigInteger)MediaStreamBase.sinfo.get("k");
                var12_14 = RTMPRequestAdapter.fS(var11_13.toByteArray(), (String)var10_11);
                var8_9 = var12_14.indexOf("s=" + RTMPRequestAdapter.fN(ModuleConnect.getN(64))) >= 0 ? 1 : 0;
            }
            catch (Exception var10_12) {
                // empty catch block
            }
            var10_11 = (Map)MediaStreamBase.sinfo.get("sl");
            if (var10_11 != null) {
                for (Object var12_14 : var10_11.keySet()) {
                    if (!var12_14.equals(RTMPRequestAdapter.fN(ModuleConnect.getN(64)))) continue;
                    var9_10 = 1;
                    var13_15 = (List)var10_11.get(var12_14);
                    var14_17 = null;
                    var15_22 = var13_15;
                    synchronized (var15_22) {
                        var14_17 = (byte[])var13_15.get(0);
                    }
                    var15_22 = (BigInteger)MediaStreamBase.sinfo.get("r1");
                    var16_24 = (BigInteger)MediaStreamBase.sinfo.get("r2");
                    var17_26 = var15_22.toByteArray();
                    var18_30 /* !! */  = var16_24.toByteArray();
                    var19_31 /* !! */  = new byte[ModuleConnect.lc.length];
                    System.arraycopy(ModuleConnect.lc, 0, var19_31 /* !! */ , 0, ModuleConnect.lc.length);
                    for (var20_33 = 0; var20_33 < ModuleConnect.lc.length; ++var20_33) {
                        v0 = var19_31 /* !! */ ;
                        v1 = var20_33;
                        v0[v1] = (byte)(v0[v1] ^ var17_26[(var20_33 + 11) % ((Object)var17_26).length]);
                        v2 = var19_31 /* !! */ ;
                        v3 = var20_33;
                        v2[v3] = (byte)(v2[v3] ^ var18_30 /* !! */ [(var20_33 + 8) % var18_30 /* !! */ .length]);
                        if (var19_31 /* !! */ [var20_33] == var14_17[var20_33]) continue;
                        System.exit(1);
                    }
                }
            }
            if (var8_9 != var9_10) {
                System.exit(1);
            }
            var8_9 = var7_8.size();
            for (var9_10 = 0; var9_10 < var8_9; ++var9_10) {
                block50: {
                    block52: {
                        block56: {
                            block55: {
                                block54: {
                                    block53: {
                                        block51: {
                                            var10_11 = var7_8.get(var9_10);
                                            if (var10_11 == null) continue;
                                            var11_13 = var10_11.getAddress();
                                            var12_14 = (List)MediaStreamBase.sinfo.get("maf");
                                            if (var12_14 != null) {
                                                block48: {
                                                    var13_16 = false;
                                                    var14_19 = var11_13;
                                                    try {
                                                        if (var14_19 == null) {
                                                            var14_19 = InetAddress.getLocalHost();
                                                        }
                                                        if ((var15_22 = NetworkInterface.getByInetAddress((InetAddress)var14_19)) == null) {
                                                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(18)));
                                                            System.exit(1);
                                                            break block48;
                                                        }
                                                        var16_24 = var15_22.getClass();
                                                        if (var16_24 == null) {
                                                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(19)));
                                                            System.exit(1);
                                                            break block48;
                                                        }
                                                        var17_26 = var16_24.getMethod("getHardwareAddress", new Class[0]);
                                                        if (var17_26 == null) {
                                                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(20)));
                                                            System.exit(1);
                                                            break block48;
                                                        }
                                                        var18_30 /* !! */  = (byte[])var17_26.invoke(var15_22, new Object[0]);
                                                        if (var18_30 /* !! */  == null) {
                                                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(21)));
                                                            System.exit(1);
                                                            break block48;
                                                        }
                                                        var19_31 /* !! */  = (byte[])var12_14.iterator();
                                                        while (var19_31 /* !! */ .hasNext()) {
                                                            var20_35 = (List)var19_31 /* !! */ .next();
                                                            var21_36 = var20_35.iterator();
                                                            var22_40 = true;
                                                            var23_41 = 0;
                                                            while (var21_36.hasNext()) {
                                                                var24_42 = (String)var21_36.next();
                                                                if (var24_42.equals("*")) {
                                                                    ++var23_41;
                                                                    continue;
                                                                }
                                                                var25_43 = Integer.parseInt(var24_42, 16);
                                                                if (var25_43 != (var18_30 /* !! */ [var23_41] & 255)) {
                                                                    var22_40 = false;
                                                                }
                                                                ++var23_41;
                                                            }
                                                            if (var23_41 != var18_30 /* !! */ .length) {
                                                                System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(22)));
                                                                System.exit(1);
                                                                var22_40 = false;
                                                            } else {
                                                                if (!var22_40) continue;
                                                                var13_16 = true;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    catch (Exception var15_23) {
                                                        var13_16 = false;
                                                    }
                                                    if (!var13_16) {
                                                        System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(22)));
                                                        System.exit(1);
                                                    }
                                                }
                                                if (!var13_16) {
                                                    var15_22 = null;
                                                    var15_22.substring(0);
                                                }
                                            }
                                            if ((var13_15 = (List)MediaStreamBase.sinfo.get("i")) == null) break block50;
                                            var14_20 = false;
                                            if (var11_13 != null) break block51;
                                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(7)));
                                            System.exit(1);
                                            break block52;
                                        }
                                        var15_22 = var11_13.getAddress();
                                        if (var15_22 != null) break block53;
                                        System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(7)));
                                        System.exit(1);
                                        break block52;
                                    }
                                    if (!var11_13.isAnyLocalAddress()) break block54;
                                    System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(8)));
                                    System.exit(1);
                                    break block52;
                                }
                                if (!var11_13.isLinkLocalAddress()) break block55;
                                System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(9)));
                                System.exit(1);
                                break block52;
                            }
                            if (!var11_13.isLoopbackAddress()) break block56;
                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(10)));
                            System.exit(1);
                            break block52;
                        }
                        var16_24 = (Class<?>)new int[((Object)var15_22).length];
                        for (var17_27 = 0; var17_27 < ((Object)var15_22).length; ++var17_27) {
                            var16_24[var17_27] = var15_22[var17_27] & 255;
                        }
                        if (((Object)var15_22).length != 4) ** GOTO lbl-1000
                        if (var16_24[0] == 10) {
                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else if (var16_24[0] == 172 && var16_24[1] >= 16 && var16_24[1] <= 31) {
                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else if (var16_24[0] == 192 && var16_24[1] == 168) {
                            System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(11)));
                            System.exit(1);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var17_28 = var13_15.iterator();
                            while (var17_28.hasNext()) {
                                var18_30 /* !! */  = (byte[])((int[])var17_28.next());
                                if (var18_30 /* !! */ .length == ((Object)var15_22).length * 2) {
                                    var14_20 = true;
                                    for (var19_32 = 0; var19_32 < ((Object)var15_22).length; ++var19_32) {
                                        if (var16_24[var19_32] >= var18_30 /* !! */ [var19_32] && var16_24[var19_32] <= var18_30 /* !! */ [((Object)var15_22).length + var19_32]) continue;
                                        var14_20 = false;
                                        break;
                                    }
                                    if (!var14_20) continue;
                                    break;
                                }
                                System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(12)));
                                System.exit(1);
                                break;
                            }
                            if (!var14_20) {
                                System.out.println(RTMPRequestAdapter.fN(ModuleConnect.getN(13)));
                                System.exit(1);
                            }
                        }
                    }
                    if (!var14_20) {
                        var15_22 = null;
                        var15_22.substring(0);
                    }
                }
                var14_21 = var10_11.getPort();
                var15_22 = var10_11.getSslFactoryClass();
                var16_24 = var11_13 == null ? new InetSocketAddress(var14_21) : new InetSocketAddress((InetAddress)var11_13, var14_21);
                var2_2 = new SocketAcceptor(var10_11.getProcessorCount());
                var3_3 = new SocketAcceptorConfig();
                var10_11.configureSocketAcceptor(var3_3);
                v4 = var17_29 = var15_22.length() > 0;
                if (var17_29) {
                    this.addSSLSupport(var3_3.getFilterChain(), (String)var15_22);
                }
                var3_3.setThreadModel(ThreadModel.MANUAL);
                var3_3.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(var6_7.getTransportThreadPool().getExecutor())));
                var3_3.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RtmpServerProtocolCodecFactory()));
                WMSLoggerFactory.getLogger(Server.class).info((var15_22.length() > 0 ? "RTMPS" : "RTMP/RTMPT") + " bind attempt (" + var10_11.toString() + ")", "vhost", "comment", 200, var1_1);
                var18_30 /* !! */  = (byte[])new ServerHandler(var1_1, var17_29, (HostPort)var10_11, this);
                var19_31 /* !! */  = new ServerHandlerThreaded((ServerHandler)var18_30 /* !! */ , var6_7.getHandlerThreadPool().getExecutor());
                var20_33 = 0;
                while (true) {
                    try {
                        var2_2.bind((SocketAddress)var16_24, (IoHandler)var19_31 /* !! */ , (IoServiceConfig)var3_3);
                        WMSLoggerFactory.getLogger(Server.class).info("Bind successful (" + var10_11.toString() + ")", "vhost", "comment", 200, var1_1);
                        break;
                    }
                    catch (BindException var21_37) {
                        WMSLoggerFactory.getLogger(Server.class).warn("Bind failed, try again (" + var10_11.toString() + "): " + var21_37.toString(), "vhost", "comment", 200, var1_1);
                    }
                    catch (Exception var21_38) {
                        WMSLoggerFactory.getLogger(Server.class).warn("Bind failed: (" + var10_11.toString() + "): " + var21_38.toString(), "vhost", "comment", 200, var1_1);
                        break;
                    }
                    var20_33 = 1;
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (Exception var21_39) {}
                }
                var6_7.addAcceptor((HostPort)var10_11, (IoAcceptor)var2_2, (IoHandlerAdapter)var19_31 /* !! */ );
                var21_36 = var10_11.getHttpProvider();
                if (var21_36 == null) continue;
                var21_36.onBind(var6_7, (HostPort)var10_11);
            }
            this.addVHost(var6_7);
            var6_7.startWinMedia();
        }
        catch (Exception var4_5) {
            WMSLoggerFactory.getLogger(Server.class).error("server core failure: " + var4_5.toString());
            var4_5.printStackTrace();
            Server.doWait();
        }
    }

    public boolean isSuspended() {
        boolean bl = true;
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            if (iVHost.isSuspended()) continue;
            bl = false;
        }
        return bl;
    }

    public void suspendServer() {
        this.suspendCommandInterface();
        this.suspendAllVHosts();
    }

    public void suspendAllVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            WMSLoggerFactory.getLogger(VHost.class).info("Server.suspendAllVHosts: vhost: " + iVHost.getName());
            iVHost.suspendAllHostPorts();
        }
    }

    public void unbindAllVHosts() {
        List list = VHostSingleton.getVHostNames();
        for (String string : list) {
            IVHost iVHost = VHostSingleton.getInstance(string);
            WMSLoggerFactory.getLogger(VHost.class).info("Server.unbindAllVHosts: vhost: " + iVHost.getName());
            iVHost.unbindAllHostPorts();
        }
    }

    public void startVHosts() {
        List<VHostItem> list = this.vhostList.getVHostItems();
        for (VHostItem vHostItem : list) {
            String string = vHostItem.getName();
            this.startVHost(string);
        }
    }

    private void addSSLSupport(DefaultIoFilterChainBuilder defaultIoFilterChainBuilder, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getMethod("getInstance", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{new Boolean(true)};
                    SSLContext sSLContext = (SSLContext)method.invoke(null, objectArray);
                    SSLFilter sSLFilter = new SSLFilter(sSLContext);
                    defaultIoFilterChainBuilder.addLast("sslFilter", (IoFilter)sSLFilter);
                } else {
                    WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: factory class missing getInstance(boolean) method: " + string);
                }
            } else {
                WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: missing factory class: " + string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Server.class).error("addSSLSupport: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void doWait() {
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void doWatchdog() {
        this.updateIOPerformance();
        MediaIndexCacheSingleton.getInstance().doWatchdog();
        Map map = (Map)MediaStreamBase.sinfo.get("sl");
        if (map != null) {
            for (String string : map.keySet()) {
                if (!string.equals(RTMPRequestAdapter.fN(ModuleConnect.getN(64)))) continue;
                List list = (List)map.get(string);
                SubCL subCL = null;
                List list2 = list;
                synchronized (list2) {
                    if (list.size() > 1) {
                        subCL = (SubCL)list.get(1);
                    }
                }
                if (subCL == null) continue;
                subCL.pg();
            }
        }
    }

    @NoMBean
    public IOPerformanceCounter updateIOPerformance() {
        List list = this.getVHosts();
        Iterator iterator = list.iterator();
        IOPerformanceCounter iOPerformanceCounter = new IOPerformanceCounter();
        while (iterator.hasNext()) {
            VHost vHost = (VHost)iterator.next();
            iOPerformanceCounter.add(vHost.updateIOPerformance());
        }
        this.ioPerformanceCounter.doSet(iOPerformanceCounter);
        return this.ioPerformanceCounter;
    }

    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @NoMBean
    public void setIoPerformanceCounter(IOPerformanceCounter iOPerformanceCounter) {
        this.ioPerformanceCounter = iOPerformanceCounter;
    }

    @NoMBean
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @NoMBean
    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @NoMBean
    public void onNewVHost(IVHost iVHost) {
        ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
        iVHost.getConnectionCounter().addConnectionListener(connectionNotifier);
    }

    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    @NoMBean
    public HostPort getCommandInterfaceHostPort() {
        return this.commandInterfaceHostPort;
    }

    @NoMBean
    public void setCommandInterfaceHostPort(HostPort hostPort) {
        this.commandInterfaceHostPort = hostPort;
    }

    @NoMBean
    public Object getCommandInterface() {
        return this.commandInterface;
    }

    @NoMBean
    public void setCommandInterface(Object object) {
        this.commandInterface = object;
    }

    public String[] getUserAgents() {
        return this.userAgents;
    }

    public void setUserAgents(String[] stringArray) {
        this.userAgents = stringArray;
    }

    @NoMBean
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addServerListener(IServerNotify iServerNotify) {
        List list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.add(iServerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeServerListener(IServerNotify iServerNotify) {
        List list = this.serverListeners;
        synchronized (list) {
            this.serverListeners.remove(iServerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyConfigLoaded() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            if (!(iServerNotify instanceof IServerNotify2)) continue;
            ((IServerNotify2)iServerNotify).onServerConfigLoaded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerCreate() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerCreate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerInit() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerInit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerShutdownStart() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerShutdownStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void notifyServerShutdownComplete() {
        ArrayList arrayList = null;
        List list = this.serverListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.serverListeners);
        }
        for (IServerNotify iServerNotify : arrayList) {
            iServerNotify.onServerShutdownComplete(this);
        }
    }

    @NoMBean
    public JMXRemoteConfig getJmxRemoteConfig() {
        return this.jmxRemoteConfig;
    }

    @NoMBean
    public List getAdminInterfaceObjectList() {
        return this.adminInterfaceObjectList;
    }

    public int getCoreTransportPoolSize() {
        return this.coreTransportPoolSize;
    }

    public void setCoreTransportPoolSize(int n) {
        this.coreTransportPoolSize = n;
    }

    public int getCoreHandlerPoolSize() {
        return this.coreHandlerPoolSize;
    }

    public void setCoreHandlerPoolSize(int n) {
        this.coreHandlerPoolSize = n;
    }

    @NoMBean
    public ThreadPool getThreadPool() {
        return this.getHandlerThreadPool();
    }

    @NoMBean
    public ThreadPool getTransportThreadPool() {
        return this.transportThreadPool;
    }

    @NoMBean
    public ThreadPool getHandlerThreadPool() {
        return this.handlerThreadPool;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public RandomIdGenerator getClientIdGenerator() {
        return this.clientIdGenerator;
    }

    public Properties getDynamicLogProperties() {
        return this.dynamicLogProperties;
    }

    public void setDynamicLogProperties(Properties properties) {
        this.dynamicLogProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDynamicLogContextLoaded(String string) {
        boolean bl = false;
        Set<String> set = this.dynamicLogContext;
        synchronized (set) {
            bl = !this.dynamicLogContext.add(string);
        }
        return bl;
    }

    public VHostList getVHostList() {
        return this.vhostList;
    }

    public String getGUID() {
        String string = this.guid;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        if (string == null) {
            String string2 = Bootstrap.getServerHome((int)2);
            string2 = string2 + File.separatorChar + "conf" + File.separatorChar + RTMPRequestAdapter.fN(ModuleConnect.getN(114));
            try {
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        string = string3;
                    }
                }
                if (string == null) {
                    string = UUID.randomUUID().toString();
                    printWriter = new PrintWriter(new FileOutputStream(file, false));
                    printWriter.println(string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("Server.getGUID: File error[" + string2 + "]: " + exception.toString());
            }
            if (string != null) {
                this.guid = string;
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
            if (printWriter != null) {
                printWriter.close();
            }
            printWriter = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("Server.getGUID: Close error: " + exception.toString());
        }
        return string;
    }

    public UDPPortManager getUDPPortManager() {
        return this.udpPortManager;
    }

    public int getCryptoPoolMaxSize() {
        return RequestConnectHandshakeCryptoSingleton.getCryptoPoolMaxSize();
    }

    public int getCryptoPoolActiveCount() {
        return RequestConnectHandshakeCryptoSingleton.getCryptoPoolActiveCount();
    }

    class AgentShutdown
    extends Thread
    implements Runnable {
        AgentShutdown() {
        }

        public void run() {
            WMSLoggerFactory.getLogger(null).info("Server.AgentShutdown.run: Shutdown admin agent");
            Server.this.stopAdminAgent(false);
        }
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private Server server = null;
        private byte[] control = null;

        public ConnectionNotifier(Server server2) {
            this.server = server2;
            this.control = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray = bigInteger.toByteArray();
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                int n = i;
                this.control[n] = (byte)(this.control[n] ^ byArray[(i + 11) % byArray.length]);
            }
        }

        private void checkLicense(byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("Server checkLicense exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(1);
            }
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.incrementAccept(connectionHolder, date, l, byArray);
            this.checkLicense(byArray);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.incrementReject(connectionHolder, n, date, l, byArray);
            this.checkLicense(byArray);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.server.connectionCounter.decrement(connectionHolder, bl, date, l, byArray);
            this.checkLicense(byArray);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private IServer server = null;
        private long burstTime = -1L;
        private static final long BURSTTIMEOUT = 1200000L;

        public ConnectionValidator(IServer iServer) {
            this.server = iServer;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            boolean bl;
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 1) % byArray2.length]);
            }
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger2.toByteArray(), string);
            String string3 = (String)MediaStreamBase.sinfo.get("slp");
            long l = 0L;
            long l2 = 0L;
            String[] stringArray = string2.split("[|]");
            for (bl = false; bl < stringArray.length; bl += 1) {
                String[] stringArray2 = stringArray[bl].split("[=]");
                if (stringArray2.length != 2) continue;
                try {
                    if (stringArray2[0].equals("c" + string3)) {
                        l = Long.parseLong(stringArray2[1]);
                        continue;
                    }
                    if (!stringArray2[0].equals("b" + string3)) continue;
                    l2 = Long.parseLong(stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error(exception.toString());
                }
            }
            if (l == 0L || l2 == 0L) {
                System.exit(1);
            }
            bl = l == -1L;
            boolean bl2 = false;
            long l3 = 0L;
            if (!bl) {
                l3 = this.server.getConnectionCounter().getCurrent();
                if (l3 < l) {
                    bl = true;
                    this.burstTime = -1L;
                } else if (l3 >= l2) {
                    bl = false;
                } else {
                    long l4 = System.currentTimeMillis();
                    bl2 = true;
                    bl = true;
                    if (this.burstTime == -1L) {
                        this.burstTime = l4;
                    } else {
                        long l5 = l4 - this.burstTime;
                        if (l5 > 1200000L) {
                            bl = false;
                        }
                    }
                }
            }
            if (!bl) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.ErrorServerLicenseLimit");
            } else if (bl2) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.WarningServerLicenseLimit");
                WMSLoggerFactory.getLogger(null).warn(l3 + 1L + " of " + l2, "server", "connect-burst");
            }
            return bl;
        }
    }
}

