/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.http.HTTPRequestAdapter;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.IWriteListener;
import org.apache.mina.transport.socket.nio.FastMinaMessage;

public class ServerHandler
extends IoHandlerAdapter {
    public static final String WMSSESSIONINFO = "wmsSessionInfo";
    private String vhostName = "_defaultVHost_";
    private boolean isSecure = false;
    private IServer server = null;
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private HostPort hostPort = null;
    private IVHost vhost = null;

    public static BigInteger sDecode(String string, int n) {
        string = string.replace("R", "2");
        string = string.replace("T", "0");
        string = string.replace("U", "O");
        string = string.replace("V", "I");
        string = string.replace("W", "L");
        string = string.replace("X", "1");
        string = string.replace("Y", "5");
        return new BigInteger(string, n);
    }

    public static int dDecode(String string, int n) {
        string = string.replace("R", "2");
        string = string.replace("T", "0");
        string = string.replace("U", "O");
        string = string.replace("V", "I");
        string = string.replace("W", "L");
        string = string.replace("X", "1");
        string = string.replace("Y", "5");
        return Integer.parseInt(string, n);
    }

    public ServerHandler(String string, boolean bl, HostPort hostPort, IServer iServer) {
        this.vhostName = string;
        this.isSecure = bl;
        this.server = iServer;
        this.hostPort = hostPort;
    }

    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    public void sessionClosed(IoSession ioSession) {
        Object object;
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        int n = rtmpSessionInfo.getProtocol();
        if (rtmpSessionInfo.isOpen() && n == 1) {
            object = new RtmpResponseMessage(this.vhostName);
            RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
            rtmpRequestMessage.setType(4);
            rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
            WMSLoggerFactory.getLogger(VHost.class).debug("sessionClosed: send close");
            this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, (RtmpResponseMessage)object);
        }
        object = (VHost)VHostSingleton.getInstance(this.vhostName);
        ((VHost)object).removeSession(ioSession);
        if (n == 34) {
            RTSPRequestAdapter.closeSession((IVHost)object, ioSession);
        }
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
            String string = "127.0.0.1";
            SocketAddress socketAddress = ioSession.getRemoteAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                string = inetSocketAddress.getAddress().toString().replace("/", "");
            }
            rtmpSessionInfo.setIpAddress(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ServerHandler.class).error("sessionOpened: " + exception.toString());
        }
    }

    public void sessionCreated(IoSession ioSession) {
        RtmpSessionInfo rtmpSessionInfo = new RtmpSessionInfo(this.isSecure, "unknown");
        ioSession.setAttribute(WMSSESSIONINFO, (Object)rtmpSessionInfo);
        rtmpSessionInfo.setServer(this.server);
        rtmpSessionInfo.setHostPort(this.hostPort);
        VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
        vHost.addSession(ioSession);
        this.vhost = vHost;
    }

    private void handleMessageReceived(RtmpSessionInfo rtmpSessionInfo, IoSession ioSession, Object object) {
        Object object2;
        Object object3;
        int n = rtmpSessionInfo.getProtocol();
        if (!rtmpSessionInfo.isIdleRunning()) {
            if (n == 1) {
                ioSession.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, 500L);
            } else {
                ioSession.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, 10000L);
            }
            rtmpSessionInfo.setIdleRunning(true);
        }
        if (!rtmpSessionInfo.isOpen() && !rtmpSessionInfo.isClosed()) {
            Object object4;
            Object object5;
            object3 = (String)MediaStreamBase.sinfo.get("s");
            object2 = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string = RTMPRequestAdapter.fS(((BigInteger)object2).toByteArray(), (String)object3);
            if (string.indexOf("d=") >= 0) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                object5 = string.split("[|]");
                for (n2 = 0; n2 < ((String[])object5).length; ++n2) {
                    String[] stringArray = object5[n2].split("[=]");
                    if (stringArray.length != 2 || !stringArray[0].equals("d") || ((String[])(object4 = stringArray[1].split("[-]"))).length != 2) continue;
                    n3 = Integer.parseInt("20" + object4[0]);
                    n4 = Integer.parseInt("20" + (String)object4[1]);
                }
                n2 = Integer.parseInt(FastDateFormat.getInstance((String)"yyyyMMdd").format(new Date()));
                if (n2 < n3 || n2 > n4) {
                    WMSLoggerFactory.getLogger(ServerHandler.class).error("Timebomb: Exiting");
                    System.exit(0);
                }
                if (!ApplicationUtils.isGood()) {
                    WMSLoggerFactory.getLogger(ServerHandler.class).error("Invalid license");
                    System.exit(0);
                }
            }
            Client client = null;
            if (n == 1) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                object5 = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
                ((RtmpRequestMessage)object5).setType(1);
                ((RtmpRequestMessage)object5).setClientId(-1);
                this.serviceRequest(ioSession, rtmpSessionInfo, (RtmpRequestMessage)object5, rtmpResponseMessage);
                RtmpRequestMessage rtmpRequestMessage = (RtmpRequestMessage)object;
                int n5 = rtmpResponseMessage.getClientId();
                rtmpSessionInfo.setClientId(n5);
                rtmpRequestMessage.setClientId(n5);
                object4 = (VHost)VHostSingleton.getInstance(this.vhostName);
                client = (Client)((VHost)object4).getClient(n5);
                if (client != null) {
                    client.setIoSession(ioSession);
                    ioSession.addWriteListener((IWriteListener)client.getWriteListener());
                }
            }
            VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
            vHost.notifySessionOpen(ioSession, n, client);
            rtmpSessionInfo.setOpen(true);
        }
        object3 = (RtmpRequestMessage)object;
        object2 = new RtmpResponseMessage(this.vhostName);
        ((RtmpRequestMessage)object3).setVHostName(this.vhostName);
        if (n == 1) {
            ((RtmpRequestMessage)object3).setClientId(rtmpSessionInfo.getClientId());
        }
        ((RtmpResponseMessage)object2).setProtocolStr(((RtmpRequestMessage)object3).getProtocolStr());
        this.ioPerformanceCounter.incrementMessagesIn(((RtmpRequestMessage)object3).getContentLength());
        this.serviceRequest(ioSession, rtmpSessionInfo, (RtmpRequestMessage)object3, (RtmpResponseMessage)object2);
    }

    private void handleSessionIdle(RtmpSessionInfo rtmpSessionInfo, IoSession ioSession) {
        int n = rtmpSessionInfo.getProtocol();
        if (n == 1) {
            if (rtmpSessionInfo.isOpen()) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
                rtmpRequestMessage.setType(3);
                rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
                rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
                this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
            }
        } else if (n == 34) {
            if (rtmpSessionInfo.isOpen()) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 34, this.isSecure);
                rtmpRequestMessage.setType(3);
                rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
                this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
            }
        } else {
            ioSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession ioSession, Object object) {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        Object object2 = ioSession;
        synchronized (object2) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(object);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object2 = object;
        while (true) {
            if (object2 == null) {
                this.handleSessionIdle(rtmpSessionInfo, ioSession);
            } else {
                this.handleMessageReceived(rtmpSessionInfo, ioSession, object2);
            }
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                boolean bl;
                boolean bl2 = bl = object2 == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object2 = rtmpSessionInfo.getFirstMessageQueue();
                if (object2 == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        Object object = ioSession;
        synchronized (object) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(null);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object = null;
        while (true) {
            if (object == null) {
                this.handleSessionIdle(rtmpSessionInfo, ioSession);
            } else {
                this.handleMessageReceived(rtmpSessionInfo, ioSession, object);
            }
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                boolean bl;
                boolean bl2 = bl = object == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object = rtmpSessionInfo.getFirstMessageQueue();
                if (object == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(ServerHandler.class);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug("ServerHandler.exceptionCaught: " + throwable.toString());
            throwable.printStackTrace();
        }
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        int n = rtmpSessionInfo.getProtocol();
        if (rtmpSessionInfo.isOpen() && n == 1) {
            RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
            RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
            rtmpRequestMessage.setType(4);
            rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
            this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
        }
        if (n == 3) {
            ioSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRequest(IoSession ioSession, RtmpSessionInfo rtmpSessionInfo, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        rtmpRequestMessage.setVHost(this.vhost);
        rtmpRequestMessage.setHostPort(this.hostPort);
        int n = rtmpSessionInfo.getProtocol();
        switch (n) {
            case 32: 
            case 33: {
                HTTPRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            case 34: 
            case 35: {
                RTSPRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            default: {
                RTMPRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
            }
        }
        n = rtmpSessionInfo.getProtocol();
        int n2 = rtmpResponseMessage.getContentLength();
        if (n2 > 0) {
            rtmpResponseMessage.notifyResponseStart();
            this.ioPerformanceCounter.incrementMessagesOut(rtmpResponseMessage.getContentLength());
            switch (n) {
                case 1: 
                case 16: 
                case 17: {
                    ByteBuffer byteBuffer = ByteBuffer.allocate((int)1, (boolean)false);
                    byteBuffer.setExtra((Object)new FastMinaMessage(rtmpResponseMessage.getBodyList(), rtmpResponseMessage.getContentLength()));
                    ioSession.write((Object)byteBuffer);
                    break;
                }
                case 34: 
                case 35: {
                    for (ByteBuffer byteBuffer : rtmpResponseMessage.getBodyList()) {
                        ioSession.write((Object)byteBuffer);
                    }
                    break;
                }
                case 3: 
                case 32: 
                case 33: {
                    ClientWriteListener clientWriteListener;
                    Client client;
                    VHost vHost;
                    int n3 = rtmpRequestMessage.getClientId();
                    if (n3 > 0 && (vHost = (VHost)VHostSingleton.getInstance(this.vhostName)) != null && (client = (Client)vHost.getClient(n3)) != null && (clientWriteListener = client.getWriteListener()) != null) {
                        ioSession.addWriteListener((IWriteListener)clientWriteListener);
                    }
                    rtmpResponseMessage.setClientId(n3);
                    vHost = ioSession.write((Object)rtmpResponseMessage);
                    if (vHost == null || n != 3) break;
                    vHost.join();
                    break;
                }
            }
            rtmpResponseMessage.notifyResponseStop();
            rtmpResponseMessage.clearBody();
        }
        if (rtmpResponseMessage.isDidClose()) {
            rtmpSessionInfo.setOpen(false);
            rtmpSessionInfo.setClosed(true);
            rtmpSessionInfo.setClientId(-1);
            ioSession.close();
        }
        if (rtmpResponseMessage.isImmediateIdle()) {
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                rtmpSessionInfo.addMessageQueue(null);
            }
        }
    }
}

