/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.sharedobject;

import com.wowza.util.AMFUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.ISharedObjectSlot;
import com.wowza.wms.sharedobject.ISharedObjectSlotNotify;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObjectClient;
import com.wowza.wms.sharedobject.SharedObjectSlot;
import com.wowza.wms.sharedobject.SharedObjects;
import com.wowza.wms.util.VHostUtils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedObject
implements ISharedObject {
    public static final int READACCESS = 0;
    public static final int WRITEACCESS = 1;
    private Map slots = new HashMap();
    private int version = 0;
    private boolean isPersistent = false;
    private String name;
    private List slotListeners = new ArrayList();
    private List clearList = new ArrayList();
    private String storageDir = null;
    private WMSReadWriteLock lock = new WMSReentrantReadWriteLock();
    private ISharedObjects parent = null;
    private Map clients = new HashMap();
    private int refCount = 0;
    private WMSReadWriteLock parentLock = null;

    public SharedObject(String string) {
        this.init(string, false, null);
        this.parentLock = this.lock;
    }

    public SharedObject(String string, boolean bl, String string2) {
        this.init(string, bl, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string, boolean bl, String string2) {
        this.lock.writeLock().lock();
        try {
            this.name = string;
            this.isPersistent = bl;
            this.storageDir = string2;
            if (this.isPersistent) {
                this.load();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.init: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        this.lock.readLock().lock();
        try {
            for (String string : this.slots.keySet()) {
                ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
                if (iSharedObjectSlot.getLastOperation() != 3) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.size: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge(int n) {
        int n2 = 0;
        this.lock.writeLock().lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : this.slots.keySet()) {
                Object object2 = (ISharedObjectSlot)this.slots.get(object);
                if (object2.getSoVersion() >= n || object2.getLastOperation() != 10) continue;
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                for (Object object2 : arrayList) {
                    this.slots.remove(object2);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.purge: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.writeLock().lock();
        try {
            for (String string : this.slots.keySet()) {
                ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
                if (iSharedObjectSlot.getLastOperation() != 3) continue;
                ++this.version;
                iSharedObjectSlot.setLastOperation(10);
                iSharedObjectSlot.setLastClientId(0);
                iSharedObjectSlot.incSlotVersion();
                iSharedObjectSlot.setSoVersion(this.version);
                iSharedObjectSlot.setData((byte[])null);
                this.notifySlotDelete(iSharedObjectSlot);
            }
            ++this.version;
            this.clearList.add(new Integer(this.version));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.clear: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSlots() {
        ArrayList<ISharedObjectSlot> arrayList = new ArrayList<ISharedObjectSlot>();
        this.lock.readLock().lock();
        try {
            for (String string : this.slots.keySet()) {
                ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
                if (iSharedObjectSlot.getLastOperation() != 3) continue;
                arrayList.add(iSharedObjectSlot);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getSlots: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSlotNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.lock.readLock().lock();
        try {
            for (String string : this.slots.keySet()) {
                ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
                if (iSharedObjectSlot.getLastOperation() != 3) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getSlotNames: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISharedObjectSlot getSlot(String string) {
        ISharedObjectSlot iSharedObjectSlot = null;
        this.lock.readLock().lock();
        try {
            iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getSlot: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return iSharedObjectSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSlot(String string, ISharedObjectSlot iSharedObjectSlot) {
        this.lock.writeLock().lock();
        try {
            this.slots.put(string, iSharedObjectSlot);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.putSlot: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getClients() {
        ArrayList arrayList = new ArrayList();
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.clients.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getClients: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClient(IClient iClient) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.clients.containsKey(new Integer(iClient.getClientId()));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(IClient iClient) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.writeLock().lock();
        try {
            Integer n = new Integer(iClient.getClientId());
            if (!this.clients.containsKey(n)) {
                this.clients.put(n, new SharedObjectClient(iClient));
                ++this.refCount;
                bl = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.addClient: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        if (bl) {
            ((Client)iClient).registerSharedObject(this);
        }
        if (bl && this.parent != null) {
            ((SharedObjects)this.parent).notifySharedObjectConnect(this, iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(IClient iClient) {
        boolean bl = false;
        boolean bl2 = false;
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.writeLock().lock();
        try {
            Integer n = new Integer(iClient.getClientId());
            if (this.clients.containsKey(n)) {
                this.clients.remove(new Integer(iClient.getClientId()));
                --this.refCount;
                bl = true;
                if (this.refCount == 0 && this.isPersistent) {
                    this.flush();
                }
                if (this.refCount == 0) {
                    bl2 = true;
                    if (this.parent != null) {
                        ((SharedObjects)this.parent).removeInternal(this.getName());
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.removeClient: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        if (bl) {
            ((Client)iClient).unregisterSharedObject(this);
        }
        if (bl && this.parent != null) {
            ((SharedObjects)this.parent).notifySharedObjectDisconnect(this, iClient);
        }
        if (bl2 && this.parent != null) {
            ((SharedObjects)this.parent).notifySharedObjectDestroy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.writeLock().lock();
        try {
            ++this.refCount;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.acquire: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.writeLock().lock();
        try {
            --this.refCount;
            if (this.refCount == 0 && this.isPersistent) {
                this.flush();
            }
            if (this.refCount == 0) {
                bl = true;
                if (this.parent != null) {
                    ((SharedObjects)this.parent).removeInternal(this.getName());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.release: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        if (bl && this.parent != null) {
            ((SharedObjects)this.parent).notifySharedObjectDestroy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.refCount;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getRefCount: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPersistent() {
        boolean bl = false;
        this.lock.readLock().lock();
        try {
            bl = this.isPersistent;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.isPersistent: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistent(boolean bl) {
        this.lock.writeLock().lock();
        try {
            this.isPersistent = bl;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.setPersistent: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        int n = 0;
        this.lock.readLock().lock();
        try {
            n = this.version;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(int n) {
        this.lock.writeLock().lock();
        try {
            this.version = n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.setVersion: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteSlot(String string) {
        this.deleteSlot(null, string);
    }

    public boolean containsProperty(String string) {
        return this.containsSlot(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSlot(String string) {
        boolean bl = false;
        this.lock.readLock().lock();
        try {
            ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
            if (iSharedObjectSlot != null && iSharedObjectSlot.getLastOperation() == 3) {
                bl = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.slotExist: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSlot(IClient iClient, String string) {
        this.lock.writeLock().lock();
        try {
            ISharedObjectSlot iSharedObjectSlot = this.getSlot(string);
            if (iSharedObjectSlot != null) {
                ++this.version;
                iSharedObjectSlot.setLastOperation(10);
                iSharedObjectSlot.setLastClientId(iClient == null ? 0 : iClient.getClientId());
                iSharedObjectSlot.incSlotVersion();
                iSharedObjectSlot.setSoVersion(this.version);
                iSharedObjectSlot.setData((byte[])null);
                this.notifySlotDelete(iSharedObjectSlot);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.deleteSlot: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMFData getProperty(String string) {
        AMFData aMFData = null;
        this.lock.readLock().lock();
        try {
            ISharedObjectSlot iSharedObjectSlot = this.getSlot(string);
            if (iSharedObjectSlot != null) {
                aMFData = iSharedObjectSlot.getData();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getProperty: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return aMFData;
    }

    public void setProperty(String string, boolean bl) {
        AMFDataItem aMFDataItem = new AMFDataItem(bl);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, Date date) {
        AMFDataItem aMFDataItem = new AMFDataItem(date);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, double d) {
        AMFDataItem aMFDataItem = new AMFDataItem(d);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, long l) {
        AMFDataItem aMFDataItem = new AMFDataItem(l);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, int n) {
        AMFDataItem aMFDataItem = new AMFDataItem(n);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, String string2) {
        AMFDataItem aMFDataItem = new AMFDataItem(string2);
        this.setProperty(string, aMFDataItem);
    }

    public void setProperty(String string, AMFData aMFData) {
        this.setSlotValue(null, string, aMFData);
    }

    public void setSlotValue(IClient iClient, String string, AMFData aMFData) {
        this.setSlotValue(iClient, string, null, aMFData, null);
    }

    public void setSlotValue(IClient iClient, String string, byte[] byArray) {
        this.setSlotValue(iClient, string, byArray, null, null);
    }

    public void setSlotValue(IClient iClient, String string, byte[] byArray, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.setSlotValue(iClient, string, byArray, null, aMFDataContextDeserialize);
    }

    public void setSlotValue(IClient iClient, String string, byte[] byArray, AMFData aMFData) {
        this.setSlotValue(iClient, string, byArray, aMFData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotValue(IClient iClient, String string, byte[] byArray, AMFData aMFData, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.lock.writeLock().lock();
        try {
            ISharedObjectSlot iSharedObjectSlot = this.getSlot(string);
            if (iSharedObjectSlot == null) {
                iSharedObjectSlot = new SharedObjectSlot(string);
                this.putSlot(string, iSharedObjectSlot);
            }
            if (iSharedObjectSlot != null) {
                ++this.version;
                iSharedObjectSlot.setLastOperation(3);
                iSharedObjectSlot.setLastClientId(iClient != null ? iClient.getClientId() : 0);
                iSharedObjectSlot.incSlotVersion();
                iSharedObjectSlot.setSoVersion(this.version);
                if (byArray != null) {
                    iSharedObjectSlot.setData(byArray, aMFDataContextDeserialize);
                } else {
                    iSharedObjectSlot.setData(aMFData);
                }
                this.notifySlotSetValue(iSharedObjectSlot);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.setSlotValue: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static void writeError(IClient iClient, String string, boolean bl, String string2, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        String string3 = "error";
        int n = iClient.getObjectEncoding();
        try {
            if (n > 0) {
                dataOutputStream.write(0);
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(0);
            int n2 = 0;
            if (bl2) {
                n2 += 20;
            }
            if (bl) {
                n2 += 2;
            }
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(0);
            int n3 = string3.length() + 2 + string2.length() + 2;
            dataOutputStream.writeByte(7);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeUTF(string3);
            WMSLoggerFactory.getLogger(SharedObject.class).debug("getClientUpdates: writeError: " + string2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.writeError: " + exception.toString());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ResponseFunction responseFunction = new ResponseFunction(iClient);
        responseFunction.createSOMessage(byArray, n);
        ((Client)iClient).getRespFunctions().add(responseFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSetValueError(IClient iClient, String string, boolean bl, String string2, String string3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        String string4 = "error";
        int n = iClient.getObjectEncoding();
        this.lock.readLock().lock();
        try {
            if (n > 0) {
                dataOutputStream.write(0);
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(this.version);
            if (this.isPersistent) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(0);
            int n2 = string.length() + 2;
            dataOutputStream.writeByte(9);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeUTF(string2);
            n2 = string4.length() + 2 + string3.length() + 2;
            dataOutputStream.writeByte(7);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeUTF(string4);
            WMSLoggerFactory.getLogger(SharedObject.class).debug("getClientUpdates: writeSetValueError: " + string3);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.writeSetValueError: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ResponseFunction responseFunction = new ResponseFunction(iClient);
        responseFunction.createSOMessage(byArray, n);
        ((Client)iClient).getRespFunctions().add(responseFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeleteError(IClient iClient, String string, boolean bl, String string2, String string3) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        String string4 = "error";
        int n = iClient.getObjectEncoding();
        this.lock.readLock().lock();
        try {
            if (n > 0) {
                dataOutputStream.write(0);
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(this.version);
            if (this.isPersistent) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(0);
            int n2 = 0;
            object = (ISharedObjectSlot)this.slots.get(string2);
            if (object != null) {
                AMFData aMFData = null;
                byte[] byArray = null;
                aMFData = object.getData();
                byArray = null;
                if (aMFData != null) {
                    byArray = this.serialize(aMFData, n);
                }
                int n3 = string.length() + 2;
                int n4 = byArray != null ? byArray.length : 0;
                dataOutputStream.writeByte(4);
                dataOutputStream.writeInt(n2 += n3 + n4);
                dataOutputStream.writeUTF(string2);
                if (byArray != null) {
                    dataOutputStream.write(byArray);
                }
            }
            n2 = string4.length() + 2 + string3.length() + 2;
            dataOutputStream.writeByte(7);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeUTF(string4);
            WMSLoggerFactory.getLogger(SharedObject.class).debug("getClientUpdates: writeDeleteError: " + string3);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.writeDeleteError: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = new ResponseFunction(iClient);
        ((ResponseFunction)object).createSOMessage(byArray, n);
        ((Client)iClient).getRespFunctions().add((ResponseFunction)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientUpdates(IClient iClient) {
        Object[] objectArray;
        boolean bl = false;
        SharedObjectClient sharedObjectClient = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = iClient.getObjectEncoding();
        AMFDataContextSerialize aMFDataContextSerialize = AMFData.createContextSerialize(0);
        aMFDataContextSerialize.setTargetEncoding(n);
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.readLock().lock();
        try {
            sharedObjectClient = (SharedObjectClient)this.clients.get(new Integer(iClient.getClientId()));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getClientUpdates(read): " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        this.lock.readLock().lock();
        try {
            objectArray = SharedObject.getAccess(iClient, this.name);
            if (!objectArray[0]) {
            } else if (this.version != sharedObjectClient.getVersion()) {
                int n2 = sharedObjectClient.getVersion();
                int n3 = iClient.getClientId();
                int n4 = -1;
                int n5 = this.clearList.size();
                if (n5 > 0) {
                    n4 = (Integer)this.clearList.get(n5 - 1);
                }
                boolean bl2 = n2 == -1;
                boolean bl3 = false;
                if (!bl2 && n4 > n2) {
                    n2 = n4;
                    bl3 = true;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (!bl) {
                    if (n > 0) {
                        dataOutputStream.write(0);
                    }
                    dataOutputStream.writeUTF(this.name);
                    dataOutputStream.writeInt(this.version);
                    if (bl2) {
                        WMSLoggerFactory.getLogger(SharedObject.class).debug("getClientUpdates: isFirstUpdate: true");
                        int n6 = 32;
                        if (this.isPersistent) {
                            n6 += 2;
                        }
                        dataOutputStream.writeInt(n6);
                        dataOutputStream.writeInt(0);
                        dataOutputStream.writeByte(11);
                        dataOutputStream.writeInt(0);
                        if (!this.isPersistent) {
                            dataOutputStream.writeByte(8);
                            dataOutputStream.writeInt(0);
                        }
                    } else {
                        WMSLoggerFactory.getLogger(SharedObject.class).debug("getClientUpdates: isFirstUpdate: false");
                        if (this.isPersistent) {
                            dataOutputStream.writeInt(2);
                        } else {
                            dataOutputStream.writeInt(0);
                        }
                        dataOutputStream.writeInt(0);
                    }
                    bl = true;
                }
                if (bl3) {
                    dataOutputStream.writeByte(8);
                    dataOutputStream.writeInt(0);
                }
                for (String string : this.slots.keySet()) {
                    ISharedObjectSlot iSharedObjectSlot = (ISharedObjectSlot)this.slots.get(string);
                    if (iSharedObjectSlot.getSoVersion() <= n2) continue;
                    int n7 = 4;
                    switch (iSharedObjectSlot.getLastOperation()) {
                        case 3: {
                            if (iSharedObjectSlot.getLastClientId() != n3) break;
                            n7 = 5;
                            break;
                        }
                        case 10: {
                            n7 = 9;
                        }
                    }
                    int n8 = string.length() + 2;
                    AMFData aMFData = null;
                    byte[] byArray = null;
                    if (n7 == 4) {
                        aMFData = iSharedObjectSlot.getData();
                        byArray = null;
                        if (aMFData != null) {
                            byArray = this.serialize(aMFData, n, aMFDataContextSerialize);
                        }
                        n8 += byArray != null ? byArray.length : 0;
                    }
                    if (bl2 && n7 == 9) continue;
                    dataOutputStream.writeByte(n7);
                    dataOutputStream.writeInt(n8);
                    dataOutputStream.writeUTF(string);
                    if (byArray == null) continue;
                    dataOutputStream.write(byArray);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getClientUpdates(read): " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (byteArrayOutputStream != null && bl) {
            if (sharedObjectClient != null) {
                this.lock.writeLock().lock();
                try {
                    sharedObjectClient.setVersion(this.version);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getClientUpdates(write): " + exception.toString());
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            objectArray = byteArrayOutputStream.toByteArray();
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createSOMessage((byte[])objectArray, n);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    public void disconnect(IClient iClient) {
        this.removeClient(iClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String string = null;
        this.lock.readLock().lock();
        try {
            string = this.name;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getName: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        this.lock.writeLock().lock();
        try {
            this.name = string;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void send(String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        this.sendInternal(string, aMFDataArray);
    }

    public void send(String string) {
        this.sendLocal(string, null, 0);
    }

    private void sendLocal(String string, byte[] byArray, int n) {
        this.sendLocal(string, byArray, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocal(String string, byte[] byArray, int n, AMFDataContextDeserialize aMFDataContextDeserialize) {
        int n2 = 64 + string.length() + (byArray == null ? 0 : byArray.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        ArrayList arrayList = new ArrayList();
        WMSReadWriteLock wMSReadWriteLock = this.parentLock;
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.clients.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.sendLocal: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        try {
            if (n > 0) {
                dataOutputStream.write(0);
            }
            dataOutputStream.writeUTF(this.name);
            dataOutputStream.writeInt(this.version);
            if (this.isPersistent) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(0);
            dataOutputStream.writeByte(6);
            dataOutputStream.writeInt(3 + string.length() + (byArray == null ? 0 : byArray.length));
            dataOutputStream.writeByte(2);
            dataOutputStream.writeUTF(string);
            if (byArray != null) {
                dataOutputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.sendLocal: " + exception.toString());
        }
        if (arrayList != null) {
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            for (SharedObjectClient sharedObjectClient : arrayList) {
                ResponseFunction responseFunction = new ResponseFunction(sharedObjectClient.getClient());
                responseFunction.createSOMessage(byArray2, n);
                sharedObjectClient.getClient().getRespFunctions().add(responseFunction);
            }
        }
    }

    private int getClientObjectEncoding() {
        int n = -1;
        List list = this.getClients();
        for (SharedObjectClient sharedObjectClient : list) {
            int n2 = sharedObjectClient.getClient().getObjectEncoding();
            if (n == -1) {
                n = n2;
                continue;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private byte[] serialize(AMFData aMFData, int n) {
        return this.serialize(aMFData, n, null);
    }

    private byte[] serialize(AMFData aMFData, int n, AMFDataContextSerialize aMFDataContextSerialize) {
        byte[] byArray = null;
        try {
            if (aMFDataContextSerialize == null) {
                aMFDataContextSerialize = AMFData.createContextSerialize(0);
                aMFDataContextSerialize.setTargetEncoding(n);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (aMFDataContextSerialize.getTargetEncoding() > 0 && AMFData.triggerAMF3Switch(aMFData)) {
                dataOutputStream.write(17);
                aMFDataContextSerialize.setObjectEncoding(3);
            }
            aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
            aMFDataContextSerialize.setObjectEncoding(0);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.serialize: " + exception.toString());
        }
        return byArray;
    }

    public void sendInternal(String string, AMFData[] aMFDataArray) {
        int n;
        AMFDataList aMFDataList = new AMFDataList();
        if (aMFDataArray != null) {
            for (n = 0; n < aMFDataArray.length; ++n) {
                aMFDataList.add(aMFDataArray[n]);
            }
        }
        n = this.getClientObjectEncoding();
        AMFDataContextSerialize aMFDataContextSerialize = AMFData.createContextSerialize(0);
        aMFDataContextSerialize.setTargetEncoding(n);
        byte[] byArray = this.serialize(aMFDataList, n, aMFDataContextSerialize);
        this.sendLocal(string, byArray, n);
    }

    public void sendInternal(IClient iClient, String string, byte[] byArray) {
        this.sendInternal(iClient, string, byArray, null);
    }

    public void sendInternal(IClient iClient, String string, byte[] byArray, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.sendLocal(string, byArray, iClient.getObjectEncoding(), aMFDataContextDeserialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSlotListener(ISharedObjectSlotNotify iSharedObjectSlotNotify) {
        List list = this.slotListeners;
        synchronized (list) {
            this.slotListeners.add(iSharedObjectSlotNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlotListener(ISharedObjectSlotNotify iSharedObjectSlotNotify) {
        List list = this.slotListeners;
        synchronized (list) {
            this.slotListeners.remove(iSharedObjectSlotNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySlotSetValue(ISharedObjectSlot iSharedObjectSlot) {
        ArrayList arrayList = null;
        List list = this.slotListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.slotListeners);
        }
        for (ISharedObjectSlotNotify iSharedObjectSlotNotify : arrayList) {
            iSharedObjectSlotNotify.onSlotSetValue(this, iSharedObjectSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySlotDelete(ISharedObjectSlot iSharedObjectSlot) {
        ArrayList arrayList = null;
        List list = this.slotListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.slotListeners);
        }
        for (ISharedObjectSlotNotify iSharedObjectSlotNotify : arrayList) {
            iSharedObjectSlotNotify.onSlotDelete(this, iSharedObjectSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStorageDir() {
        String string = null;
        this.lock.readLock().lock();
        try {
            string = this.storageDir;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.getStorageDir: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageDir(String string) {
        this.lock.writeLock().lock();
        try {
            this.storageDir = string;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.setStorageDir: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String getFilepath() {
        String string = this.getName();
        String string2 = string.replace("\\", "/");
        String[] stringArray = string2.split("[/]");
        if (stringArray.length > 1) {
            String string3 = this.storageDir == null ? "" : this.storageDir;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                File file = new File(string3 = string3 + File.separatorChar + stringArray[i]);
                if (file.exists()) continue;
                try {
                    file.mkdir();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.storageDir == null ? this.getName() + "." + "rso" : this.storageDir + File.separatorChar + this.getName() + "." + "rso";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.lock.readLock().lock();
        try {
            if (!this.isPersistent) {
            } else {
                PrintWriter printWriter = new PrintWriter(this.getFilepath());
                printWriter.println("<Root>");
                printWriter.println("\t<SharedObject>");
                printWriter.println("\t\t<FileVersion>1.0.0</FileVersion>");
                printWriter.println("\t\t<Name>" + this.getName() + "</Name>");
                printWriter.println("\t\t<Version>" + this.version + "</Version>");
                printWriter.println("\t\t<Slots>");
                Iterator iterator = this.slots.keySet().iterator();
                while (iterator.hasNext()) {
                    printWriter.println("\t\t\t<Slot>");
                    String string = (String)iterator.next();
                    SharedObjectSlot sharedObjectSlot = (SharedObjectSlot)this.slots.get(string);
                    sharedObjectSlot.flush(printWriter, "\t\t\t\t");
                    printWriter.println("\t\t\t</Slot>");
                }
                printWriter.println("\t\t</Slots>");
                printWriter.println("\t</SharedObject>");
                printWriter.println("</Root>");
                printWriter.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.lock.writeLock().lock();
        try {
            File file = new File(this.getFilepath());
            if (file.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                if (document != null) {
                    Element element = document.getDocumentElement();
                    String string = "/Root/SharedObject";
                    Node node = XMLUtils.getNodeByTagName(element, "FileVersion");
                    Node node2 = XMLUtils.getNodeByTagName(element, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element, "Version");
                    if (node != null && node2 != null && node3 != null) {
                        String string2 = XMLUtils.getNodeValue(node);
                        String string3 = XMLUtils.getNodeValue(node2);
                        String string4 = XMLUtils.getNodeValue(node3);
                        this.setName(string3);
                        this.setVersion(Integer.parseInt(string4));
                        String string5 = "/Root/SharedObject/Slots/Slot";
                        XPathExpression xPathExpression = xPath.compile(string5);
                        NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                        if (nodeList != null) {
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                Node node4 = nodeList.item(i);
                                Element element2 = (Element)node4;
                                SharedObjectSlot sharedObjectSlot = SharedObjectSlot.load(element2);
                                if (sharedObjectSlot == null) continue;
                                this.slots.put(sharedObjectSlot.getName(), sharedObjectSlot);
                            }
                        }
                    } else {
                        WMSLoggerFactory.getLogger(VHostUtils.class).error("SharedObject: load: error parsing SharedObject file: (" + file + ") error: <FileVersion>, <Name> and <Version> elements required");
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SharedObject.class).error("SharedObject.load: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() {
    }

    public void lock() {
        this.lock.writeLock().lock();
    }

    public void unlock() {
        this.lock.writeLock().unlock();
    }

    public void setParent(ISharedObjects iSharedObjects) {
        this.parent = iSharedObjects;
        this.parentLock = iSharedObjects != null ? ((SharedObjects)iSharedObjects).getLock() : this.lock;
    }

    public ISharedObjects getParent() {
        return this.parent;
    }

    public static boolean[] getAccess(IClient iClient, String string) {
        String string2;
        int n;
        String[] stringArray;
        boolean[] blArray = new boolean[2];
        String string3 = iClient.getSharedObjectReadAccess();
        String string4 = iClient.getSharedObjectWriteAccess();
        if (string3.equals("*")) {
            blArray[0] = true;
        } else if (string3.equals("")) {
            blArray[0] = false;
        } else {
            blArray[0] = false;
            stringArray = string3.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[0] = true;
                break;
            }
        }
        if (string4.equals("*")) {
            blArray[1] = true;
        } else if (string4.equals("")) {
            blArray[1] = false;
        } else {
            blArray[1] = false;
            stringArray = string4.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[1] = true;
                break;
            }
        }
        return blArray;
    }
}

