/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.MediaReaderList;

public class MediaReaderFactory {
    public static IMediaReader getInstance(IApplicationInstance iApplicationInstance, MediaReaderList mediaReaderList, String string) {
        IMediaReader iMediaReader = null;
        try {
            MediaReaderItem mediaReaderItem = mediaReaderList.getMediaReaderDef(string.toLowerCase());
            if (mediaReaderItem != null) {
                String string2 = mediaReaderItem.getBaseClass();
                Class<?> clazz = Class.forName(string2);
                iMediaReader = (IMediaReader)clazz.newInstance();
                if (iMediaReader != null) {
                    WMSProperties wMSProperties = new WMSProperties();
                    WMSProperties.cloneProperties(mediaReaderItem.getProperties(), wMSProperties);
                    WMSProperties.cloneProperties(iApplicationInstance.getMediaReaderProperties(), wMSProperties);
                    iMediaReader.setMediaReaderItem(mediaReaderItem);
                    iMediaReader.setProperties(wMSProperties);
                }
            } else {
                WMSLoggerFactory.getLogger(MediaReaderFactory.class).error("MediaReaderFactory: getInstance: Missing definition for " + string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFactory.class).error("MediaReaderFactory: getInstance: " + exception.toString());
        }
        return iMediaReader;
    }
}

