/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.debugger.MediaStreamDebug;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamFactory;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaStreamMap {
    public static final int MAXSTREAMINDEX = 65536;
    protected Map<Long, IMediaStream> streams = new HashMap<Long, IMediaStream>();
    protected Map<String, IMediaStream> streamNames = new HashMap<String, IMediaStream>();
    protected WMSReadWriteLock streamLock = new WMSReentrantReadWriteLock();
    protected WMSReadWriteLock streamNamesLock = new WMSReentrantReadWriteLock();
    protected IApplicationInstance appInstance = null;
    protected List<IMediaStreamNotify> mediaStreamListeners = new ArrayList<IMediaStreamNotify>();
    protected AtomicLong nextStreamId = new AtomicLong();

    public MediaStreamMap(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    public WMSReadWriteLock getStreamListLock() {
        return this.streamLock;
    }

    public WMSReadWriteLock getStreamNameLock() {
        return this.streamNamesLock;
    }

    public List<String> getPublishStreamNames() {
        ArrayList<String> arrayList = null;
        this.streamNamesLock.readLock().lock();
        arrayList = new ArrayList<String>(this.streamNames.keySet());
        this.streamNamesLock.readLock().unlock();
        return arrayList;
    }

    public List<IMediaStream> getStreams() {
        ArrayList<IMediaStream> arrayList = new ArrayList<IMediaStream>();
        this.streamLock.readLock().lock();
        arrayList.addAll(this.streams.values());
        this.streamLock.readLock().unlock();
        int n = arrayList.size();
        for (int i = n - 1; i >= 0; --i) {
            if (arrayList.get(i) != null) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public IMediaStream getStream(IClient iClient, int n) {
        return this.getStream(iClient, n, false);
    }

    public IMediaStream getStreamClientless(int n, String string) {
        IMediaStream iMediaStream = null;
        this.streamLock.readLock().lock();
        iMediaStream = this.streams.get(new Long(n));
        this.streamLock.readLock().unlock();
        if (iMediaStream == null) {
            iMediaStream = MediaStreamFactory.createStream(string, this, n);
            this.streamLock.writeLock().lock();
            this.streams.put(new Long(n), iMediaStream);
            this.streamLock.writeLock().unlock();
        }
        return iMediaStream;
    }

    public IMediaStream getStream(IClient iClient, int n, boolean bl) {
        IMediaStream iMediaStream = null;
        long l = n;
        if (iClient != null) {
            l = ((long)iClient.getClientId() << 32) + (long)n;
        }
        this.streamLock.readLock().lock();
        iMediaStream = this.streams.get(new Long(l));
        this.streamLock.readLock().unlock();
        if (iMediaStream == null && bl) {
            String string = "default";
            String string2 = iClient.getStreamType();
            if (string2 != null) {
                string = string2;
            }
            iMediaStream = MediaStreamFactory.createStream(string, this, n);
            this.streamLock.writeLock().lock();
            this.streams.put(new Long(l), iMediaStream);
            this.streamLock.writeLock().unlock();
            if (iClient != null) {
                iMediaStream.setBufferTime(iClient.getBufferTime());
                ((Client)iClient).registerStream(iMediaStream);
                iMediaStream.setClient(iClient);
            }
            if (this.appInstance != null) {
                ModuleFunctions moduleFunctions = this.appInstance.getModFunctions();
                moduleFunctions.onStreamCreate(iMediaStream);
                this.notifyMediaStreamCreate(iMediaStream);
            }
        }
        return iMediaStream;
    }

    public IMediaStream getStream(INetConnection iNetConnection, int n) {
        return this.getStream(iNetConnection, n, false);
    }

    public IMediaStream getStream(INetConnection iNetConnection, int n, boolean bl) {
        IMediaStream iMediaStream = null;
        long l = n;
        if (iNetConnection != null) {
            l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)n;
        }
        this.streamLock.readLock().lock();
        iMediaStream = this.streams.get(new Long(l));
        this.streamLock.readLock().unlock();
        if (iMediaStream == null && bl) {
            Object object;
            if (iNetConnection != null) {
                object = "default";
                String string = iNetConnection.getStreamType();
                if (string != null) {
                    object = string;
                }
                iMediaStream = MediaStreamFactory.createStream((String)object, this, n);
            } else {
                iMediaStream = new MediaStreamDebug();
                iMediaStream.setSrc(n);
            }
            this.streamLock.writeLock().lock();
            this.streams.put(new Long(l), iMediaStream);
            this.streamLock.writeLock().unlock();
            if (iNetConnection != null) {
                iNetConnection.registerStream(iMediaStream);
            }
            if (this.appInstance != null) {
                object = this.appInstance.getModFunctions();
                ((ModuleFunctions)object).onStreamCreate(iMediaStream);
            }
        }
        return iMediaStream;
    }

    public IMediaStream getStream(String string) {
        IMediaStream iMediaStream = null;
        this.streamNamesLock.readLock().lock();
        iMediaStream = this.streamNames.get(string);
        this.streamNamesLock.readLock().unlock();
        return iMediaStream;
    }

    public void setStreamName(IMediaStream iMediaStream, String string) {
        this.streamNamesLock.writeLock().lock();
        this.streamNames.put(string, iMediaStream);
        this.streamNamesLock.writeLock().unlock();
    }

    public void clearStreamName(String string) {
        this.streamNamesLock.writeLock().lock();
        this.streamNames.remove(string);
        this.streamNamesLock.writeLock().unlock();
    }

    public void clearStreamName(String string, IMediaStream iMediaStream) {
        this.streamNamesLock.writeLock().lock();
        IMediaStream iMediaStream2 = this.streamNames.get(string);
        if (iMediaStream2 != null && iMediaStream2.getSrc() == iMediaStream.getSrc()) {
            this.streamNames.remove(string);
        }
        this.streamNamesLock.writeLock().unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public int getNextStreamIndex(INetConnection iNetConnection) {
        int n = 0;
        while (true) {
            long l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)(++n);
            Long l2 = new Long(l);
            this.streamLock.readLock().lock();
            if (this.streams.containsKey(l2)) {
                l2 = null;
            }
            this.streamLock.readLock().unlock();
            if (l2 == null) continue;
            this.streamLock.writeLock().lock();
            if (this.streams.containsKey(l2)) {
                l2 = null;
            } else {
                this.streams.put(l2, null);
            }
            this.streamLock.writeLock().unlock();
            if (l2 != null) return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public int getNextStreamIndex(IClient iClient) {
        int n = 0;
        while (true) {
            long l = ((long)iClient.getClientId() << 32) + (long)(++n);
            Long l2 = new Long(l);
            this.streamLock.readLock().lock();
            if (this.streams.containsKey(l2)) {
                l2 = null;
            }
            this.streamLock.readLock().unlock();
            if (l2 == null) continue;
            this.streamLock.writeLock().lock();
            if (this.streams.containsKey(l2)) {
                l2 = null;
            } else {
                this.streams.put(l2, null);
            }
            this.streamLock.writeLock().unlock();
            if (l2 != null) return n;
        }
    }

    public int getNextStreamIndex() {
        int n = 0;
        while (true) {
            if ((n = (int)(this.nextStreamId.incrementAndGet() & 0xFFFFL)) == 0) {
                continue;
            }
            Long l = new Long(n);
            this.streamLock.readLock().lock();
            if (this.streams.containsKey(l)) {
                l = null;
            }
            this.streamLock.readLock().unlock();
            if (l == null) continue;
            this.streamLock.writeLock().lock();
            if (this.streams.containsKey(l)) {
                l = null;
            } else {
                this.streams.put(l, null);
            }
            this.streamLock.writeLock().unlock();
            if (l != null) break;
        }
        return n;
    }

    public int getCount() {
        int n = 0;
        this.streamLock.readLock().lock();
        n = this.streams.size();
        this.streamLock.readLock().unlock();
        return n;
    }

    public void removeStream(INetConnection iNetConnection, int n) {
        long l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)n;
        this.removeStreamInternal(l, "netConnection");
    }

    public void removeStream(IClient iClient, int n) {
        long l = ((long)iClient.getClientId() << 32) + (long)n;
        this.removeStreamInternal(l, "client");
    }

    public void removeStream(int n) {
        long l = n;
        this.removeStreamInternal(l, "clientless");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStreamInternal(long l, String string) {
        Object object;
        IMediaStream iMediaStream = this.streams.get(new Long(l));
        if (iMediaStream != null) {
            if (this.appInstance != null) {
                object = this.appInstance.getModFunctions();
                ((ModuleFunctions)object).onStreamDestroy(iMediaStream);
                this.notifyMediaStreamDestroy(iMediaStream);
            }
            iMediaStream.shutdown();
        } else {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).warn("MediaStreamMap.removeStreamInternal: Stream index not found[" + string + "]: " + l);
        }
        this.streamLock.writeLock().lock();
        try {
            this.streams.remove(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.removeStream: " + exception.toString());
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        if (iMediaStream != null) {
            INetConnection iNetConnection;
            object = (Client)iMediaStream.getClient();
            if (object != null) {
                ((Client)object).unregisterStream(iMediaStream);
                ((Client)object).removePlayStreams(iMediaStream);
                ((Client)object).removePublishStreams(iMediaStream);
            }
            if ((iNetConnection = iMediaStream.getNetConnection()) != null) {
                iNetConnection.unregisterStream(iMediaStream);
            }
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info(null, iMediaStream, "stream", "destroy", 200, iMediaStream.getSrc() + "");
        }
    }

    public String getAppName() {
        if (this.appInstance != null) {
            return this.appInstance.getApplication().getName();
        }
        return "client2server";
    }

    public String getAppInstanceName() {
        if (this.appInstance != null) {
            return this.appInstance.getName();
        }
        return "client2server";
    }

    public IVHost getVHost() {
        if (this.appInstance != null) {
            return this.appInstance.getVHost();
        }
        return null;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void notifyPlayUnpublish(IMediaStream iMediaStream) {
        Boolean bl = false;
        String string = iMediaStream.getName();
        this.streamNamesLock.readLock().lock();
        IMediaStream iMediaStream2 = this.streamNames.get(string);
        this.streamNamesLock.readLock().unlock();
        if (iMediaStream2 != null) {
            bl = iMediaStream2.getSrc() == iMediaStream.getSrc();
        }
        if (bl.booleanValue()) {
            this.notifyPlayUnpublish(string);
        }
    }

    private List<IMediaStream> getPlayStreamsByName(String string) {
        ArrayList<IMediaStream> arrayList = new ArrayList<IMediaStream>();
        ArrayList<IMediaStream> arrayList2 = new ArrayList<IMediaStream>();
        this.streamLock.readLock().lock();
        arrayList2.addAll(this.streams.values());
        this.streamLock.readLock().unlock();
        for (IMediaStream iMediaStream : arrayList2) {
            if (iMediaStream == null || !iMediaStream.isPlay() || !iMediaStream.getName().equals(string)) continue;
            arrayList.add(iMediaStream);
        }
        arrayList2.clear();
        arrayList2 = null;
        return arrayList;
    }

    public void notifyPlayUnpublish(String string) {
        List<IMediaStream> list = this.getPlayStreamsByName(string);
        for (IMediaStream iMediaStream : list) {
            IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
            if (iMediaStreamPlay != null) {
                iMediaStreamPlay.resetNoLookup();
            }
            IClient iClient = iMediaStream.getClient();
            double d = iClient.getClientId();
            if (!iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(iMediaStream.getSrc());
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.UnpublishNotify"));
            aMFDataObj.put("description", new AMFDataItem(string + " is now unpublished."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    public int broadcastGetObjectEncoding(IMediaStream iMediaStream) {
        int n = -1;
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IClient iClient = iMediaStream2.getClient();
            int n2 = iClient.getObjectEncoding();
            if (n == -1) {
                n = n2;
                continue;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void broadcasePlayMessage(IMediaStream iMediaStream, long l, ByteBuffer byteBuffer, int n) {
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IClient iClient = iMediaStream2.getClient();
            if (!iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream2.getRespAMFDataObj());
            responseFunction.createBroadcastMessage(byteBuffer);
            responseFunction.setSrc(iMediaStream2.getSrc());
            responseFunction.setTimecode(l);
            responseFunction.setType(n == 0 ? 18 : 15);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    public void notifyPlayPublish(IMediaStream iMediaStream) {
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IMediaStreamPlay iMediaStreamPlay = iMediaStream2.getPlayer();
            if (iMediaStreamPlay != null) {
                iMediaStreamPlay.reset(true);
            }
            IClient iClient = iMediaStream2.getClient();
            double d = iClient.getClientId();
            if (!iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream2.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(iMediaStream2.getSrc());
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.PublishNotify"));
            aMFDataObj.put("description", new AMFDataItem(iMediaStream.getName() + " is now published."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            this.mediaStreamListeners.add(iMediaStreamNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            this.mediaStreamListeners.remove(iMediaStreamNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaStreamCreate(IMediaStream iMediaStream) {
        ArrayList<IMediaStreamNotify> arrayList = null;
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaStreamNotify>(this.mediaStreamListeners);
        }
        for (IMediaStreamNotify iMediaStreamNotify : arrayList) {
            iMediaStreamNotify.onMediaStreamCreate(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaStreamDestroy(IMediaStream iMediaStream) {
        ArrayList<IMediaStreamNotify> arrayList = null;
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaStreamNotify>(this.mediaStreamListeners);
        }
        for (IMediaStreamNotify iMediaStreamNotify : arrayList) {
            iMediaStreamNotify.onMediaStreamDestroy(iMediaStream);
        }
    }
}

