/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.transport.udp.IUDPTransportIncoming;
import com.wowza.wms.transport.udp.IUDPTransportOutgoing;
import com.wowza.wms.transport.udp.MulticastIncoming;
import com.wowza.wms.transport.udp.MulticastOutgoing;
import com.wowza.wms.transport.udp.UnicastIncoming;
import com.wowza.wms.transport.udp.UnicastOutgoing;
import com.wowza.wms.vhost.IVHost;

public class UDPTransportManager {
    private IVHost vhost = null;
    private int unicastIncomingProcessorCount = 2;
    private int unicastOutgoingProcessorCount = 4;
    private int multicastIncomingProcessorCount = 1;
    private int multicastOutgoingProcessorCount = 1;
    public UnicastOutgoing unicastOutgoing = new UnicastOutgoing();
    public UnicastIncoming unicastIncoming = new UnicastIncoming();
    public MulticastOutgoing multicastOutgoing = new MulticastOutgoing();
    public MulticastIncoming multicastIncoming = new MulticastIncoming();

    public void init(IVHost iVHost) {
        this.vhost = iVHost;
        this.unicastOutgoing.init(this.unicastOutgoingProcessorCount, iVHost);
        this.unicastIncoming.init(this.unicastIncomingProcessorCount, iVHost);
        this.multicastOutgoing.init(this.multicastOutgoingProcessorCount, iVHost);
        this.multicastIncoming.init(this.multicastIncomingProcessorCount, iVHost);
    }

    public IUDPTransportOutgoing getUnicastOutgoing() {
        return this.unicastOutgoing;
    }

    public IUDPTransportOutgoing getMulticastOutgoing() {
        return this.multicastOutgoing;
    }

    public IUDPTransportIncoming getUnicastIncoming() {
        return this.unicastIncoming;
    }

    public IUDPTransportIncoming getMulticastIncoming() {
        return this.multicastIncoming;
    }

    public int getUnicastIncomingProcessorCount() {
        return this.unicastIncomingProcessorCount;
    }

    public void setUnicastIncomingProcessorCount(int n) {
        this.unicastIncomingProcessorCount = n;
    }

    public int getUnicastOutgoingProcessorCount() {
        return this.unicastOutgoingProcessorCount;
    }

    public void setUnicastOutgoingProcessorCount(int n) {
        this.unicastOutgoingProcessorCount = n;
    }

    public int getMulticastIncomingProcessorCount() {
        return this.multicastIncomingProcessorCount;
    }

    public void setMulticastIncomingProcessorCount(int n) {
        this.multicastIncomingProcessorCount = n;
    }

    public int getMulticastOutgoingProcessorCount() {
        return this.multicastOutgoingProcessorCount;
    }

    public void setMulticastOutgoingProcessorCount(int n) {
        this.multicastOutgoingProcessorCount = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{UDPTransportManager: ");
        stringBuffer.append("unicastIncomingProcessorCount: " + this.unicastIncomingProcessorCount + ",");
        stringBuffer.append("unicastOutgoingProcessorCount: " + this.unicastOutgoingProcessorCount + ",");
        stringBuffer.append("multicastIncomingProcessorCount: " + this.multicastIncomingProcessorCount + ",");
        stringBuffer.append("multicastOutgoingProcessorCount: " + this.multicastOutgoingProcessorCount + ",");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

