/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPHandler;
import com.wowza.wms.transport.udp.IUDPTransportOutgoing;
import com.wowza.wms.transport.udp.IUDPTransportOutgoingConnection;
import com.wowza.wms.transport.udp.UnicastOutgoingConnection;
import com.wowza.wms.vhost.IVHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExpiringSessionRecycler;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;

public class UnicastOutgoing
implements IUDPTransportOutgoing {
    public static int MINCONNECTIONS = 20;
    private IVHost vhost = null;
    private int processorCount = -1;
    private ConnectorHolder[] connectors = null;
    private List<UnicastOutgoingConnection> connections = new ArrayList<UnicastOutgoingConnection>();
    private Object lock = new Object();
    private Executor executor = null;
    private long connectionCount = 0L;

    public void init(int n, IVHost iVHost) {
        this.processorCount = n;
        this.connectors = new ConnectorHolder[n];
        this.vhost = iVHost;
        this.executor = this.vhost.getTransportThreadPool().getExecutor();
    }

    private int getNextConnector() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.connectors.length; ++i) {
            if (this.connectors[i] == null) {
                this.connectors[i] = new ConnectorHolder(new DatagramConnector(this.executor));
                n = i;
                break;
            }
            if (this.connectors[i].count < MINCONNECTIONS) {
                n = i;
                break;
            }
            if (this.connectors[i].count >= n2) continue;
            n2 = this.connectors[i].count;
            n = i;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUDPTransportOutgoingConnection connect(RTPUDPDatagramConfig rTPUDPDatagramConfig, String string, int n) {
        UnicastOutgoingConnection unicastOutgoingConnection = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                Object object2;
                int n2 = this.getNextConnector();
                ConnectorHolder connectorHolder = this.connectors[n2];
                InetSocketAddress inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
                DatagramConnectorConfig datagramConnectorConfig = new DatagramConnectorConfig();
                datagramConnectorConfig.setThreadModel(ThreadModel.MANUAL);
                datagramConnectorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(this.executor)));
                datagramConnectorConfig.setSessionRecycler((IoSessionRecycler)new ExpiringSessionRecycler(0));
                IoSessionConfig ioSessionConfig = datagramConnectorConfig.getSessionConfig();
                if (rTPUDPDatagramConfig != null && ioSessionConfig instanceof DatagramSessionConfig) {
                    object2 = (DatagramSessionConfig)ioSessionConfig;
                    rTPUDPDatagramConfig.configureSessionConfig((DatagramSessionConfig)object2);
                }
                object2 = new RTPUDPHandler(null, inetSocketAddress);
                ConnectFuture connectFuture = connectorHolder.connector.connect((SocketAddress)inetSocketAddress, (IoHandler)object2, (IoServiceConfig)datagramConnectorConfig);
                unicastOutgoingConnection = new UnicastOutgoingConnection(this, connectorHolder.connector, n2, (RTPUDPHandler)((Object)object2), connectFuture);
                this.connections.add(unicastOutgoingConnection);
                ++connectorHolder.count;
                ++this.connectionCount;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.connect: " + exception.toString());
            exception.printStackTrace();
        }
        return unicastOutgoingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IUDPTransportOutgoingConnection iUDPTransportOutgoingConnection) {
        block10: {
            IoSession ioSession = null;
            UnicastOutgoingConnection unicastOutgoingConnection = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (iUDPTransportOutgoingConnection instanceof UnicastOutgoingConnection && this.connections.contains(iUDPTransportOutgoingConnection)) {
                        unicastOutgoingConnection = (UnicastOutgoingConnection)iUDPTransportOutgoingConnection;
                        int n = unicastOutgoingConnection.connectorIndex;
                        ConnectorHolder connectorHolder = this.connectors[n];
                        --connectorHolder.count;
                        --this.connectionCount;
                        ioSession = unicastOutgoingConnection.connectFuture.getSession();
                        this.connections.remove(unicastOutgoingConnection);
                    }
                }
                if (unicastOutgoingConnection == null) break block10;
                object = unicastOutgoingConnection;
                synchronized (object) {
                    unicastOutgoingConnection.isOpen = false;
                    if (ioSession != null) {
                        ioSession.close();
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.disconnect: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionCount;
        }
    }

    class ConnectorHolder {
        public DatagramConnector connector = null;
        public int count = 0;

        public ConnectorHolder(DatagramConnector datagramConnector) {
            this.connector = datagramConnector;
        }
    }
}

