/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.NoMBean;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.util.IIdleWorkerNotify;
import com.wowza.wms.util.IdleWorkerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdleWorkersUtil {
    private int workerCount = 0;
    private int pollFreq = 0;
    private int minimumWaitTime = 0;
    private Map<IIdleNotify, Integer> idleMap = new HashMap<IIdleNotify, Integer>();
    private IdleWorkerUtil[] workers = null;
    private int[] idleCounts = null;
    private List idleWorderListeners = new ArrayList();

    public void start() {
        this.workers = new IdleWorkerUtil[this.workerCount];
        this.idleCounts = new int[this.workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new IdleWorkerUtil(i, this.pollFreq, this.minimumWaitTime);
            this.workers[i].setPriority(10);
            this.workers[i].setDaemon(true);
            this.workers[i].start();
            this.notifyIdleWorkerCreate(this.workers[i]);
        }
    }

    public void halt() {
        if (this.workers != null) {
            for (int i = 0; i < this.workers.length; ++i) {
                try {
                    this.workers[i].halt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.notifyIdleWorkerDestroy(this.workers[i]);
            }
        }
        this.workers = null;
    }

    public synchronized void registerIdleClient(IIdleNotify iIdleNotify) {
        int n = this.idleCounts[0];
        int n2 = 0;
        for (int i = 1; i < this.workers.length; ++i) {
            if (this.idleCounts[i] >= n) continue;
            n = this.idleCounts[i];
            n2 = i;
        }
        this.idleMap.put(iIdleNotify, new Integer(n2));
        this.workers[n2].registerIdleClient(iIdleNotify);
        int n3 = n2;
        this.idleCounts[n3] = this.idleCounts[n3] + 1;
    }

    public synchronized void unregisterIdleClient(IIdleNotify iIdleNotify) {
        Integer n = this.idleMap.remove(iIdleNotify);
        if (n != null) {
            int n2 = n;
            this.workers[n2].unregisterIdleClient(iIdleNotify);
            int n3 = n2;
            this.idleCounts[n3] = this.idleCounts[n3] - 1;
        }
    }

    public int getPollFreq() {
        return this.pollFreq;
    }

    public void setPollFreq(int n) {
        this.pollFreq = n;
    }

    public int getMinimumWaitTime() {
        return this.minimumWaitTime;
    }

    public void setMinimumWaitTime(int n) {
        this.minimumWaitTime = n;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int n) {
        this.workerCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        List list = this.idleWorderListeners;
        synchronized (list) {
            this.idleWorderListeners.add(iIdleWorkerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        List list = this.idleWorderListeners;
        synchronized (list) {
            this.idleWorderListeners.remove(iIdleWorkerNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyIdleWorkerCreate(IdleWorkerUtil idleWorkerUtil) {
        ArrayList arrayList = null;
        List list = this.idleWorderListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.idleWorderListeners);
        }
        for (IIdleWorkerNotify iIdleWorkerNotify : arrayList) {
            iIdleWorkerNotify.onIdleWorkerCreate(idleWorkerUtil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyIdleWorkerDestroy(IdleWorkerUtil idleWorkerUtil) {
        ArrayList arrayList = null;
        List list = this.idleWorderListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.idleWorderListeners);
        }
        for (IIdleWorkerNotify iIdleWorkerNotify : arrayList) {
            iIdleWorkerNotify.onIdleWorkerDestroy(idleWorkerUtil);
        }
    }
}

