/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterSettings;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.VHostUtils;
import com.wowza.wms.vhost.IVHost;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MediaCasterUtils {
    public static MediaCasterItem loadMediaCaster(Element element) {
        MediaCasterItem mediaCasterItem;
        block11: {
            mediaCasterItem = null;
            try {
                Element element2 = element;
                Node node = XMLUtils.getNodeByTagName(element2, "Name");
                Node node2 = XMLUtils.getNodeByTagName(element2, "StreamType");
                Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
                Node node4 = XMLUtils.getNodeByTagName(element2, "ConnectionTimeout");
                Node node5 = XMLUtils.getNodeByTagName(element2, "KeepAliveTime");
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                String string = "Properties/Property";
                XPathExpression xPathExpression = xPath.compile(string);
                if (node != null && node2 != null && node3 != null) {
                    int n;
                    Object object;
                    String string2 = XMLUtils.getNodeValue(node);
                    String string3 = XMLUtils.getNodeValue(node2);
                    String string4 = XMLUtils.getNodeValue(node3);
                    mediaCasterItem = new MediaCasterItem(string2, string3, string4);
                    if (node4 != null) {
                        object = XMLUtils.getNodeValue(node4);
                        try {
                            n = Integer.parseInt((String)object);
                            mediaCasterItem.setConnectionTimeout(n);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadMediaCaster: error parsing server properties: ConnectionTimeout: " + exception.toString());
                        }
                    }
                    if (node5 != null) {
                        object = XMLUtils.getNodeValue(node5);
                        try {
                            n = Integer.parseInt((String)object);
                            mediaCasterItem.setKeepAliveTime(n);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadMediaCaster: error parsing server properties: KeepAliveTime: " + exception.toString());
                        }
                    }
                    if ((object = (Element)XMLUtils.getNodeByTagName(element2, "Description")) != null) {
                        mediaCasterItem.setDescription(XMLUtils.getNodeValue((Node)object));
                    }
                    WMSProperties wMSProperties = mediaCasterItem.getProperties();
                    NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList != null) {
                        XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                    }
                    WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(mediaCasterItem.toString());
                    break block11;
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadMediaCaster: error parsing server properties: Name, BaseClas and StreamType required.");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadMediaCaster: error parsing server properties: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return mediaCasterItem;
    }

    public static void loadMediaCasterList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    MediaCasterItem mediaCasterItem = MediaCasterUtils.loadMediaCaster(element2);
                    iVHost.getMediaCasterList().getMediaCasterDefs().put(mediaCasterItem.getName(), mediaCasterItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadHostPortList: error parsing HostPortList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading MediaCasters.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                MediaCasterSettings mediaCasterSettings = iVHost.getMediaCasterSettings();
                mediaCasterSettings.setMediaCasterProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/MediaCasters/Connections/ProcessorCount", element, mediaCasterSettings.getMediaCasterProcessorCount()));
                XPathExpression xPathExpression = xPath.compile("/Root/MediaCasters/Connections/SocketConfiguration");
                Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node != null) {
                    VHostUtils.loadHostPortConfig((Element)node, mediaCasterSettings.getMediaCasterHostPortConfig());
                }
                String string2 = "/Root/MediaCasters/MediaCaster";
                MediaCasterUtils.loadMediaCasterList(element, string2, iVHost);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("loadConfigFile: error parsing media caster config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

