/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.StreamUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MediaReaderUtils {
    public static void loadConfigFile(MediaReaderList mediaReaderList, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading MediaReaders.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "/Root/MediaReaders/MediaReader";
            String string3 = "Properties/Property";
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(string2);
                XPathExpression xPathExpression2 = xPath.compile(string3);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element2;
                        Node node = nodeList.item(i);
                        Element element3 = (Element)node;
                        Node node2 = XMLUtils.getNodeByTagName(element3, "Name");
                        Node node3 = XMLUtils.getNodeByTagName(element3, "ClassBase");
                        if (node2 == null || node3 == null) continue;
                        String string4 = XMLUtils.getNodeValue(node2);
                        String string5 = XMLUtils.getNodeValue(node3);
                        MediaReaderItem mediaReaderItem = new MediaReaderItem(string4, string5);
                        mediaReaderList.getMediaReaderDefs().put(string4, mediaReaderItem);
                        Element element4 = (Element)XMLUtils.getNodeByTagName(element3, "Description");
                        if (element4 != null) {
                            mediaReaderItem.setDescription(XMLUtils.getNodeValue(element4));
                        }
                        if ((element2 = (Element)XMLUtils.getNodeByTagName(element3, "FileExtension")) != null) {
                            mediaReaderItem.setFileExtension(XMLUtils.getNodeValue(element2));
                        }
                        WMSProperties wMSProperties = mediaReaderItem.getProperties();
                        NodeList nodeList2 = (NodeList)xPathExpression2.evaluate(node, XPathConstants.NODESET);
                        if (nodeList2 != null) {
                            XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                        }
                        WMSLoggerFactory.getLogger(MediaReaderUtils.class).debug(mediaReaderItem.toString());
                    }
                } else {
                    WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing mediareaders config file: (" + string + ") error: XPath " + string2 + " missing");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing mediareaders config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

