/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.MediaWriterUtils;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPUtils {
    public static void writeCodecConfig(RTPTrack rTPTrack, long l, byte[] byArray) {
        try {
            byte[] byArray2 = null;
            byArray2 = rTPTrack.isAudio() ? new byte[]{-81, 0} : new byte[]{23, 0, 0, 0, 0};
            int n = byArray.length + byArray2.length;
            IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
            if (iMediaStream != null) {
                if (rTPTrack.isAudio()) {
                    iMediaStream.setAudioTC(l, true);
                    iMediaStream.setAudioSize(n);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                    iMediaStream.addAudioData(byArray, 0, byArray.length);
                } else {
                    iMediaStream.setVideoTC(l, true);
                    iMediaStream.setVideoSize(n);
                    iMediaStream.startVideoPacket();
                    iMediaStream.addVideoData(byArray2, 0, byArray2.length);
                    iMediaStream.addVideoData(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.writeCodecConfig: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void loadDePacketizers(RTPContext rTPContext, Element element) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Root/RTP/DePacketizers/DePacketizer";
            XPathExpression xPathExpression = xPath.compile(string);
            String string2 = "Properties/Property";
            XPathExpression xPathExpression2 = xPath.compile(string2);
            String string3 = "../Properties/Property";
            XPathExpression xPathExpression3 = xPath.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "Class");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "Description");
                    RTPDePacketizerList rTPDePacketizerList = rTPContext.getDePacketizerList();
                    if (node2 == null || node3 == null) continue;
                    Object object2 = XMLUtils.getNodeValue(node2);
                    String string4 = XMLUtils.getNodeValue(node3);
                    String string5 = null;
                    if (node4 != null) {
                        string5 = XMLUtils.getNodeValue(node4);
                    }
                    if (rTPDePacketizerList.exists((String)object2)) {
                        int n = 1;
                        while (rTPDePacketizerList.exists((String)(object = (String)object2 + "[" + n + "]"))) {
                            ++n;
                        }
                        object2 = object;
                    }
                    object = new RTPDePacketizerItem((String)object2, string4);
                    if (string5 != null) {
                        ((RTPDePacketizerItem)object).setDescription(string5);
                    }
                    WMSProperties wMSProperties = ((RTPDePacketizerItem)object).getProperties();
                    NodeList nodeList2 = (NodeList)xPathExpression3.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList2 != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    if ((nodeList2 = (NodeList)xPathExpression2.evaluate(element2, XPathConstants.NODESET)) != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    IRTPDePacketizer iRTPDePacketizer = RTPDePacketizerFactory.createInstance(rTPContext, (RTPDePacketizerItem)object);
                    ((RTPDePacketizerItem)object).setInstance(iRTPDePacketizer);
                    if (iRTPDePacketizer == null) continue;
                    rTPDePacketizerList.put((String)object2, (RTPDePacketizerItem)object);
                    if (!WMSLoggerFactory.getLogger(MediaWriterUtils.class).isDebugEnabled()) continue;
                    WMSLoggerFactory.getLogger(MediaWriterUtils.class).debug(((RTPDePacketizerItem)object).toString());
                }
            } else {
                WMSLoggerFactory.getLogger(RTPUtils.class).error("loadConfigFile: error parsing RTP config file: XPath " + string + " missing");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(RTPContext rTPContext, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                RTPUtils.loadDePacketizers(rTPContext, element);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static RTPStream decodeStreamInfo(RTPContext rTPContext, String string, String string2) {
        RTPStream rTPStream = new RTPStream(rTPContext, string);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTSPRequestMessage.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        RTPTrack rTPTrack = null;
        String string3 = "";
        string2 = string2.replace("\r\n", "\n").replace("\r", "\n");
        String[] stringArray = string2.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            String string5;
            int n;
            String string6 = stringArray[i].trim();
            if (wMSLogger != null) {
                wMSLogger.debug("sdp: " + string6);
            }
            if (string6.startsWith("m=")) {
                if (rTPTrack != null) {
                    rTPTrack.setAnnounceData(string3);
                    if (rTPTrack.getTrackId().equals("unknown")) {
                        if (rTPTrack.isVideo()) {
                            rTPTrack.setTrackId("video");
                        }
                        if (rTPTrack.isAudio()) {
                            rTPTrack.setTrackId("audio");
                        }
                    }
                    rTPStream.addTrack(rTPTrack);
                    string3 = "";
                }
                rTPTrack = null;
                rTPTrack = new RTPTrack("unknown");
                rTPTrack.setStream(rTPStream);
                String[] stringArray2 = string6.substring(2).split("[ ]");
                String string7 = stringArray2[0].trim().toLowerCase();
                if (string7.startsWith("audio")) {
                    rTPTrack.setTrackType(8);
                } else if (string7.startsWith("video")) {
                    rTPTrack.setTrackType(9);
                } else if (string7.startsWith("mpegts-transport")) {
                    rTPStream.setRTCP(false);
                }
                if (stringArray2.length > 1) {
                    try {
                        String string8 = stringArray2[1];
                        String[] stringArray3 = string8.split("/");
                        n = Integer.parseInt(stringArray3[0]);
                        if (n > 0) {
                            rTPTrack.setRTPPort(n);
                            rTPTrack.setRTCPPort(n + 1);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (string6.startsWith("a=videoPID") || string6.startsWith("a=audioPID")) {
                int n2 = -1;
                int n3 = string6.indexOf(":");
                if (n3 >= 0) {
                    String string9 = string6.substring(n3 + 1).trim();
                    int n4 = 10;
                    if (string9.startsWith("0x")) {
                        n4 = 16;
                        string9 = string9.substring(2);
                    }
                    try {
                        n2 = Integer.parseInt(string9, n4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 >= 0) {
                    if (string6.startsWith("a=videoPID")) {
                        rTPStream.setMPEGTSVideoPID(n2);
                    }
                    if (string6.startsWith("a=audioPID")) {
                        rTPStream.setMPEGTSAudioPID(n2);
                    }
                }
            } else if (string6.startsWith("a=rtpmap")) {
                String[] stringArray4;
                if (rTPTrack != null && (stringArray4 = string6.split(" ")).length > 1) {
                    String string10 = stringArray4[stringArray4.length - 1].trim();
                    String[] stringArray5 = string10.split("[/]");
                    if (stringArray5.length > 0) {
                        rTPTrack.addTrackInfo("sample-type", stringArray5[0]);
                        rTPTrack.setSampleType(stringArray5[0]);
                    }
                    if (stringArray5.length > 1) {
                        rTPTrack.addTrackInfo("timescale", stringArray5[1]);
                        try {
                            rTPTrack.setTimescale(Integer.parseInt(stringArray5[1]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (rTPTrack.isAudio() && stringArray5.length > 2) {
                        rTPTrack.addTrackInfo("channel-count", stringArray5[2]);
                        try {
                            rTPTrack.setChannelCount(Integer.parseInt(stringArray5[2]));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (string6.startsWith("a=fmtp")) {
                int n5;
                if (rTPTrack != null && (n5 = string6.indexOf(" ")) >= 0) {
                    String string11 = string6.substring(n5 + 1).trim();
                    String[] stringArray6 = string11.split("[;]");
                    for (int j = 0; j < stringArray6.length; ++j) {
                        int n6;
                        String string12 = stringArray6[j].trim();
                        if (string12.length() == 0 || (n6 = string12.indexOf("=")) < 0) continue;
                        String string13 = string12.substring(0, n6).trim().toLowerCase();
                        string5 = string12.substring(n6 + 1).trim();
                        rTPTrack.addTrackInfo(string13, string5);
                    }
                }
            } else if (string6.startsWith("a=control")) {
                int n7;
                if (rTPTrack != null && (n7 = string6.indexOf(":")) >= 0) {
                    String string14 = string6.substring(n7 + 1);
                    rTPTrack.setTrackId(string14);
                }
            } else if (string6.startsWith("a=cliprect")) {
                int n8;
                if (rTPTrack != null && (n8 = string6.indexOf(":")) >= 0) {
                    String string15 = string6.substring(n8 + 1).trim();
                    rTPTrack.addTrackInfo("cliprect", string15);
                }
            } else if (string6.startsWith("a=framesize")) {
                String[] stringArray7;
                String string16;
                String[] stringArray8;
                int n9;
                if (rTPTrack != null && (n9 = string6.indexOf(":")) >= 0 && (stringArray8 = (string16 = string6.substring(n9 + 1).trim()).split("[ ]")).length >= 2 && (stringArray7 = stringArray8[1].split("[-]")).length >= 2) {
                    try {
                        rTPTrack.setWidth(Integer.parseInt(stringArray7[0]));
                        rTPTrack.setHeight(Integer.parseInt(stringArray7[1]));
                    }
                    catch (Exception exception) {}
                }
            } else if (string6.startsWith("a=ssrc-high")) {
                String string17;
                String[] stringArray9;
                long l = 0L;
                int n10 = string6.indexOf(":");
                if (n10 >= 0 && (stringArray9 = (string17 = string6.substring(n10 + 1).trim()).split("[ ]")).length > 0) {
                    int n11 = 10;
                    if (stringArray9[0].startsWith("0x")) {
                        n11 = 16;
                        stringArray9[0] = stringArray9[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray9[0], n11);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l2 = rTPTrack.getSSRC();
                        l2 = (l2 & 0xFFFFFFFFL) + (l << 32);
                        rTPTrack.setSSRC(l2);
                    }
                }
            } else if (string6.startsWith("a=ssrc-low")) {
                String string18;
                String[] stringArray10;
                long l = 0L;
                int n12 = string6.indexOf(":");
                if (n12 >= 0 && (stringArray10 = (string18 = string6.substring(n12 + 1).trim()).split("[ ]")).length > 0) {
                    int n13 = 10;
                    if (stringArray10[0].startsWith("0x")) {
                        n13 = 16;
                        stringArray10[0] = stringArray10[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray10[0], n13);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l3 = rTPTrack.getSSRC();
                        l3 = (l3 & 0xFFFFFFFF00000000L) + l;
                        rTPTrack.setSSRC(l3);
                    }
                }
            } else if (string6.startsWith("a=ssrc")) {
                String string19;
                String[] stringArray11;
                long l = 0L;
                int n14 = string6.indexOf(":");
                if (n14 >= 0 && (stringArray11 = (string19 = string6.substring(n14 + 1).trim()).split("[ ]")).length > 0) {
                    int n15 = 10;
                    if (stringArray11[0].startsWith("0x")) {
                        n15 = 16;
                        stringArray11[0] = stringArray11[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray11[0], n15);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        rTPTrack.setSSRC(l);
                    }
                }
            } else if (rTPTrack == null && string6.startsWith("v=")) {
                String string20 = string6.substring(2).trim();
                if (string20.length() > 0) {
                    rTPStream.addStreamInfo("protocolversion", string20);
                }
            } else if (rTPTrack == null && string6.startsWith("o=")) {
                String string21 = string6.substring(2).trim();
                if (string21.length() > 0) {
                    rTPStream.addStreamInfo("origin", string21);
                    String[] stringArray12 = string21.split("[ ]");
                    if (stringArray12.length > 1) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray12[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionId(l);
                    }
                    if (stringArray12.length > 2) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray12[2]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionVersion(l);
                    }
                    if (stringArray12.length > 5) {
                        rTPStream.setStreamSessionIp(stringArray12[5]);
                    }
                }
            } else if (rTPTrack == null && string6.startsWith("s=")) {
                String string22 = string6.substring(2).trim();
                if (string22.length() > 0) {
                    rTPStream.addStreamInfo("name", string22);
                }
            } else if (rTPTrack == null && string6.startsWith("i=")) {
                String string23 = string6.substring(2).trim();
                if (string23.length() > 0) {
                    rTPStream.addStreamInfo("information", string23);
                }
            } else if (rTPTrack == null && string6.startsWith("u=")) {
                String string24 = string6.substring(2).trim();
                if (string24.length() > 0) {
                    rTPStream.addStreamInfo("uri", string24);
                }
            } else if (rTPTrack == null && string6.startsWith("e=")) {
                String string25 = string6.substring(2).trim();
                if (string25.length() > 0) {
                    rTPStream.addStreamInfo("emailaddress", string25);
                }
            } else if (rTPTrack == null && string6.startsWith("p=")) {
                String string26 = string6.substring(2).trim();
                if (string26.length() > 0) {
                    rTPStream.addStreamInfo("phonenumber", string26);
                }
            } else if (string6.startsWith("c=")) {
                String string27 = string6.substring(2).trim();
                if (rTPTrack == null) {
                    if (string27.length() > 0) {
                        rTPStream.addStreamInfo("connectiondata", string27);
                        String[] stringArray13 = string27.split("[ ]");
                        if (stringArray13.length >= 3) {
                            String string28 = stringArray13[2].trim();
                            int n16 = string28.indexOf("/");
                            if (n16 >= 0) {
                                string28 = string28.substring(0, n16);
                            }
                            rTPStream.setHost(string28);
                        }
                    }
                } else {
                    String[] stringArray14 = string27.split("[ ]");
                    if (stringArray14.length >= 3) {
                        String string29 = stringArray14[2].trim();
                        int n17 = string29.indexOf("/");
                        if (n17 >= 0) {
                            string29 = string29.substring(0, n17);
                        }
                        rTPTrack.setHost(string29);
                    }
                    if (string27.length() > 0) {
                        rTPTrack.addTrackInfo("connectiondata", string27);
                    }
                }
            } else if (string6.startsWith("b=")) {
                String string30 = string6.substring(2).trim();
                if (string30.length() > 0) {
                    if (rTPTrack == null) {
                        rTPStream.addStreamInfo("bandwidth", string30);
                    } else {
                        rTPTrack.addTrackInfo("bandwidth", string30);
                    }
                }
            } else if (rTPTrack == null && string6.startsWith("t=")) {
                String string31 = string6.substring(2).trim();
                if (string31.length() > 0) {
                    rTPStream.addStreamInfo("timing", string31);
                }
            } else if (rTPTrack == null && string6.startsWith("r=")) {
                String string32 = string6.substring(2).trim();
                if (string32.length() > 0) {
                    rTPStream.addStreamInfo("repeattimes", string32);
                }
            } else if (rTPTrack == null && string6.startsWith("z=")) {
                String string33 = string6.substring(2).trim();
                if (string33.length() > 0) {
                    rTPStream.addStreamInfo("timezones", string33);
                }
            } else if (string6.startsWith("a=proto")) {
                String string34;
                String[] stringArray15;
                String string35;
                int n18;
                if (rTPTrack != null && (n18 = (string35 = string6.substring(2).trim()).indexOf(":")) >= 0 && (stringArray15 = (string34 = string35.substring(n18 + 1).trim()).split("[;]"))[0].endsWith("/TCP")) {
                    rTPTrack.setInterleaved(true);
                    for (n = 1; n < stringArray15.length; ++n) {
                        int n19;
                        String string36 = stringArray15[n].trim();
                        if (!string36.startsWith("interleaved=") || (n19 = string36.indexOf("=")) < 0) continue;
                        string5 = string36.substring(n19 + 1);
                        int n20 = string5.indexOf("-");
                        if (n20 > 0) {
                            try {
                                int n21 = Integer.parseInt(string5.substring(0, n20));
                                int n22 = Integer.parseInt(string5.substring(n20 + 1));
                                rTPTrack.setRTPPort(n21);
                                rTPTrack.setRTCPPort(n22);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        try {
                            int n23 = Integer.parseInt(string5.substring(0, n20));
                            rTPTrack.setRTPPort(n23);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else if (string6.startsWith("a=") && (string4 = string6.substring(2).trim()).length() != 0) {
                int n24 = string4.indexOf(":");
                String string37 = null;
                String string38 = null;
                if (n24 >= 0) {
                    string37 = string4.substring(0, n24).trim();
                    string38 = string4.substring(n24 + 1).trim();
                } else {
                    string37 = string4;
                }
                if (rTPTrack != null) {
                    rTPTrack.addTrackInfo(string37, string38);
                } else {
                    rTPStream.addStreamAttribute(string37, string38);
                }
            }
            string3 = string3 + string6 + "\n";
        }
        if (rTPTrack != null) {
            rTPTrack.setAnnounceData(string3);
            if (rTPTrack.getTrackId().equals("unknown")) {
                if (rTPTrack.isVideo()) {
                    rTPTrack.setTrackId("video");
                }
                if (rTPTrack.isAudio()) {
                    rTPTrack.setTrackId("audio");
                }
            }
            rTPStream.addTrack(rTPTrack);
        }
        rTPTrack = null;
        rTPStream.extractCodecConfigFromTrackInfo();
        return rTPStream;
    }

    public static byte[] formatH264CodecConfig(byte[] byArray, List<byte[]> list, byte[] byArray2) {
        byte[] byArray3 = null;
        int n = 8 + byArray.length + 1;
        for (byte[] byArray4 : list) {
            n += 2 + byArray4.length;
        }
        byArray3 = new byte[n];
        byArray3[0] = 1;
        boolean bl = false;
        if (byArray2 != null && byArray2.length >= 3) {
            byArray3[1] = byArray2[0];
            byArray3[2] = byArray2[1];
            byArray3[3] = byArray2[2];
            bl = true;
        }
        if (!bl) {
            byArray3[1] = byArray[1];
            byArray3[2] = byArray[2];
            byArray3[3] = byArray[3];
        }
        byArray3[4] = -1;
        byArray3[5] = -31;
        byArray3[6] = (byte)(byArray.length >> 8 & 0xFF);
        byArray3[7] = (byte)(byArray.length >> 0 & 0xFF);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        byArray3[8 + byArray.length] = (byte)(list.size() & 0xFF);
        Iterator<byte[]> iterator = list.iterator();
        int n2 = 9 + byArray.length;
        while (iterator.hasNext()) {
            byte[] byArray5 = iterator.next();
            byArray3[n2 + 0] = (byte)(byArray5.length >> 8 & 0xFF);
            byArray3[n2 + 1] = (byte)(byArray5.length >> 0 & 0xFF);
            System.arraycopy(byArray5, 0, byArray3, n2 + 2, byArray5.length);
            n2 += 2 + byArray5.length;
        }
        return byArray3;
    }
}

