/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.SystemUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.transport.udp.UDPTransportManager;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.ServerUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.HostPortConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VHostUtils {
    public static void loadHTTPProvider(Element element, HostPort hostPort) {
        block6: {
            try {
                String string;
                Node node = XMLUtils.getNodeByTagName(element, "BaseClass");
                if (node == null || (string = XMLUtils.getNodeValue(node)) == null || (string = string.trim()).length() <= 0) break block6;
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    IHTTPProvider iHTTPProvider = (IHTTPProvider)clazz.newInstance();
                    if (iHTTPProvider != null) {
                        try {
                            String string2 = "Properties/Property";
                            WMSProperties wMSProperties = new WMSProperties();
                            XMLUtils.loadConfigProperies(element, string2, wMSProperties);
                            iHTTPProvider.setProperties(wMSProperties);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPProvider: error parsing properties: " + exception.toString());
                            exception.printStackTrace();
                        }
                        hostPort.setHttpProvider(iHTTPProvider);
                        break block6;
                    }
                    WMSLoggerFactory.getLogger(ServerUtils.class).error("loadHTTPProvider: Error creating httpProvider (" + string + "): Instance null");
                    break block6;
                }
                WMSLoggerFactory.getLogger(ServerUtils.class).error("loadHTTPProvider: Error creating httpProvider (" + string + "): Class null");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPProvider: error parsing HTTPProvider properties: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void loadDatagramConfig(Element element, RTPUDPDatagramConfig rTPUDPDatagramConfig) {
        try {
            String string;
            Node node = XMLUtils.getNodeByTagName(element, "ReuseAddress");
            Node node2 = XMLUtils.getNodeByTagName(element, "MulticastBindToAddress");
            Node node3 = XMLUtils.getNodeByTagName(element, "ReceiveBufferSize");
            Node node4 = XMLUtils.getNodeByTagName(element, "SendBufferSize");
            Node node5 = XMLUtils.getNodeByTagName(element, "TrafficClass");
            Node node6 = XMLUtils.getNodeByTagName(element, "MulticastTimeout");
            Node node7 = XMLUtils.getNodeByTagName(element, "DatagramMaximumPacketSize");
            if (node != null) {
                string = XMLUtils.getNodeValue(node);
                try {
                    rTPUDPDatagramConfig.setReuseAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configReuseAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node2 != null) {
                string = XMLUtils.getNodeValue(node2);
                try {
                    rTPUDPDatagramConfig.setMulticastBindToAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configMulticastBindToAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node3 != null) {
                string = XMLUtils.getNodeValue(node3);
                try {
                    rTPUDPDatagramConfig.setReceiveBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configReceiveBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node4 != null) {
                string = XMLUtils.getNodeValue(node4);
                try {
                    rTPUDPDatagramConfig.setSendBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configSendBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node5 != null) {
                string = XMLUtils.getNodeValue(node5);
                try {
                    rTPUDPDatagramConfig.setTrafficClass(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configTrafficClass: (" + string + "): " + exception.toString());
                }
            }
            if (node6 != null) {
                string = XMLUtils.getNodeValue(node6);
                try {
                    rTPUDPDatagramConfig.setMulticastTimeout(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configMulticastTimeout: (" + string + "): " + exception.toString());
                }
            }
            if (node7 != null) {
                string = XMLUtils.getNodeValue(node7);
                try {
                    rTPUDPDatagramConfig.setDatagramMaximumPacketSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configDatagramMaximumPacketSizeElem: (" + string + "): " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing hostPortConfig properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadHostPortConfig(Element element, HostPortConfig hostPortConfig) {
        try {
            String string;
            Node node = XMLUtils.getNodeByTagName(element, "ReuseAddress");
            Node node2 = XMLUtils.getNodeByTagName(element, "ReceiveBufferSize");
            Node node3 = XMLUtils.getNodeByTagName(element, "SendBufferSize");
            Node node4 = XMLUtils.getNodeByTagName(element, "TrafficClass");
            Node node5 = XMLUtils.getNodeByTagName(element, "KeepAlive");
            Node node6 = XMLUtils.getNodeByTagName(element, "OobInline");
            Node node7 = XMLUtils.getNodeByTagName(element, "SoLingerTime");
            Node node8 = XMLUtils.getNodeByTagName(element, "TcpNoDelay");
            Node node9 = XMLUtils.getNodeByTagName(element, "AcceptorBackLog");
            if (node9 != null) {
                string = XMLUtils.getNodeValue(node9);
                try {
                    hostPortConfig.setAcceptorBackLog(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configAcceptorBackLog: (" + string + "): " + exception.toString());
                }
            }
            if (node != null) {
                string = XMLUtils.getNodeValue(node);
                try {
                    hostPortConfig.setReuseAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configReuseAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node2 != null) {
                string = XMLUtils.getNodeValue(node2);
                try {
                    hostPortConfig.setReceiveBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configReceiveBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node3 != null) {
                string = XMLUtils.getNodeValue(node3);
                try {
                    hostPortConfig.setSendBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configSendBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node4 != null) {
                string = XMLUtils.getNodeValue(node4);
                try {
                    hostPortConfig.setTrafficClass(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configTrafficClass: (" + string + "): " + exception.toString());
                }
            }
            if (node5 != null) {
                string = XMLUtils.getNodeValue(node5);
                try {
                    hostPortConfig.setKeepAlive(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configKeepAlive: (" + string + "): " + exception.toString());
                }
            }
            if (node6 != null) {
                string = XMLUtils.getNodeValue(node6);
                try {
                    hostPortConfig.setOobInline(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configOobInline: (" + string + "): " + exception.toString());
                }
            }
            if (node7 != null) {
                string = XMLUtils.getNodeValue(node7);
                try {
                    hostPortConfig.setSoLinger(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configSoLingerTime: (" + string + "): " + exception.toString());
                }
            }
            if (node8 != null) {
                string = XMLUtils.getNodeValue(node8);
                try {
                    hostPortConfig.setTcpNoDelay(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configTcpNoDelay: (" + string + "): " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPortConfig: error parsing hostPortConfig properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static HostPort loadHostPort(Element element) {
        HostPort hostPort = null;
        try {
            Node node = XMLUtils.getNodeByTagName(element, "DomainName");
            Node node2 = XMLUtils.getNodeByTagName(element, "IpAddress");
            Node node3 = XMLUtils.getNodeByTagName(element, "Port");
            Node node4 = XMLUtils.getNodeByTagName(element, "SSLFactoryClass");
            Node node5 = XMLUtils.getNodeByTagName(element, "ProcessorCount");
            if ((node != null || node2 != null) && node3 != null) {
                Element element2;
                String string = XMLUtils.getNodeValue(node);
                String string2 = XMLUtils.getNodeValue(node2);
                String string3 = XMLUtils.getNodeValue(node3);
                String string4 = XMLUtils.getNodeValue(node4);
                String string5 = XMLUtils.getNodeValue(node5);
                hostPort = new HostPort();
                if (node2 != null) {
                    if (string2 != null) {
                        string2 = SystemUtils.expandEnvironmentVariables(string2);
                    }
                    hostPort.setIpAddress(string2);
                } else if (node != null) {
                    if (string != null) {
                        string = SystemUtils.expandEnvironmentVariables(string);
                    }
                    hostPort.setDomainName(string);
                }
                hostPort.setPort(Integer.parseInt(string3));
                hostPort.setSslFactoryClass(string4);
                if (string5 != null && string5.length() > 0) {
                    hostPort.setProcessorCount(Integer.parseInt(string5));
                }
                Element element3 = (Element)XMLUtils.getNodeByTagName(element, "SocketConfiguration");
                HostPortConfig hostPortConfig = hostPort.getConfiguation();
                if (element3 != null && hostPortConfig != null) {
                    VHostUtils.loadHostPortConfig(element3, hostPortConfig);
                }
                if ((element2 = (Element)XMLUtils.getNodeByTagName(element, "HTTPProvider")) != null) {
                    VHostUtils.loadHTTPProvider(element2, hostPort);
                }
            } else {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: <DomainName> or <IpAddress> and <Port> required");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return hostPort;
    }

    public static HostPort loadHostPort(Element element, String string) {
        HostPort hostPort = null;
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (node != null) {
                hostPort = VHostUtils.loadHostPort((Element)node);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return hostPort;
    }

    public static void loadHostPortList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    HostPort hostPort = VHostUtils.loadHostPort(element2);
                    iVHost.getHostPortsList().add(hostPort);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPortList: error parsing HostPortList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static boolean doesApplicationExist(String string) {
        boolean bl = false;
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading ApplicationExists.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                bl = XMLUtils.getXMLPropertyBool(xPath, "/Root/Application/Exists", element, false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("doesApplicationExist: error parsing appExists config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    public static List getApplicationFolders(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading ApplicationNames.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/Applications/Application/Name";
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        String string3 = XMLUtils.getNodeValue(node);
                        arrayList.add(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("getApplicationFolders: error parsing application list config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading VHost.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                String string2;
                Element element = document.getDocumentElement();
                String string3 = "/Root/VHost/Properties/Property";
                WMSProperties wMSProperties = iVHost.getProperties();
                XMLUtils.loadConfigProperies(element, string3, wMSProperties);
                String string4 = "/Root/VHost/HostPortList/HostPort";
                VHostUtils.loadHostPortList(element, string4, iVHost);
                String string5 = "/Root/VHost/AdminInterface/HostPort";
                HostPort hostPort = VHostUtils.loadHostPort(element, string5);
                iVHost.setAdminInterfaceHostPort(hostPort);
                RTPContext rTPContext = iVHost.getRTPContext();
                XPathExpression xPathExpression = xPath.compile("/Root/VHost/RTP/DatagramConfiguration");
                Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node != null) {
                    VHostUtils.loadDatagramConfig((Element)node, iVHost.getRTPDatagramConfig());
                }
                iVHost.setNetConnectionProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/NetConnections/ProcessorCount", element, iVHost.getNetConnectionProcessorCount()));
                iVHost.setNetConnectionIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/NetConnections/IdleFrequency", element, iVHost.getNetConnectionIdleFrequency()));
                XPathExpression xPathExpression2 = xPath.compile("/Root/VHost/NetConnections/SocketConfiguration");
                Node node2 = (Node)xPathExpression2.evaluate(element, XPathConstants.NODE);
                if (node2 != null) {
                    VHostUtils.loadHostPortConfig((Element)node2, iVHost.getNetConnectionHostPortConfig());
                }
                if ((string2 = XMLUtils.getXMLPropertyStr(xPath, "/Root/VHost/Internal/ByteArrayOutputStream/BaseClass", element)) != null) {
                    ((VHost)iVHost).setByteArrayOutputStreamBaseClassPath(string2);
                }
                iVHost.setKeepAliveTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/HTTPTunnel/KeepAliveTimeout", element, iVHost.getKeepAliveTimeout()));
                if (XMLUtils.getXMLPropertyExists(xPath, "/Root/VHost/ThreadPool/PoolSize", element)) {
                    int n = XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/ThreadPool/PoolSize", element, 0);
                    iVHost.setCoreHandlerPoolSize(n / 2);
                    iVHost.setCoreTransportPoolSize(n / 2);
                } else {
                    iVHost.setCoreTransportPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/TransportThreadPool/PoolSize", element, iVHost.getCoreTransportPoolSize()));
                    iVHost.setCoreHandlerPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/HandlerThreadPool/PoolSize", element, iVHost.getCoreHandlerPoolSize()));
                }
                iVHost.setFileIOPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/FileIO/PoolSize", element, iVHost.getFileIOPoolSize()));
                iVHost.setIdleCheckFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/CheckFrequency", element, iVHost.getIdleCheckFrequency()));
                iVHost.setIdleWorkerCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/WorkerCount", element, iVHost.getIdleWorkerCount()));
                iVHost.setIdleMinimumWaitTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/MinimumWaitTime", element, iVHost.getIdleMinimumWaitTime()));
                iVHost.setClientTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Client/ClientTimeout", element, iVHost.getClientTimeout()));
                iVHost.setClientIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Client/IdleFrequency", element, iVHost.getClientIdleFrequency()));
                iVHost.setRTPIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/IdleFrequency", element, iVHost.getRTPIdleFrequency()));
                iVHost.setApplicationTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/ApplicationTimeout", element, iVHost.getApplicationTimeout()));
                iVHost.setPingTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/PingTimeout", element, iVHost.getPingTimeout()));
                iVHost.setValidationFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/ValidationFrequency", element, iVHost.getValidationFrequency()));
                iVHost.setMaximumPendingWriteBytes(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/MaximumPendingWriteBytes", element, iVHost.getMaximumPendingWriteBytes()));
                iVHost.setMaximumSetBufferTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/MaximumSetBufferTime", element, iVHost.getMaximumSetBufferTime()));
                UDPTransportManager uDPTransportManager = iVHost.getUDPTransportManager();
                uDPTransportManager.setUnicastIncomingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/UnicastIncoming/ProcessorCount", element, uDPTransportManager.getUnicastIncomingProcessorCount()));
                uDPTransportManager.setUnicastOutgoingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/UnicastOutgoing/ProcessorCount", element, uDPTransportManager.getUnicastOutgoingProcessorCount()));
                uDPTransportManager.setMulticastIncomingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/MulticastIncoming/ProcessorCount", element, uDPTransportManager.getMulticastIncomingProcessorCount()));
                uDPTransportManager.setMulticastOutgoingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/MulticastOutgoing/ProcessorCount", element, uDPTransportManager.getMulticastOutgoingProcessorCount()));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadConfigFile: error parsing vhost config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadMP3TagMap(Map map, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading MP3Tags.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "/Root/MP3Tags/MP3Tag";
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Element element2 = (Element)node;
                        Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                        Node node3 = XMLUtils.getNodeByTagName(element2, "ID");
                        if (node2 == null || node3 == null) continue;
                        String string3 = XMLUtils.getNodeValue(node2);
                        String string4 = XMLUtils.getNodeValue(node3);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("name", string3);
                        hashMap.put("id", string4);
                        if (map.containsKey(string4)) continue;
                        WMSLoggerFactory.getLogger(VHostUtils.class).debug("MP3map " + string3 + "=" + string4);
                        map.put(string4, hashMap);
                    }
                } else {
                    WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: XPath " + string2 + " missing");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

