/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.HostPortConfig;
import java.net.InetAddress;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class HostPort {
    private int port = 0;
    private String sslFactoryClass = "";
    private InetAddress address = null;
    private int processorCount = 1;
    private String domainName = null;
    private String ipAddress = null;
    private HostPortConfig configuation = new HostPortConfig();
    private IHTTPProvider httpProvider = null;
    private boolean isSuspended = false;

    public void setDomainName(String string) {
        try {
            this.domainName = string;
            this.address = string.equals("*") ? null : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPort.class).error("setDomainName: " + exception.toString());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getAddressStr() {
        String string = "";
        if (this.address == null) {
            string = "[any]";
        } else if (this.domainName != null) {
            string = this.domainName;
        } else if (this.ipAddress != null) {
            string = this.ipAddress;
        }
        return string;
    }

    public void setIpAddress(String string) {
        try {
            this.ipAddress = string;
            if (string.equals("*")) {
                this.address = null;
            } else {
                String[] stringArray = string.split("[.]");
                if (stringArray.length == 4) {
                    byte[] byArray = new byte[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        byArray[i] = (byte)Integer.parseInt(stringArray[i]);
                    }
                    this.address = InetAddress.getByAddress(byArray);
                } else {
                    WMSLoggerFactory.getLogger(HostPort.class).error("setIpAddress: invalid ipAddress: " + string);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPort.class).error("setIpAddress: " + exception.toString());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getSslFactoryClass() {
        return this.sslFactoryClass;
    }

    public void setSslFactoryClass(String string) {
        this.sslFactoryClass = string;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public void setProcessorCount(int n) {
        this.processorCount = n;
    }

    public String toString(boolean bl) {
        String string = "";
        if (bl) {
            if (this.address == null) {
                string = "[any]";
            } else if (this.domainName != null) {
                string = this.domainName;
            } else if (this.ipAddress != null) {
                string = this.ipAddress;
            }
            string = string + "-" + this.port;
        } else {
            if (this.address == null) {
                string = "[any]";
            } else if (this.domainName != null) {
                string = this.domainName;
            } else if (this.ipAddress != null) {
                string = this.ipAddress;
            }
            string = string + ":" + this.port;
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public HostPortConfig getConfiguation() {
        return this.configuation;
    }

    public void configureSocketAcceptor(SocketAcceptorConfig socketAcceptorConfig) {
        this.configuation.configureSocketAcceptor(socketAcceptorConfig);
    }

    public IHTTPProvider getHttpProvider() {
        return this.httpProvider;
    }

    public void setHttpProvider(IHTTPProvider iHTTPProvider) {
        this.httpProvider = iHTTPProvider;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean bl) {
        this.isSuspended = bl;
    }
}

