/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.io.IOScheduler;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.util.RandomIdGenerator;
import com.wowza.util.URLUtils;
import com.wowza.wms.admin.AdminServerNotifier;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationList;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientID;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IClient;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterConnection;
import com.wowza.wms.mediacaster.MediaCasterID;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterSettings;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.netconnection.NetConnectionConnection;
import com.wowza.wms.netconnection.NetConnectionID;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaWriterList;
import com.wowza.wms.transport.udp.UDPTransportManager;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.util.IIdleWorkerNotify;
import com.wowza.wms.util.IdleWorkersUtil;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.MediaReaderUtils;
import com.wowza.wms.util.MediaWriterUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.util.VHostUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.HostPortConfig;
import com.wowza.wms.vhost.HostPortList;
import com.wowza.wms.vhost.IAcceptorNotify;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.ThreadPool;
import com.wowza.wms.vhost.VHostSessionMap;
import com.wowza.wms.vhost.VHostWatchdog;
import com.wowza.wms.vhost.VHostWorkerThread;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketAcceptor;

public class VHost
implements IVHost {
    public static final String VHOST_DEFAULT = "_defaultVHost_";
    private Map<Integer, IClient> clientMap = new HashMap<Integer, IClient>();
    private Map applicationMap = new HashMap();
    private ClientID nextClientId = new ClientID(100);
    private NetConnectionID nextNetConnectionId = new NetConnectionID(100);
    private MediaCasterID nextMediaCasterId = new MediaCasterID(100);
    private int clientTimeout = 90000;
    private int clientIdleFrequency = 250;
    private int rtpIdleFrequency = 1000;
    private int netConnectionIdleFrequency = 3000;
    private int applicationTimeout = 6000;
    private int pingTimeout = 12000;
    private int validationFrequency = 8000;
    private int maximumPendingWriteBytes = 0;
    private int maximumSetBufferTime = 0;
    private int idleWorkerCount = 4;
    private int idleCheckFrequency = 100;
    private int idleMinimumWaitTime = 5;
    private int keepAliveTimeout = 2000;
    private int coreTransportPoolSize = 100;
    private int coreHandlerPoolSize = 100;
    private int fileIOPoolSize = 20;
    private VHostWatchdog vhostWatchdog = null;
    private HostPortList hostPortList = new HostPortList();
    private HostPort adminInterfaceHostPort = null;
    private int netConnectionProcessorCount = 2;
    private HostPortConfig netConnectionHostPortConfig = new HostPortConfig();
    private MediaCasterSettings mediaCasterSettings = new MediaCasterSettings();
    private MediaCasterList mediaCasterList = new MediaCasterList();
    private AuthenticationList authenticationList = new AuthenticationList();
    private Map acceptors = new HashMap();
    private StreamList streamTypes = new StreamList();
    private MediaReaderList mediaReaders = new MediaReaderList();
    private MediaWriterList mediaWriters = new MediaWriterList();
    private String homePath = null;
    protected WMSProperties properties = new WMSProperties();
    private ThreadPool transportThreadPool = null;
    private ThreadPool handlerThreadPool = null;
    private String name;
    private NetConnectionConnection netConnectionConnection = null;
    private MediaCasterConnection mediaCasterConnection = null;
    private List applicationListeners = new ArrayList();
    private List acceptorListeners = new ArrayList();
    private IOScheduler ioScheduler = new IOScheduler();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private IServer server = null;
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private int connectionLimit = 0;
    public Map mp3TagMap = new HashMap();
    private WMSReadWriteLock applicationLock = new WMSReentrantReadWriteLock();
    private boolean removeApplications = true;
    private IdleWorkersUtil idleWorkers = null;
    private VHostSessionMap sessionMap = new VHostSessionMap(this);
    private String byteArrayOutputStreamBaseClassPath = "";
    private Class byteArrayOutputStreamBaseClass = null;
    private RTPContext rtpContext = new RTPContext(this);
    private RTPUDPDatagramConfig rtpDatagramConfig = new RTPUDPDatagramConfig();
    private boolean shuttingDown = false;
    private RandomIdGenerator clientIdGenerator = null;
    private Properties dynamicLogProperties = null;
    private UDPTransportManager udpTransportManager = new UDPTransportManager();

    public VHost(String string) {
        this.name = string;
        this.netConnectionConnection = new NetConnectionConnection(this);
        this.mediaCasterConnection = new MediaCasterConnection(this);
        this.idleWorkers = new IdleWorkersUtil();
        this.clientIdGenerator = Server.getInstance().getClientIdGenerator();
        this.setByteArrayOutputStreamBaseClassPath("com.wowza.util.FasterByteArrayOutputStream");
        this.createWinMedia();
    }

    private void createWinMedia() {
        try {
            Method method;
            Object obj;
            Class<?> clazz = Class.forName("com.wowza.wms.plugin.winmedia.model.WinMediaContext");
            if (clazz != null && (obj = clazz.newInstance()) != null && (method = clazz.getMethod("init", IVHost.class)) != null) {
                method.invoke(obj, this);
                this.properties.put("WindowsMedia", obj);
                this.properties.put("WindowsMediaClass", clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invokeWinMedia(String string) {
        try {
            Method method;
            Object v;
            Class clazz = (Class)this.properties.get("WindowsMediaClass");
            if (clazz != null && (v = this.properties.get("WindowsMedia")) != null && (method = clazz.getMethod(string, new Class[0])) != null) {
                method.invoke(v, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initWinMedia() {
        this.invokeWinMedia("initWinMedia");
    }

    public void startWinMedia() {
        this.invokeWinMedia("startWinMedia");
    }

    public void stopWinMedia() {
        this.invokeWinMedia("stopWinMedia");
    }

    @NoMBean
    public void setServer(IServer iServer) {
        this.server = iServer;
    }

    @NoMBean
    public void init(String string) {
        this.homePath = this.loadHomePath(string);
        this.loadConfig();
        this.initLogging();
        this.vhostWatchdog = new VHostWatchdog(this, 500);
        this.vhostWatchdog.setDaemon(true);
        this.vhostWatchdog.start();
        this.ioScheduler.init(this.coreHandlerPoolSize);
        if (this.coreTransportPoolSize > 0) {
            this.transportThreadPool = new ThreadPool(this, "VHostTransport." + this.name);
            this.transportThreadPool.init(this.coreTransportPoolSize);
        }
        if (this.coreHandlerPoolSize > 0) {
            this.handlerThreadPool = new ThreadPool(this, "VHostHandler." + this.name);
            this.handlerThreadPool.init(this.coreHandlerPoolSize);
        }
        this.idleWorkers.setWorkerCount(this.getIdleWorkerCount());
        this.idleWorkers.setPollFreq(this.getIdleCheckFrequency());
        this.idleWorkers.setMinimumWaitTime(this.getIdleMinimumWaitTime());
        this.idleWorkers.start();
        this.udpTransportManager.init(this);
        this.initWinMedia();
    }

    public boolean isHomePathAppPath() {
        if (Bootstrap.isServerURLConfig()) {
            return false;
        }
        String string = Bootstrap.getServerHome((int)1);
        return new File(this.homePath).equals(new File(string));
    }

    private void initLogging() {
        if (!this.isHomePathAppPath()) {
            String string = this.homePath + File.separatorChar + "conf" + File.separatorChar + "log4j.properties";
            if (new File(string).exists()) {
                WMSLoggerFactory.initializeLogging(URLUtils.pathToFileURL(string), this);
            } else if (Bootstrap.getConfigURL() != null) {
                WMSLoggerFactory.initializeLogging(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/log4j.properties")), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.idleWorkers.halt();
        this.applicationLock.writeLock().lock();
        try {
            arrayList.addAll(this.clientMap.keySet());
            for (Object object : arrayList) {
                this.killClient((Integer)object);
            }
            arrayList.clear();
            for (Object object : this.applicationMap.keySet()) {
                arrayList.add(new String((String)object));
            }
            for (Object object : arrayList) {
                IApplication iApplication = this.getApplication((String)object);
                if (iApplication == null) continue;
                this.removeApplication(iApplication, true);
            }
            arrayList.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.shutdown: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.vhostWatchdog.halt();
        if (this.transportThreadPool != null) {
            this.transportThreadPool.terminate();
            this.transportThreadPool = null;
        }
        if (this.handlerThreadPool != null) {
            this.handlerThreadPool.terminate();
            this.handlerThreadPool = null;
        }
        if (this.ioScheduler != null) {
            this.ioScheduler.terminate();
        }
        this.ioScheduler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownApplication(String string) {
        this.applicationLock.writeLock().lock();
        try {
            Application application = (Application)this.applicationMap.get(string);
            if (application == null) {
            } else {
                List list = application.getAppInstanceNames();
                for (String string2 : list) {
                    application.shutdownAppInstance(string2);
                }
                this.removeApplication(application, false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("shutdownApplication: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
    }

    public boolean startApplicationInstance(String string) {
        return this.startApplicationInstance(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startApplicationInstance(String string, String string2) {
        boolean bl = false;
        this.applicationLock.writeLock().lock();
        try {
            IApplication iApplication;
            if (string == null) {
                string = "_defapp_";
            }
            if (string2 == null) {
                string2 = "_definst_";
            }
            if ((iApplication = this.getApplication(string)) == null) {
            } else {
                IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string2);
                if (iApplicationInstance == null) {
                } else {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("removeApplication: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        return bl;
    }

    public List getApplicationFolderNames() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getHomePath() + "/applications";
        File file = new File(string);
        if (file.exists()) {
            object = file.listFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                File file2 = object[i];
                if (file2.getName().startsWith(".") || !file2.exists() || !file2.isDirectory()) continue;
                arrayList.add(file2.getName());
            }
        }
        if (Bootstrap.getConfigURL() != null) {
            object = VHostUtils.getApplicationFolders(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/ApplicationList.xml")));
            arrayList.addAll((Collection<String>)object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getApplicationNames() {
        ArrayList arrayList = new ArrayList();
        this.applicationLock.readLock().lock();
        try {
            arrayList.addAll(this.applicationMap.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("getApplicationNames: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplication(IApplication iApplication, boolean bl) {
        ((Application)iApplication).addIOPerformance(this.ioPerformanceCounter);
        iApplication.shutdown(bl);
        this.applicationLock.writeLock().lock();
        try {
            String string = iApplication.getName();
            this.applicationMap.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("removeApplication: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.notifyApplicationDestroy(iApplication);
    }

    private String loadHomePath(String string) {
        return string;
    }

    public String getProperty(String string) {
        return this.properties.getPropertyStr(string);
    }

    private void loadConfig() {
        String string = Bootstrap.getConfigURL();
        String string2 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "Streams.xml";
        if (new File(string2).exists()) {
            StreamUtils.loadConfigFile(this.streamTypes, URLUtils.pathToFileURL(string2));
        } else if (string != null) {
            StreamUtils.loadConfigFile(this.streamTypes, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/Streams.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: Streams.xml missing: " + string2);
        }
        String string3 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaReaders.xml";
        if (new File(string3).exists()) {
            MediaReaderUtils.loadConfigFile(this.mediaReaders, URLUtils.pathToFileURL(string3));
        } else if (string != null) {
            MediaReaderUtils.loadConfigFile(this.mediaReaders, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaReaders.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaReaders.xml missing: " + string3);
        }
        String string4 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaWriters.xml";
        if (new File(string4).exists()) {
            MediaWriterUtils.loadConfigFile(this.mediaWriters, URLUtils.pathToFileURL(string4));
        } else if (string != null) {
            MediaWriterUtils.loadConfigFile(this.mediaWriters, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaWriters.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaWriters.xml missing: " + string4);
        }
        String string5 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MP3Tags.xml";
        if (new File(string5).exists()) {
            VHostUtils.loadMP3TagMap(this.mp3TagMap, URLUtils.pathToFileURL(string5));
        } else if (string != null) {
            VHostUtils.loadMP3TagMap(this.mp3TagMap, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MP3Tags.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MP3Tags.xml missing: " + string5);
        }
        String string6 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "VHost.xml";
        if (new File(string6).exists()) {
            VHostUtils.loadConfigFile(this, URLUtils.pathToFileURL(string6));
        } else if (string != null) {
            VHostUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/VHost.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: VHost.xml missing: " + string6);
        }
        String string7 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "MediaCasters.xml";
        if (new File(string7).exists()) {
            MediaCasterUtils.loadConfigFile(this, URLUtils.pathToFileURL(string7));
        } else if (string != null) {
            MediaCasterUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/MediaCasters.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: MediaCasters.xml missing: " + string7);
        }
        String string8 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "RTP.xml";
        if (new File(string8).exists()) {
            RTPUtils.loadConfigFile(this.getRTPContext(), URLUtils.pathToFileURL(string8));
        } else if (string != null) {
            RTPUtils.loadConfigFile(this.getRTPContext(), URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/RTP.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: RTP.xml missing: " + string8);
        }
        String string9 = this.homePath + File.separatorChar + "conf" + File.separatorChar + "Authentication.xml";
        if (new File(string9).exists()) {
            AuthenticationUtils.loadConfigFile(this, URLUtils.pathToFileURL(string9));
        } else if (string != null) {
            AuthenticationUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(string, "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/Authentication.xml")));
        } else {
            WMSLoggerFactory.getLogger(VHost.class).error("VHost.loadConfig: Authentication.xml missing: " + string9);
        }
    }

    @NoMBean
    public StreamList getStreamTypes() {
        return this.streamTypes;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNetConnectionId() {
        int n;
        NetConnectionID netConnectionID = this.nextNetConnectionId;
        synchronized (netConnectionID) {
            n = this.nextNetConnectionId.incNetConnectionID();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextMediaCasterId() {
        int n;
        MediaCasterID mediaCasterID = this.nextMediaCasterId;
        synchronized (mediaCasterID) {
            n = this.nextMediaCasterId.incMediaCasterID();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IClient getClient(int n, boolean bl) {
        IClient iClient = null;
        if (n == -1) {
            if (bl) {
                n = this.clientIdGenerator.getNextId();
                this.applicationLock.writeLock().lock();
                try {
                    iClient = new Client(this, n);
                    this.clientMap.put(new Integer(n), iClient);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHost.class).error("getClient: " + exception.toString());
                }
                finally {
                    this.applicationLock.writeLock().unlock();
                }
            }
        } else {
            this.applicationLock.readLock().lock();
            iClient = this.clientMap.get(new Integer(n));
            this.applicationLock.readLock().unlock();
        }
        return iClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void reparentClient(IClient iClient) {
        VHost vHost = (VHost)iClient.getVHost();
        vHost.applicationLock.writeLock().lock();
        int n = iClient.getClientId();
        try {
            vHost.clientMap.remove(new Integer(n));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("reparentClient(old): " + exception.toString());
        }
        finally {
            vHost.applicationLock.writeLock().unlock();
        }
        this.applicationLock.writeLock().lock();
        try {
            iClient.reparentClient(this);
            this.clientMap.put(new Integer(n), iClient);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("reparentClient(new): " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
    }

    @NoMBean
    public IClient getClient(int n) {
        return this.getClient(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkApplicationTimeout() {
        this.applicationLock.readLock().lock();
        ArrayList arrayList = new ArrayList(this.applicationMap.keySet());
        this.applicationLock.readLock().unlock();
        for (String string : arrayList) {
            Application application = (Application)this.getApplication(string);
            if (application == null) continue;
            application.doWatchdog();
            WMSReadWriteLock wMSReadWriteLock = this.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (application.getInstanceCount() != 0) continue;
                this.removeApplication(application, false);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog2: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
        arrayList.clear();
    }

    @NoMBean
    public void doWatchdog() {
        boolean bl = false;
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: checkClientTimeout");
            }
            this.checkClientTimeout();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: checkClientTimeout: " + exception.toString());
        }
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: checkApplicationTimeout");
            }
            this.checkApplicationTimeout();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: checkApplicationTimeout: " + exception.toString());
        }
        try {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance");
            }
            this.updateApplicationIOPerformance();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.doWatchdog: updateApplicationIOPerformance: " + exception.toString());
        }
    }

    @NoMBean
    public void updateApplicationIOPerformance() {
        boolean bl = false;
        this.applicationLock.readLock().lock();
        ArrayList arrayList = new ArrayList(this.applicationMap.values());
        this.applicationLock.readLock().unlock();
        if (bl) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: size: " + arrayList.size());
        }
        for (Application application : arrayList) {
            if (bl) {
                WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: name: " + application.getName());
            }
            application.updateIOPerformance();
        }
    }

    @NoMBean
    public void checkClientTimeout() {
        long l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = null;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.applicationLock.readLock().lock();
        arrayList2.addAll(this.clientMap.keySet());
        this.applicationLock.readLock().unlock();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.applicationLock.readLock().lock();
            IClient object = this.clientMap.get(new Integer(n));
            this.applicationLock.readLock().unlock();
            if (object == null) continue;
            long l2 = ((Client)object).getTouch();
            boolean bl = ((Client)object).isWaitingForIO();
            if (!bl && l2 > 0L && l - l2 > (long)this.clientTimeout) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(n);
                continue;
            }
            if (l2 != 0L) continue;
            ((Client)object).touch();
        }
        if (arrayList != null) {
            for (Integer n : arrayList) {
                this.applicationLock.readLock().lock();
                Client client = (Client)this.clientMap.get(n);
                this.applicationLock.readLock().unlock();
                if (client != null) {
                    client.setThreadContext();
                }
                WMSLoggerFactory.getLogger(VHost.class).info("client connectionClosed [" + n + "] watchdog");
                this.killClient(n);
                if (!(Thread.currentThread() instanceof VHostWorkerThread)) continue;
                ((VHostWorkerThread)Thread.currentThread()).clear();
            }
        }
    }

    public void killRTSPSession(String string) {
        try {
            IoSession ioSession = null;
            List<Object> list = this.sessionMap.getSessions();
            for (IoSession ioSession2 : list) {
                String string2;
                RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession2.getAttribute("wmsSessionInfo");
                if (rtmpSessionInfo == null || (string2 = rtmpSessionInfo.getRTSPSessionId()) == null || !string2.equals(string)) continue;
                ioSession = ioSession2;
                break;
            }
            if (ioSession != null) {
                ioSession.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("killRTSPSession: " + exception.toString());
        }
    }

    public void killClient(int n) {
        IoSession ioSession = null;
        List<Object> list = this.sessionMap.getSessions();
        for (IoSession object : list) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)object.getAttribute("wmsSessionInfo");
            if (rtmpSessionInfo == null || rtmpSessionInfo.getClientId() != n) continue;
            ioSession = object;
            break;
        }
        if (ioSession != null) {
            WMSLoggerFactory.getLogger(VHost.class).debug("client killClient [session]");
            ioSession.close();
            this.applicationLock.readLock().lock();
            IClient iClient = this.clientMap.get(new Integer(n));
            this.applicationLock.readLock().unlock();
            if (iClient != null) {
                WMSLoggerFactory.getLogger(VHost.class).debug("client killClient [session]: nukeit");
                this.removeSession(ioSession);
                this.removeClient(n);
            }
        } else {
            WMSLoggerFactory.getLogger(VHost.class).debug("client killClient [remove]");
            this.removeClient(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(int n) {
        IClient iClient = null;
        this.applicationLock.writeLock().lock();
        try {
            iClient = this.clientMap.remove(new Integer(n));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("removeClient: " + exception.toString());
        }
        finally {
            this.applicationLock.writeLock().unlock();
        }
        this.clientIdGenerator.releaseId(n);
        if (iClient != null) {
            ((Client)iClient).shutdownClientInternal();
        }
    }

    public int getClientCount() {
        int n = 0;
        this.applicationLock.readLock().lock();
        n = this.clientMap.size();
        this.applicationLock.readLock().unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IApplication getApplication(String string) {
        IApplication iApplication = null;
        if (string.length() == 0) {
            return null;
        }
        this.applicationLock.readLock().lock();
        try {
            iApplication = (IApplication)this.applicationMap.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("getApplication[1]");
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        if (iApplication == null) {
            this.applicationLock.writeLock().lock();
            try {
                iApplication = (IApplication)this.applicationMap.get(string);
                if (iApplication == null && this.applicationExists(string)) {
                    iApplication = new Application(string, this);
                    this.applicationMap.put(string, iApplication);
                    WMSLoggerFactory.initContextLogging(iApplication);
                    ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
                    iApplication.getConnectionCounter().addConnectionListener(connectionNotifier);
                    this.notifyApplicationCreate(iApplication);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHost.class).error("getApplication[2]");
            }
            finally {
                this.applicationLock.writeLock().unlock();
            }
        }
        return iApplication;
    }

    public boolean applicationExists(String string) {
        boolean bl;
        String string2 = this.getHomePath() + "/applications/" + string;
        File file = new File(string2);
        boolean bl2 = bl = file.exists() && file.isDirectory();
        if (!bl && Bootstrap.getConfigURL() != null) {
            bl = VHostUtils.doesApplicationExist(URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getName()) + "&filename=" + URLUtils.encodeValue("conf/ApplicationExists.xml") + "&applicationName=" + string));
        }
        return bl;
    }

    public String getHomePath() {
        return this.homePath;
    }

    @NoMBean
    public WMSProperties getProperties() {
        return this.properties;
    }

    public int getCoreTransportPoolSize() {
        return this.coreTransportPoolSize;
    }

    public void setCoreTransportPoolSize(int n) {
        this.coreTransportPoolSize = n;
    }

    public int getCoreHandlerPoolSize() {
        return this.coreHandlerPoolSize;
    }

    public void setCoreHandlerPoolSize(int n) {
        this.coreHandlerPoolSize = n;
    }

    public void setClientTimeout(int n) {
        this.clientTimeout = n;
    }

    @NoMBean
    public HostPortList getHostPortsList() {
        return this.hostPortList;
    }

    @NoMBean
    public ThreadPool getThreadPool() {
        return this.getHandlerThreadPool();
    }

    @NoMBean
    public ThreadPool getTransportThreadPool() {
        return this.transportThreadPool == null ? Server.getInstance().getTransportThreadPool() : this.transportThreadPool;
    }

    @NoMBean
    public ThreadPool getHandlerThreadPool() {
        return this.handlerThreadPool == null ? Server.getInstance().getHandlerThreadPool() : this.handlerThreadPool;
    }

    public String getName() {
        return this.name;
    }

    @NoMBean
    public HostPort getAdminInterfaceHostPort() {
        return this.adminInterfaceHostPort;
    }

    @NoMBean
    public void setAdminInterfaceHostPort(HostPort hostPort) {
        this.adminInterfaceHostPort = hostPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addAcceptor(HostPort hostPort, IoAcceptor ioAcceptor, IoHandlerAdapter ioHandlerAdapter) {
        Map map = this.acceptors;
        synchronized (map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("acceptor", ioAcceptor);
            hashMap.put("handlerAdapter", ioHandlerAdapter);
            this.acceptors.put(hostPort, hashMap);
            this.notifyAcceptorCreate(hostPort, hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeAcceptor(HostPort hostPort) {
        Map map = this.acceptors;
        synchronized (map) {
            Map map2 = (Map)this.acceptors.remove(hostPort);
            this.notifyAcceptorDestroy(hostPort, map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public Map getAcceptors() {
        Map map = this.acceptors;
        synchronized (map) {
            return new HashMap(this.acceptors);
        }
    }

    @NoMBean
    public void addIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        this.idleWorkers.addIdleWorkerListener(iIdleWorkerNotify);
    }

    @NoMBean
    public void removeIdleWorkerListener(IIdleWorkerNotify iIdleWorkerNotify) {
        this.idleWorkers.removeIdleWorkerListener(iIdleWorkerNotify);
    }

    @NoMBean
    public void addSession(Object object) {
        this.sessionMap.addSession(object);
    }

    @NoMBean
    public void notifySessionOpen(Object object, int n, IClient iClient) {
        this.sessionMap.notifySessionOpen(object, n, iClient);
    }

    @NoMBean
    public void removeSession(Object object) {
        this.sessionMap.removeSession(object);
    }

    @NoMBean
    public List getSessions() {
        return this.sessionMap.getSessions();
    }

    public int getFileIOPoolSize() {
        return this.fileIOPoolSize;
    }

    public void setFileIOPoolSize(int n) {
        this.fileIOPoolSize = n;
    }

    @NoMBean
    public NetConnectionConnection getNetConnectionConnection() {
        return this.netConnectionConnection;
    }

    @NoMBean
    public MediaCasterConnection getMediaCasterConnection() {
        return this.mediaCasterConnection;
    }

    @NoMBean
    public void setNetConnectionConnection(NetConnectionConnection netConnectionConnection) {
        this.netConnectionConnection = netConnectionConnection;
    }

    public int getNetConnectionProcessorCount() {
        return this.netConnectionProcessorCount;
    }

    public void setNetConnectionProcessorCount(int n) {
        this.netConnectionProcessorCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addApplicationListener(IApplicationNotify iApplicationNotify) {
        List list = this.applicationListeners;
        synchronized (list) {
            this.applicationListeners.add(iApplicationNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeApplicationListener(IApplicationNotify iApplicationNotify) {
        List list = this.applicationListeners;
        synchronized (list) {
            this.applicationListeners.remove(iApplicationNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyApplicationCreate(IApplication iApplication) {
        ArrayList arrayList = null;
        List list = this.applicationListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.applicationListeners);
        }
        for (IApplicationNotify iApplicationNotify : arrayList) {
            iApplicationNotify.onApplicationCreate(iApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyApplicationDestroy(IApplication iApplication) {
        ArrayList arrayList = null;
        List list = this.applicationListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.applicationListeners);
        }
        for (IApplicationNotify iApplicationNotify : arrayList) {
            iApplicationNotify.onApplicationDestroy(iApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addAcceptorListener(IAcceptorNotify iAcceptorNotify) {
        List list = this.acceptorListeners;
        synchronized (list) {
            this.acceptorListeners.add(iAcceptorNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeAcceptorListener(IAcceptorNotify iAcceptorNotify) {
        List list = this.acceptorListeners;
        synchronized (list) {
            this.acceptorListeners.remove(iAcceptorNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyAcceptorCreate(HostPort hostPort, Map map) {
        ArrayList arrayList = null;
        List list = this.acceptorListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.acceptorListeners);
        }
        for (IAcceptorNotify iAcceptorNotify : arrayList) {
            iAcceptorNotify.onAcceptorCreate(hostPort, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void notifyAcceptorDestroy(HostPort hostPort, Map map) {
        ArrayList arrayList = null;
        List list = this.acceptorListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.acceptorListeners);
        }
        for (IAcceptorNotify iAcceptorNotify : arrayList) {
            iAcceptorNotify.onAcceptorDestroy(hostPort, map);
        }
    }

    @NoMBean
    public IOScheduler getIOScheduler() {
        return this.ioScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IOPerformanceCounter updateIOPerformance() {
        ArrayList arrayList = null;
        this.applicationLock.readLock().lock();
        try {
            arrayList = new ArrayList(this.applicationMap.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHost.class).error("updateIOPerformance: " + exception.toString());
        }
        finally {
            this.applicationLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (Application application : arrayList) {
                application.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        return this.ioPerformanceCounter;
    }

    @NoMBean
    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @NoMBean
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @NoMBean
    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    public void setConnectionLimit(int n) {
        this.connectionLimit = n;
    }

    @NoMBean
    public MediaReaderList getMediaReaders() {
        return this.mediaReaders;
    }

    @NoMBean
    public MediaWriterList getMediaWriters() {
        return this.mediaWriters;
    }

    @NoMBean
    public Map getMp3TagMap() {
        return this.mp3TagMap;
    }

    @NoMBean
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    public int getValidationFrequency() {
        return this.validationFrequency;
    }

    public void setValidationFrequency(int n) {
        this.validationFrequency = n;
    }

    public int getMaximumPendingWriteBytes() {
        return this.maximumPendingWriteBytes;
    }

    public void setMaximumPendingWriteBytes(int n) {
        this.maximumPendingWriteBytes = n;
    }

    public int getMaximumSetBufferTime() {
        return this.maximumSetBufferTime;
    }

    public void setMaximumSetBufferTime(int n) {
        this.maximumSetBufferTime = n;
    }

    @NoMBean
    public WMSReadWriteLock getApplicationLock() {
        return this.applicationLock;
    }

    public boolean isRemoveApplications() {
        return this.removeApplications;
    }

    public void setRemoveApplications(boolean bl) {
        this.removeApplications = bl;
    }

    public int getClientIdleFrequency() {
        return this.clientIdleFrequency;
    }

    public void setClientIdleFrequency(int n) {
        this.clientIdleFrequency = n;
    }

    public int getRTPIdleFrequency() {
        return this.rtpIdleFrequency;
    }

    public void setRTPIdleFrequency(int n) {
        this.rtpIdleFrequency = n;
    }

    public int getIdleCheckFrequency() {
        return this.idleCheckFrequency;
    }

    public void setIdleCheckFrequency(int n) {
        this.idleCheckFrequency = n;
    }

    public int getIdleWorkerCount() {
        return this.idleWorkerCount;
    }

    public void setIdleWorkerCount(int n) {
        this.idleWorkerCount = n;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public HostPortConfig getNetConnectionHostPortConfig() {
        return this.netConnectionHostPortConfig;
    }

    public MediaCasterSettings getMediaCasterSettings() {
        return this.mediaCasterSettings;
    }

    public MediaCasterList getMediaCasterList() {
        return this.mediaCasterList;
    }

    public int getNetConnectionIdleFrequency() {
        return this.netConnectionIdleFrequency;
    }

    public void setNetConnectionIdleFrequency(int n) {
        this.netConnectionIdleFrequency = n;
    }

    public String getByteArrayOutputStreamBaseClassPath() {
        return this.byteArrayOutputStreamBaseClassPath;
    }

    public void setByteArrayOutputStreamBaseClassPath(String string) {
        this.byteArrayOutputStreamBaseClassPath = string;
        this.byteArrayOutputStreamBaseClass = null;
        try {
            this.byteArrayOutputStreamBaseClass = Class.forName(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("VHost setByteArrayOutputStreamBaseClassPath: " + string + " :" + exception.toString());
        }
    }

    public IFasterByteArrayOutputStream getOutputStream() {
        IFasterByteArrayOutputStream iFasterByteArrayOutputStream = null;
        try {
            if (this.byteArrayOutputStreamBaseClass != null) {
                iFasterByteArrayOutputStream = (IFasterByteArrayOutputStream)this.byteArrayOutputStreamBaseClass.newInstance();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("VHost getOutputStream: " + exception.toString());
        }
        return iFasterByteArrayOutputStream;
    }

    public long getScheduledWriteMaxSessionBytes() {
        return this.sessionMap.getScheduledWriteMaxSessionBytes();
    }

    public int getScheduledWriteMaxSessionClientId() {
        return this.sessionMap.getScheduledWriteMaxSessionClientId();
    }

    public long getScheduledWriteSessions() {
        return this.sessionMap.getScheduledWriteSessions();
    }

    public long getScheduledWriteRequests() {
        return this.sessionMap.getScheduledWriteRequests();
    }

    public long getScheduledWriteBytes() {
        return this.sessionMap.getScheduledWriteBytes();
    }

    public long getScheduledReadMaxSessionBytes() {
        return this.sessionMap.getScheduledReadMaxSessionBytes();
    }

    public long getWaitingReadBytes() {
        return this.sessionMap.getWaitingReadBytes();
    }

    public RTPContext getRTPContext() {
        return this.rtpContext;
    }

    public RTPUDPDatagramConfig getRTPDatagramConfig() {
        return this.rtpDatagramConfig;
    }

    public AuthenticationList getAuthenticationList() {
        return this.authenticationList;
    }

    public int getIdleMinimumWaitTime() {
        return this.idleMinimumWaitTime;
    }

    public void setIdleMinimumWaitTime(int n) {
        this.idleMinimumWaitTime = n;
    }

    public IdleWorkersUtil getIdleWorkers() {
        return this.idleWorkers;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void setShuttingDown(boolean bl) {
        this.shuttingDown = bl;
    }

    public Properties getDynamicLogProperties() {
        return this.dynamicLogProperties;
    }

    public void setDynamicLogProperties(Properties properties) {
        this.dynamicLogProperties = properties;
    }

    public UDPTransportManager getUDPTransportManager() {
        return this.udpTransportManager;
    }

    public void unbindAllHostPorts() {
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            this.closeHostPort(hostPort, false);
        }
    }

    public void suspendAllHostPorts() {
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            this.closeHostPort(hostPort, true);
        }
    }

    public boolean isSuspended() {
        boolean bl = true;
        Map map = this.getAcceptors();
        for (HostPort hostPort : map.keySet()) {
            if (hostPort.isSuspended()) continue;
            bl = false;
        }
        return bl;
    }

    public void closeHostPort(HostPort hostPort, boolean bl) {
        Object object2;
        Map map = (Map)this.acceptors.get(hostPort);
        IoAcceptor ioAcceptor = (IoAcceptor)map.get("acceptor");
        Set set = ioAcceptor.getManagedServiceAddresses();
        for (Object object2 : set) {
            WMSLoggerFactory.getLogger(VHost.class).info("VHost." + (bl ? "suspend" : "unbind") + "[" + this.getName() + "]: " + object2);
            try {
                if (!(ioAcceptor instanceof SocketAcceptor)) continue;
                ((SocketAcceptor)ioAcceptor).suspend((SocketAddress)object2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHost.class).error("VHost." + (bl ? "suspend" : "unbind") + "[" + this.getName() + "]: " + object2 + ": " + exception.toString());
            }
        }
        object2 = hostPort.getHttpProvider();
        if (object2 != null) {
            object2.onUnbind(this, hostPort);
        }
        hostPort.setSuspended(true);
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private VHost vhost = null;
        private byte[] control = null;

        public ConnectionNotifier(VHost vHost2) {
            this.vhost = vHost2;
            this.control = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray = bigInteger.toByteArray();
            for (int i = 0; i < this.control.length; ++i) {
                int n = i;
                this.control[n] = (byte)(this.control[n] ^ byArray[(i + 11) % byArray.length]);
            }
        }

        private void checkLicense(byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("VHost checkLicense exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(0);
            }
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.incrementAccept(connectionHolder, date, l, byArray);
            this.checkLicense(byArray);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.incrementReject(connectionHolder, n, date, l, byArray);
            this.checkLicense(byArray);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            byte[] byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(this.control, 0, byArray, 0, ModuleConnect.lc.length);
            this.vhost.connectionCounter.decrement(connectionHolder, bl, date, l, byArray);
            this.checkLicense(byArray);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private VHost vhost = null;

        public ConnectionValidator(VHost vHost2) {
            this.vhost = vHost2;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            int n;
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (n = 0; n < byArray.length; ++n) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[(n + 2) % byArray2.length]);
            }
            n = ((Server)this.vhost.server).getConnectionValidator().validateConnection(connectionCounter, connectionHolder, byArray) ? 1 : 0;
            int n3 = this.vhost.getConnectionLimit();
            if (n3 > 0 && this.vhost.getConnectionCounter().getCurrent() >= (long)n3) {
                AdminServerNotifier.sendConnectionLicenseLimit(connectionHolder.getClient(), "com.wowza.wms.connect.ErrorVHostLimit");
                return false;
            }
            return n != 0;
        }
    }
}

