/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.vhost.IVHost;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoSession;

public class VHostSessionHolder {
    public BaseIoSession session = null;
    public Client client = null;
    public int protocol = 0;
    public IVHost vhost = null;
    public IIdleNotify idleNotify = null;

    public void onIdle(long l) {
        switch (this.protocol) {
            case 1: {
                try {
                    long l2 = this.client.getIdleFrequency();
                    long l3 = Math.max(this.session.getLastIoTime(), this.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                    if (l2 <= 0L || l3 == 0L || l - l3 < l2) break;
                    this.client.doIdle();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostSessionHolder.class).error("VHostIdleWorker: run: idle: " + exception.toString());
                }
                break;
            }
            case 3: 
            case 32: 
            case 33: {
                try {
                    int n = this.vhost.getKeepAliveTimeout();
                    long l4 = n;
                    long l5 = Math.max(this.session.getLastIoTime(), this.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                    if (l4 <= 0L || l5 == 0L || l - l5 < l4) break;
                    this.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.session.getFilterChain().fireSessionIdle((IoSession)this.session, IdleStatus.BOTH_IDLE);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostSessionHolder.class).error("VHostIdleWorker: run: idle: " + exception.toString());
                }
                break;
            }
            case 34: {
                try {
                    if (this.vhost == null) break;
                    long l6 = this.vhost.getRTPIdleFrequency();
                    long l7 = Math.max(this.session.getLastIoTime(), this.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                    if (l6 <= 0L || l7 == 0L || l - l7 < l6) break;
                    this.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.session.getFilterChain().fireSessionIdle((IoSession)this.session, IdleStatus.BOTH_IDLE);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostSessionHolder.class).error("VHostIdleWorker: run: idle: " + exception.toString());
                }
                break;
            }
            case 16: {
                try {
                    IMediaCaster iMediaCaster = (IMediaCaster)this.session.getAttribute("mediaCaster");
                    long l8 = iMediaCaster.getIdleTimeout();
                    long l9 = Math.max(this.session.getLastIoTime(), this.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                    if (l8 <= 0L || l9 == 0L || l - l9 < l8) break;
                    this.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.session.getFilterChain().fireSessionIdle((IoSession)this.session, IdleStatus.BOTH_IDLE);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostSessionHolder.class).error("VHostIdleWorker: run: idle: " + exception.toString());
                }
                break;
            }
            case 17: {
                try {
                    long l10;
                    long l11;
                    INetConnection iNetConnection = (INetConnection)this.session.getAttribute("netConnection");
                    if (iNetConnection.getIdleHandler() != null && l - (l11 = this.session.getLastIdleTime(IdleStatus.BOTH_IDLE)) >= (l10 = (long)iNetConnection.getIdleFrequency())) {
                        iNetConnection.doIdle();
                    }
                    iNetConnection.checkPingTimeout();
                    iNetConnection.checkLastIdlePing();
                    break;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostSessionHolder.class).error("VHostIdleWorker: run: idle: " + exception.toString());
                }
            }
        }
    }
}

