/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.vhost.VHostSessionHolder;
import com.wowza.wms.vhost.VHostSessionIdleBase;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class VHostSessionIdleRTSP
extends VHostSessionIdleBase
implements IIdleNotify {
    public VHostSessionIdleRTSP(VHostSessionHolder vHostSessionHolder) {
        super(vHostSessionHolder);
    }

    public void onIdle(long l) {
        try {
            if (this.sessionHolder.vhost != null) {
                long l2 = this.sessionHolder.vhost.getRTPIdleFrequency();
                long l3 = Math.max(this.sessionHolder.session.getLastIoTime(), this.sessionHolder.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                if (l2 > 0L && l3 != 0L && l - l3 >= l2) {
                    this.sessionHolder.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.sessionHolder.session.getFilterChain().fireSessionIdle((IoSession)this.sessionHolder.session, IdleStatus.BOTH_IDLE);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostSessionIdleRTSP.class).error("VHostSessionIdleRTSP.onIdle: " + exception.toString());
        }
    }
}

