/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.IWorkerThreadClear;

public class VHostWorkerThread
extends Thread
implements IWorkerThreadClear {
    IVHost vhost = null;
    boolean nullVHost = false;
    String logContext = null;
    Client client = null;

    public VHostWorkerThread(Runnable runnable, IVHost iVHost) {
        super(runnable);
        this.vhost = iVHost;
        this.nullVHost = this.vhost == null;
    }

    public VHostWorkerThread(IVHost iVHost) {
        this.vhost = iVHost;
        this.nullVHost = this.vhost == null;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public void reset() {
        this.setClient(null);
        if (this.nullVHost) {
            this.vhost = null;
        }
        WMSLoggerFactory.resetMDC();
    }

    public void clear() {
        this.logContext = null;
        this.client = null;
        if (this.nullVHost) {
            this.vhost = null;
        }
        WMSLoggerFactory.resetMDC();
    }

    public void clearContext() {
        this.logContext = null;
    }

    public void updateLoggingValues(String string) {
        if (string.equals("server")) {
            Server.getInstance().updateLoggingDuration();
        }
        if (this.client != null) {
            if (string.equals("session") || string.equals("stream")) {
                this.client.updateLoggingValues();
            } else {
                this.client.clearLoggingValues();
            }
            if (string.equals("server")) {
                Server.getInstance().updateLoggingDuration();
            } else if (string.equals("vhost")) {
                this.client.getVHost().updateLoggingDuration();
            } else if (string.equals("application")) {
                if (this.client.getAppInstance() != null) {
                    ((ApplicationInstance)this.client.getAppInstance()).updateLoggingDuration();
                }
            } else if (string.equals("session") || string.equals("stream")) {
                this.client.updateLoggingDuration();
            }
        } else {
            Server.getInstance().updateLoggingDuration();
        }
    }

    public void setClient(Client client) {
        this.client = client;
        if (this.client != null && this.nullVHost) {
            this.vhost = client.getVHost();
        }
        this.clearContext();
    }

    public String getLogContext() {
        if (this.logContext == null) {
            this.logContext = this.vhost == null || this.client == null ? "_Server_" : (this.client.getAppInstance() != null ? this.vhost.getName() + "." + this.client.getApplication().getName() + "." + this.client.getAppInstance().getName() : this.vhost.getName());
        }
        return this.logContext;
    }
}

