/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.model.Attribute;

public abstract class CompletionPaintComponent
extends JPanel {
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private CompletionResultItem completionItem;
    private static final String THROWS = " throws ";
    private static String str;

    public CompletionPaintComponent(CompletionResultItem completionResultItem) {
        this.completionItem = completionResultItem;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
        this.drawIcon(graphics, this.completionItem.getIcon());
        this.drawString(graphics, this.completionItem.getDisplayText(), this.completionItem.getPaintColor(), this.getDrawFont());
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font) {
        if (graphics != null) {
            graphics.drawString(string, this.drawX, this.drawY);
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string, Font font) {
        if (font != null) {
            return this.getFontMetrics(this.getDrawFont()).stringWidth(string) * 2;
        }
        return string == null ? this.fontMetrics.stringWidth("") : this.fontMetrics.stringWidth(string) * 2;
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    CompletionResultItem getCompletionItem() {
        return this.completionItem;
    }

    public static class AttributePaintComponent
    extends CompletionPaintComponent {
        public AttributePaintComponent(CompletionResultItem completionResultItem) {
            super(completionResultItem);
        }

        protected Font getDrawFont() {
            AbstractAttribute abstractAttribute = (AbstractAttribute)this.getCompletionItem().getAXIComponent();
            if (abstractAttribute instanceof Attribute && ((Attribute)abstractAttribute).getUse() == Attribute.Use.REQUIRED) {
                return super.getDrawFont().deriveFont(1);
            }
            return super.getFont();
        }
    }

    public static class ElementPaintComponent
    extends CompletionPaintComponent {
        public ElementPaintComponent(CompletionResultItem completionResultItem) {
            super(completionResultItem);
        }
    }

    public static class ValuePaintComponent
    extends CompletionPaintComponent {
        public ValuePaintComponent(CompletionResultItem completionResultItem) {
            super(completionResultItem);
        }
    }
}

