/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassLoaderSupport;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    @Deprecated
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String SOURCE = "classpath/source";
    public static final String BOOT = "classpath/boot";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    public static final String PROP_INCLUDES = "includes";
    private static final Logger LOG;
    private static final Lookup.Result<? extends ClassPathProvider> implementations;
    private final ClassPathImplementation impl;
    private FileObject[] rootsCache;
    private Map<FileObject, FilteringPathResourceImplementation> root2Filter = new WeakHashMap<FileObject, FilteringPathResourceImplementation>();
    private PropertyChangeListener pListener;
    private PropertyChangeListener weakPListener;
    private RootsListener rootsListener;
    private List<Entry> entriesCache;
    private long invalidEntries;
    private long invalidRoots;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private static final Reference<ClassLoader> EMPTY_REF;
    private Reference<ClassLoader> refClassLoader = EMPTY_REF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getRoots() {
        FileObject[] fileObjectArray;
        long l;
        Object object = this;
        synchronized (object) {
            if (this.rootsCache != null) {
                return this.rootsCache;
            }
            l = this.invalidRoots;
        }
        object = this.entries();
        ClassPath classPath = this;
        synchronized (classPath) {
            if (this.invalidRoots == l) {
                if (this.rootsCache == null || this.rootsListener == null) {
                    this.attachRootsListener();
                    this.rootsCache = this.createRoots((List<Entry>)object);
                }
                fileObjectArray = this.rootsCache;
            } else {
                fileObjectArray = this.createRoots((List<Entry>)object);
            }
        }
        assert (fileObjectArray != null);
        return fileObjectArray;
    }

    private FileObject[] createRoots(List<Entry> list) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Entry entry : list) {
            FileObject fileObject;
            RootsListener rootsListener = this.getRootsListener();
            if (rootsListener != null) {
                rootsListener.addRoot(entry.getURL());
            }
            if ((fileObject = entry.getRoot()) == null) continue;
            arrayList.add(fileObject);
            this.root2Filter.put(fileObject, entry.filter);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> entries() {
        Object object;
        long l;
        Object object2 = this;
        synchronized (object2) {
            if (this.entriesCache != null) {
                return this.entriesCache;
            }
            l = this.invalidEntries;
        }
        object2 = this.impl.getResources();
        if (object2 == null) {
            throw new NullPointerException("ClassPathImplementation.getResources() returned null. ClassPathImplementation.class: " + this.impl.getClass().toString() + " ClassPathImplementation: " + this.impl.toString());
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        List<Entry> list = object2.iterator();
        while (list.hasNext()) {
            object = (PathResourceImplementation)list.next();
            arrayList.add(new Object[]{object, object.getRoots()});
        }
        object = this;
        synchronized (object) {
            if (this.invalidEntries == l) {
                if (this.entriesCache == null) {
                    this.entriesCache = this.createEntries(arrayList);
                }
                list = this.entriesCache;
            } else {
                list = this.createEntries(arrayList);
            }
        }
        assert (list != null);
        return list;
    }

    private List<Entry> createEntries(List<Object[]> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Object[] objectArray : list) {
            PathResourceImplementation pathResourceImplementation = (PathResourceImplementation)objectArray[0];
            URL[] uRLArray = (URL[])objectArray[1];
            pathResourceImplementation.removePropertyChangeListener(this.weakPListener);
            this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)this.pListener, (Object)pathResourceImplementation);
            pathResourceImplementation.addPropertyChangeListener(this.weakPListener);
            for (URL uRL : uRLArray) {
                arrayList.add(new Entry(uRL, pathResourceImplementation instanceof FilteringPathResourceImplementation ? (FilteringPathResourceImplementation)pathResourceImplementation : null));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private ClassPath(ClassPathImplementation classPathImplementation) {
        if (classPathImplementation == null) {
            throw new IllegalArgumentException();
        }
        this.impl = classPathImplementation;
        this.pListener = new SPIListener();
        this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)this.pListener, (Object)this.impl);
        this.impl.addPropertyChangeListener(this.weakPListener);
    }

    public final FileObject findResource(String string) {
        return this.findResourceImpl(this.getRoots(), new int[]{0}, ClassPath.parseResourceName(string));
    }

    public final List<FileObject> findAllResources(String string) {
        FileObject[] fileObjectArray = this.getRoots();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        int[] nArray = new int[]{0};
        String[] stringArray = ClassPath.parseResourceName(string);
        while (nArray[0] < fileObjectArray.length) {
            FileObject fileObject = this.findResourceImpl(fileObjectArray, nArray, stringArray);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public final String getResourceName(FileObject fileObject) {
        return this.getResourceName(fileObject, '/', true);
    }

    public final String getResourceName(FileObject fileObject, char c, boolean bl) {
        int n;
        FileObject fileObject2 = this.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        assert (string != null);
        if (!bl && (n = string.lastIndexOf(46)) > 0 && n > string.lastIndexOf(47) + 1) {
            string = string.substring(0, n);
        }
        if (c != '/') {
            string = string.replace('/', c);
        }
        return string;
    }

    public final FileObject findOwnerRoot(FileObject fileObject) {
        FileObject[] fileObjectArray = this.getRoots();
        HashSet<FileObject> hashSet = new HashSet<FileObject>(Arrays.asList(fileObjectArray));
        for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (!hashSet.contains(fileObject2)) continue;
            return fileObject2;
        }
        return null;
    }

    public final boolean contains(FileObject fileObject) {
        FileObject fileObject2 = this.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return false;
        }
        FilteringPathResourceImplementation filteringPathResourceImplementation = this.root2Filter.get(fileObject2);
        if (filteringPathResourceImplementation == null) {
            return true;
        }
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        assert (string != null) : "could not find " + fileObject + " in " + fileObject2;
        if (fileObject.isFolder()) {
            string = string + "/";
        }
        try {
            return filteringPathResourceImplementation.includes(fileObject2.getURL(), string);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
    }

    public final boolean isResourceVisible(FileObject fileObject) {
        String string = this.getResourceName(fileObject);
        if (string == null) {
            return false;
        }
        return this.findResource(string) == fileObject;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.attachRootsListener();
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static ClassPath getClassPath(FileObject fileObject, String string) {
        if (fileObject == null) {
            Thread.dumpStack();
            return null;
        }
        for (ClassPathProvider classPathProvider : implementations.allInstances()) {
            ClassPath classPath = classPathProvider.findClassPath(fileObject, string);
            if (classPath == null) continue;
            LOG.log(Level.FINE, "getClassPath({0}, {1}) -> {2} from {3}", new Object[]{fileObject, string, classPath, classPathProvider});
            return classPath;
        }
        LOG.log(Level.FINE, "getClassPath({0}, {1}) -> nil", new Object[]{fileObject, string});
        return null;
    }

    final void firePropertyChange(String string, Object object, Object object2, Object object3) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        propertyChangeEvent.setPropagationId(object3);
        this.propSupport.firePropertyChange(propertyChangeEvent);
    }

    public String toString(PathConversionMode pathConversionMode) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (Entry entry : this.entries()) {
            URL uRL = entry.getURL();
            File file = FileUtil.archiveOrDirForURL((URL)uRL);
            if (file != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                stringBuilder.append(file.getAbsolutePath());
                continue;
            }
            switch (pathConversionMode) {
                case SKIP: {
                    continue block6;
                }
                case PRINT: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(File.pathSeparatorChar);
                    }
                    stringBuilder.append(uRL);
                    continue block6;
                }
                case WARN: {
                    LOG.warning("Encountered untranslatable classpath entry: " + uRL);
                    continue block6;
                }
                case FAIL: {
                    throw new IllegalArgumentException("Encountered untranslatable classpath entry: " + uRL);
                }
            }
            assert (false) : pathConversionMode;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(PathConversionMode.PRINT);
    }

    private void attachRootsListener() {
        if (this.rootsListener == null) {
            assert (this.rootsCache == null);
            this.rootsListener = new RootsListener(this);
        }
    }

    private static String[] parseResourceName(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(string.length() / 4);
        char[] cArray = string.toCharArray();
        int n2 = -1;
        int n3 = 0;
        block4: for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            switch (c) {
                case '.': {
                    n2 = n;
                    continue block4;
                }
                case '/': {
                    if (n2 != -1) {
                        arrayList.add(string.substring(n3, n2));
                        arrayList.add(string.substring(n2 + 1, n));
                    } else {
                        arrayList.add(string.substring(n3, n));
                        arrayList.add(null);
                    }
                    n3 = n + 1;
                    n2 = -1;
                }
            }
        }
        if (n > n3) {
            if (n2 != -1) {
                arrayList.add(string.substring(n3, n2));
                arrayList.add(string.substring(n2 + 1, n));
            } else {
                arrayList.add(string.substring(n3, n));
                arrayList.add(null);
            }
        }
        if (arrayList.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static FileObject findPath(FileObject fileObject, String[] stringArray) {
        for (int i = 0; i < stringArray.length && fileObject != null; i += 2) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[i], stringArray[i + 1]);
            fileObject = fileObject2;
        }
        return fileObject;
    }

    private FileObject findResourceImpl(FileObject[] fileObjectArray, int[] nArray, String[] stringArray) {
        int n;
        FileObject fileObject = null;
        for (n = nArray[0]; n < fileObjectArray.length && fileObject == null; ++n) {
            fileObject = ClassPath.findPath(fileObjectArray[n], stringArray);
            FilteringPathResourceImplementation filteringPathResourceImplementation = this.root2Filter.get(fileObjectArray[n]);
            if (filteringPathResourceImplementation == null) continue;
            try {
                if (fileObject == null) continue;
                String string = FileUtil.getRelativePath((FileObject)fileObjectArray[n], (FileObject)fileObject);
                assert (string != null);
                if (fileObject.isFolder()) {
                    string = string + "/";
                }
                if (filteringPathResourceImplementation.includes(fileObjectArray[n].getURL(), string)) continue;
                fileObject = null;
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new AssertionError((Object)fileStateInvalidException);
            }
        }
        nArray[0] = n;
        return fileObject;
    }

    synchronized void resetClassLoader(ClassLoader classLoader) {
        if (this.refClassLoader.get() == classLoader) {
            this.refClassLoader = EMPTY_REF;
        }
    }

    public final synchronized ClassLoader getClassLoader(boolean bl) {
        ClassLoader classLoader = this.refClassLoader.get();
        if (!bl || classLoader == null) {
            classLoader = ClassLoaderSupport.create(this);
            this.refClassLoader = new SoftReference<ClassLoader>(classLoader);
        }
        return classLoader;
    }

    private synchronized RootsListener getRootsListener() {
        return this.rootsListener;
    }

    static /* synthetic */ FileObject[] access$702(ClassPath classPath, FileObject[] fileObjectArray) {
        classPath.rootsCache = fileObjectArray;
        return fileObjectArray;
    }

    static {
        ClassPathAccessor.DEFAULT = new ClassPathAccessor(){

            public ClassPath createClassPath(ClassPathImplementation classPathImplementation) {
                return new ClassPath(classPathImplementation);
            }

            public ClassPathImplementation getClassPathImpl(ClassPath classPath) {
                return classPath == null ? null : classPath.impl;
            }
        };
        LOG = Logger.getLogger(ClassPath.class.getName());
        implementations = Lookup.getDefault().lookupResult(ClassPathProvider.class);
        EMPTY_REF = new SoftReference<Object>(null);
    }

    public final class Entry {
        private final URL url;
        private FileObject root;
        private IOException lastError;
        private FilteringPathResourceImplementation filter;

        public ClassPath getDefiningClassPath() {
            return ClassPath.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            Entry entry = this;
            synchronized (entry) {
                if (this.root != null && this.root.isValid()) {
                    return this.root;
                }
            }
            entry = URLMapper.findFileObject((URL)this.url);
            Entry entry2 = this;
            synchronized (entry2) {
                if (this.root == null || !this.root.isValid()) {
                    if (entry == null) {
                        this.lastError = new IOException(MessageFormat.format("The package root {0} does not exist or can not be read.", this.url));
                        return null;
                    }
                    if (entry.isData()) {
                        throw new IllegalArgumentException("Invalid ClassPath root: " + this.url + ". The root must be a folder.");
                    }
                    this.root = entry;
                }
                return this.root;
            }
        }

        public boolean isValid() {
            FileObject fileObject = this.getRoot();
            return fileObject != null && fileObject.isValid();
        }

        public IOException getError() {
            IOException iOException = this.lastError;
            this.lastError = null;
            return iOException;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean includes(String string) {
            return this.filter == null || this.filter.includes(this.url, string);
        }

        public boolean includes(URL uRL) {
            URI uRI;
            if (!uRL.toExternalForm().startsWith(this.url.toExternalForm())) {
                throw new IllegalArgumentException(uRL + " not in " + this.url);
            }
            try {
                uRI = this.url.toURI().relativize(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AssertionError((Object)uRISyntaxException);
            }
            assert (!uRI.isAbsolute()) : "could not locate " + uRL + " in " + this.url;
            return this.filter == null || this.filter.includes(this.url, uRI.toString());
        }

        public boolean includes(FileObject fileObject) {
            FileObject fileObject2 = this.getRoot();
            if (fileObject2 == null) {
                throw new IllegalArgumentException("no root in " + this.url);
            }
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (string == null) {
                if (!fileObject.isValid()) {
                    return false;
                }
                throw new IllegalArgumentException(fileObject + " (valid: " + fileObject.isValid() + ") not in " + fileObject2 + " (valid: " + fileObject2.isValid() + ")");
            }
            if (fileObject.isFolder()) {
                string = string + "/";
            }
            return this.filter == null || this.filter.includes(this.url, string);
        }

        Entry(URL uRL, FilteringPathResourceImplementation filteringPathResourceImplementation) {
            if (uRL == null) {
                throw new IllegalArgumentException();
            }
            if ("jar".equals(uRL.getProtocol()) && FileUtil.getArchiveFile((URL)uRL) == null) {
                throw new IllegalArgumentException("Invalid URL: " + uRL);
            }
            this.url = uRL;
            this.filter = filteringPathResourceImplementation;
        }

        public String toString() {
            return "Entry[" + this.url + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return Utilities.compareObjects((Object)((Entry)object).url, (Object)this.url);
            }
            return false;
        }

        public int hashCode() {
            return this.url == null ? 0 : this.url.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathConversionMode {
        SKIP,
        WARN,
        FAIL,
        PRINT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootsListener
    extends WeakReference<ClassPath>
    implements FileChangeListener,
    Runnable {
        private boolean initialized;
        private Set<String> roots = new HashSet<String>();

        private RootsListener(ClassPath classPath) {
            super(classPath, Utilities.activeReferenceQueue());
        }

        public void addRoot(URL uRL) {
            String string;
            if (!this.isInitialized()) {
                FileUtil.addFileChangeListener((FileChangeListener)this);
                this.setInitialized(true);
            }
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            if ((string = uRL.getPath()).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.roots.add(string);
        }

        public void removeRoot(URL uRL) {
            String string;
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            if ((string = uRL.getPath()).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.roots.remove(string);
        }

        public void removeAllRoots() {
            this.roots.clear();
            FileUtil.removeFileChangeListener((FileChangeListener)this);
            this.initialized = false;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            ClassPath classPath;
            if (!this.isInitialized()) {
                return;
            }
            String string = RootsListener.getPath(fileEvent.getFile());
            if (this.roots.contains(string) && (classPath = (ClassPath)this.get()) != null) {
                ClassPath classPath2 = classPath;
                synchronized (classPath2) {
                    ClassPath.access$702(classPath, null);
                    classPath.invalidRoots++;
                    this.removeAllRoots();
                }
                classPath.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.processEvent(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.processEvent((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        @Override
        public void run() {
            if (this.isInitialized()) {
                FileUtil.removeFileChangeListener((FileChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvent(FileEvent fileEvent) {
            if (!this.isInitialized()) {
                return;
            }
            String string = RootsListener.getPath(fileEvent.getFile());
            if (string == null) {
                return;
            }
            ClassPath classPath = (ClassPath)this.get();
            if (classPath == null) {
                return;
            }
            boolean bl = false;
            ClassPath classPath2 = classPath;
            synchronized (classPath2) {
                for (String string2 : this.roots) {
                    if (!string2.startsWith(string)) continue;
                    ClassPath.access$702(classPath, null);
                    classPath.invalidRoots++;
                    this.removeAllRoots();
                    bl = true;
                    break;
                }
            }
            if (bl) {
                classPath.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            }
        }

        private static String getPath(FileObject fileObject) {
            if (fileObject == null) {
                return null;
            }
            try {
                URL uRL = fileObject.getURL();
                String string = uRL.getPath();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                return string;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                return null;
            }
        }

        private synchronized boolean isInitialized() {
            return this.initialized;
        }

        private synchronized void setInitialized(boolean bl) {
            this.initialized = bl;
        }
    }

    private class SPIListener
    implements PropertyChangeListener {
        private Object propIncludesPropagationId;

        private SPIListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resources".equals(string) || ClassPath.PROP_ROOTS.equals(string)) {
                ClassPath classPath = ClassPath.this;
                synchronized (classPath) {
                    if (ClassPath.this.rootsListener != null) {
                        ClassPath.this.rootsListener.removeAllRoots();
                    }
                    ClassPath.this.entriesCache = null;
                    ClassPath.access$702(ClassPath.this, null);
                    ClassPath.this.invalidEntries++;
                    ClassPath.this.invalidRoots++;
                }
                ClassPath.this.firePropertyChange(ClassPath.PROP_ENTRIES, null, null, null);
                ClassPath.this.firePropertyChange(ClassPath.PROP_ROOTS, null, null, null);
            } else if (ClassPath.PROP_INCLUDES.equals(string)) {
                boolean bl;
                SPIListener sPIListener = this;
                synchronized (sPIListener) {
                    Object object = propertyChangeEvent.getPropagationId();
                    bl = this.propIncludesPropagationId == null || !this.propIncludesPropagationId.equals(object);
                    this.propIncludesPropagationId = object;
                }
                if (bl) {
                    ClassPath.this.firePropertyChange(ClassPath.PROP_INCLUDES, null, null, propertyChangeEvent.getPropagationId());
                }
            }
            if ("resources".equals(string)) {
                List<? extends PathResourceImplementation> list = ClassPath.this.impl.getResources();
                if (list == null) {
                    LOG.warning("ClassPathImplementation.getResources cannot return null; impl class: " + ClassPath.this.impl.getClass().getName());
                    return;
                }
                for (PathResourceImplementation pathResourceImplementation : list) {
                    pathResourceImplementation.removePropertyChangeListener(ClassPath.this.weakPListener);
                    pathResourceImplementation.addPropertyChangeListener(ClassPath.this.weakPListener = WeakListeners.propertyChange((PropertyChangeListener)ClassPath.this.pListener, (Object)pathResourceImplementation));
                }
            }
        }
    }
}

