/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.classpath.support;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.modules.java.classpath.ProxyClassPathImplementation;
import org.netbeans.modules.java.classpath.SimpleClassPathImplementation;
import org.netbeans.modules.java.classpath.SimplePathResourceImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathSupport {
    private ClassPathSupport() {
    }

    public static PathResourceImplementation createResource(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("Cannot pass null URL to ClassPathSupport.createResource");
        }
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && FileUtil.isArchiveFile((URL)uRL)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + uRL);
        }
        if (!uRL.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("URL must be a folder URL (append '/' if necessary): " + uRL);
        }
        return new SimplePathResourceImplementation(uRL);
    }

    public static ClassPathImplementation createClassPathImplementation(List<? extends PathResourceImplementation> list) {
        if (list == null) {
            throw new NullPointerException("Cannot pass null entries");
        }
        return new SimpleClassPathImplementation(list);
    }

    public static ClassPath createClassPath(List<? extends PathResourceImplementation> list) {
        if (list == null) {
            throw new NullPointerException("Cannot pass null entries");
        }
        return ClassPathFactory.createClassPath(ClassPathSupport.createClassPathImplementation(list));
    }

    public static ClassPath createClassPath(FileObject ... fileObjectArray) {
        assert (fileObjectArray != null);
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        for (FileObject fileObject : fileObjectArray) {
            if (fileObject == null) continue;
            try {
                URL uRL = fileObject.getURL();
                arrayList.add(ClassPathSupport.createResource(uRL));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    public static ClassPath createClassPath(URL ... uRLArray) {
        assert (uRLArray != null);
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        for (URL uRL : uRLArray) {
            if (uRL == null) continue;
            arrayList.add(ClassPathSupport.createResource(uRL));
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    public static ClassPath createClassPath(String string) throws IllegalArgumentException {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        for (String string2 : string.split(File.pathSeparator)) {
            File file = FileUtil.normalizeFile((File)new File(string2));
            URL uRL = FileUtil.urlForArchiveOrDir((File)file);
            if (uRL == null) {
                throw new IllegalArgumentException("Path entry looks to be invalid: " + string2);
            }
            arrayList.add(ClassPathSupport.createResource(uRL));
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    public static ClassPathImplementation createProxyClassPathImplementation(ClassPathImplementation ... classPathImplementationArray) {
        return new ProxyClassPathImplementation(classPathImplementationArray);
    }

    public static ClassPath createProxyClassPath(ClassPath ... classPathArray) {
        assert (classPathArray != null);
        ClassPathImplementation[] classPathImplementationArray = new ClassPathImplementation[classPathArray.length];
        for (int i = 0; i < classPathArray.length; ++i) {
            classPathImplementationArray[i] = ClassPathAccessor.DEFAULT.getClassPathImpl(classPathArray[i]);
        }
        return ClassPathFactory.createClassPath(ClassPathSupport.createProxyClassPathImplementation(classPathImplementationArray));
    }
}

