/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.api;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.kenai.HgKenaiSupport;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.wizards.CloneWizardAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.NbPreferences;

public class Mercurial {
    private static final String WORKINGDIR_KEY_PREFIX = "working.dir.";

    @Deprecated
    public static void cloneRepository(String string, File file, String string2, String string3, String string4) throws MalformedURLException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Mercurial.cloneRepository(string, file, string2, string3, string4, null, null, true);
    }

    public static void cloneRepository(String string, File file, String string2, String string3, String string4, boolean bl) throws MalformedURLException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Mercurial.cloneRepository(string, file, string2, string3, string4, null, null, bl);
    }

    @Deprecated
    public static void cloneRepository(String string, File file, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException {
        Mercurial.cloneRepository(string, file, string2, string3, string4, string5, string6, true);
    }

    public static void cloneRepository(String string, File file, String string2, String string3, String string4, String string5, String string6, boolean bl) throws MalformedURLException {
        HgURL hgURL;
        HgURL hgURL2;
        HgURL hgURL3;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("repository URL is null");
        }
        try {
            hgURL3 = new HgURL(string, string5, string6);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException(uRISyntaxException.getMessage());
        }
        string3 = Mercurial.getNonEmptyString(string3);
        string4 = Mercurial.getNonEmptyString(string4);
        try {
            hgURL2 = string3 != null ? new HgURL(string3) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException("Invalid pull URL: " + uRISyntaxException.getMessage());
        }
        try {
            hgURL = string4 != null ? new HgURL(string4) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException("Invalid push URL: " + uRISyntaxException.getMessage());
        }
        File file2 = new File(file, string2);
        CloneAction.performClone(hgURL3, file2, true, null, hgURL2, hgURL, bl).waitFinished();
        try {
            Mercurial.storeWorkingDir(new URL(string), file.toURI().toURL());
        }
        catch (Exception exception) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.FINE, "Cannot store mercurial workdir preferences", exception);
        }
        HgKenaiSupport.getInstance().setFirmAssociations(new File[]{file2}, string);
    }

    private static String getNonEmptyString(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() != 0 ? string : null;
    }

    private static void storeWorkingDir(URL uRL, URL uRL2) {
        Preferences preferences = NbPreferences.forModule(Mercurial.class);
        preferences.put(WORKINGDIR_KEY_PREFIX + uRL, uRL2.toString());
    }

    public static boolean showFileHistory(final File file, final int n) {
        assert (!EventQueue.isDispatchThread());
        if (!file.exists()) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Trying to show history for non-existent file {0}", file.getAbsolutePath());
            return false;
        }
        if (!file.isFile()) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Trying to show history for a folder {0}", file.getAbsolutePath());
            return false;
        }
        if (!org.netbeans.modules.mercurial.Mercurial.getInstance().isManaged(file)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.INFO, "Trying to show history for an unmanaged file {0}", file.getAbsolutePath());
            return false;
        }
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return false;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogAction.openSearch(file, n);
            }
        });
        return true;
    }

    public static void addRecentUrl(String string) throws MalformedURLException {
        RepositoryConnection repositoryConnection;
        try {
            repositoryConnection = new RepositoryConnection(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.INFO, "Could not add URL to the list of recent URLs:", uRISyntaxException);
            return;
        }
        HgModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
    }

    public static boolean isRepository(String string) {
        if (!Mercurial.isClientAvailable(false)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.INFO, "Mercurial client is unavailable");
            return false;
        }
        boolean bl = false;
        HgURL hgURL = null;
        try {
            hgURL = new HgURL(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.FINE, "Invalid mercurial url " + string, uRISyntaxException);
        }
        if (hgURL != null) {
            bl = HgCommand.checkRemoteRepository(hgURL.toHgCommandUrlString());
        }
        return bl;
    }

    public static void openCloneWizard(String string) throws MalformedURLException {
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return;
        }
        Mercurial.addRecentUrl(string);
        CloneWizardAction cloneWizardAction = CloneWizardAction.getInstance();
        cloneWizardAction.performAction();
    }

    public static boolean isClientAvailable() {
        return Mercurial.isClientAvailable(false);
    }

    private static boolean isClientAvailable(boolean bl) {
        return org.netbeans.modules.mercurial.Mercurial.getInstance().isAvailable(true, bl);
    }
}

