/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitTableModel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTable
implements AncestorListener,
TableModelListener {
    public static String[] COMMIT_COLUMNS = new String[]{"name", "status", "action", "path"};
    public static String[] IMPORT_COLUMNS = new String[]{"name", "action", "path"};
    private CommitTableModel tableModel;
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;
    private String[] sortByColumns;

    public CommitTable(JLabel jLabel, String[] stringArray, String[] stringArray2) {
        this.init(jLabel, stringArray, null);
        this.sortByColumns = stringArray2;
        this.setSortingStatus();
    }

    public CommitTable(JLabel jLabel, String[] stringArray, TableSorter tableSorter) {
        this.init(jLabel, stringArray, tableSorter);
    }

    private void init(JLabel jLabel, String[] stringArray, TableSorter tableSorter) {
        this.tableModel = new CommitTableModel(stringArray);
        this.tableModel.addTableModelListener(this);
        if (tableSorter == null) {
            tableSorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = tableSorter;
        this.table = new SortedTable(this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultEditor(CommitOptions.class, new CommitOptionsCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        jLabel.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitTable.class, (String)"ACSD_CommitTable"));
        this.setColumns(stringArray);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        block14: {
            TableColumnModel tableColumnModel;
            int n;
            block15: {
                block13: {
                    n = this.table.getWidth();
                    tableColumnModel = this.table.getColumnModel();
                    if (this.columns == null || tableColumnModel == null) {
                        return;
                    }
                    if (tableColumnModel.getColumnCount() != this.columns.length) {
                        return;
                    }
                    if (this.columns.length != 3) break block13;
                    for (int i = 0; i < this.columns.length; ++i) {
                        String string = this.columns[i];
                        this.sorter.setColumnComparator(i, null);
                        if (string.equals("name")) {
                            this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                            tableColumnModel.getColumn(i).setPreferredWidth(n * 30 / 100);
                            continue;
                        }
                        if (string.equals("action")) {
                            tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                            continue;
                        }
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 40 / 100);
                    }
                    break block14;
                }
                if (this.columns.length != 4) break block15;
                for (int i = 0; i < this.columns.length; ++i) {
                    String string = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    if (string.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 25 / 100);
                        continue;
                    }
                    if (string.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                        continue;
                    }
                    if (string.equals("action")) {
                        tableColumnModel.getColumn(i).setPreferredWidth(n * 20 / 100);
                        continue;
                    }
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 40 / 100);
                }
                break block14;
            }
            if (this.columns.length != 5) break block14;
            for (int i = 0; i < this.columns.length; ++i) {
                String string = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                if (string.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 25 / 100);
                    continue;
                }
                if (string.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                    continue;
                }
                if (string.equals("action")) {
                    tableColumnModel.getColumn(i).setPreferredWidth(n * 15 / 100);
                    continue;
                }
                tableColumnModel.getColumn(i).setPreferredWidth(n * 30 / 100);
            }
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String string = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String string2 = this.columns[j];
                if (!string2.equals(string)) continue;
                this.sorter.setSortingStatus(j, string2.equals(string) ? 1 : 0);
                continue block0;
            }
        }
    }

    public TableSorter getSorter() {
        return this.sorter;
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    void setColumns(String[] stringArray) {
        if (Arrays.equals(this.columns, stringArray)) {
            return;
        }
        this.columns = stringArray;
        this.tableModel.setColumns(stringArray);
        this.setDefaultColumnSizes();
    }

    public void setNodes(HgFileNode[] hgFileNodeArray) {
        this.tableModel.setNodes(hgFileNodeArray);
    }

    public Map<HgFileNode, CommitOptions> getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void dataChanged() {
        int n = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (n != -1) {
            this.table.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.table.repaint();
    }

    public void setRootFile(String string, String string2) {
        this.tableModel.setRootFile(string, string2);
    }

    private class CommitOptionsCellEditor
    extends DefaultCellEditor {
        private final Object[] dirAddOptions;
        private final Object[] addOptions;
        private final Object[] commitOptions;
        private final Object[] removeOptions;

        public CommitOptionsCellEditor() {
            super(new JComboBox());
            this.dirAddOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.addOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.commitOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.removeOptions = new Object[]{CommitOptions.COMMIT_REMOVE, CommitOptions.EXCLUDE};
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            FileInformation fileInformation = CommitTable.this.tableModel.getNode(CommitTable.this.sorter.modelIndex(n)).getInformation();
            int n3 = fileInformation.getStatus();
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            if (n3 == 2048 || n3 == 256) {
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.removeOptions));
            } else if ((n3 & 0xFF8) == 0) {
                if (fileInformation.isDirectory()) {
                    jComboBox.setModel(new DefaultComboBoxModel<Object>(this.dirAddOptions));
                } else {
                    jComboBox.setModel(new DefaultComboBoxModel<Object>(this.addOptions));
                }
            } else {
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.commitOptions));
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (CommitTable.this.columns[n3] == "name") {
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                CommitTableModel commitTableModel = (CommitTableModel)tableSorter.getTableModel();
                HgFileNode hgFileNode = commitTableModel.getNode(tableSorter.modelIndex(n));
                CommitOptions commitOptions = commitTableModel.getOptions(tableSorter.modelIndex(n));
                if (!bl) {
                    object = "<html>" + Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(hgFileNode.getFile().getName(), hgFileNode.getInformation(), null);
                }
                if (commitOptions == CommitOptions.EXCLUDE) {
                    object = "<html><s>" + object + "</s></html>";
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (CommitTable.this.columns[n3] == "path") {
                return this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return CommitTable.this.tableModel.getNode(n).getName().compareToIgnoreCase(CommitTable.this.tableModel.getNode(n2).getName());
        }
    }

    private class StatusComparator
    extends HgUtils.ByImportanceComparator {
        private StatusComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return super.compare(CommitTable.this.tableModel.getNode(n).getInformation(), CommitTable.this.tableModel.getNode(n2).getInformation());
        }
    }
}

