/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.create;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.create.CreatePanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateAction
extends ContextAction {
    private final VCSContext context;
    Map<File, FileInformation> repositoryFiles = new HashMap<File, FileInformation>();

    public CreateAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public boolean isEnabled() {
        File file = HgUtils.getRootFile(this.context);
        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        return file == null;
    }

    private File getCommonAncestor(File file, File file2) {
        if (file.equals(file2)) {
            return file;
        }
        for (File file3 = file; file3 != null; file3 = file3.getParentFile()) {
            for (File file4 = file2; file4 != null; file4 = file4.getParentFile()) {
                if (!file3.equals(file4)) continue;
                return file4;
            }
        }
        return null;
    }

    private File getCommonAncestor(File[] fileArray) {
        File file = fileArray[0];
        for (int i = 1; i < fileArray.length; ++i) {
            File file2 = this.getCommonAncestor(file, fileArray[i]);
            if (file2 == null) {
                Mercurial.LOG.log(Level.SEVERE, "Unable to get common parent of {0} and {1} ", new Object[]{file.getAbsolutePath(), fileArray[i].getAbsolutePath()});
                continue;
            }
            file = file2;
        }
        return file;
    }

    public void performAction(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CreateAction.this.performCreate();
            }
        });
    }

    private void performCreate() {
        final Mercurial mercurial = Mercurial.getInstance();
        final File file = this.selectRootToManage();
        if (file == null) {
            return;
        }
        RequestProcessor requestProcessor = mercurial.getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                try {
                    OutputLogger outputLogger = this.getLogger();
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                    outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_INIT", (Object)file));
                    HgCommand.doCreate(file, outputLogger);
                    mercurial.versionedFilesChanged();
                    mercurial.refreshAllAnnotations();
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                }
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Progress"));
        HgProgressSupport hgProgressSupport2 = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    try {
                        FileStatusCache fileStatusCache = mercurial.getFileStatusCache();
                        Calendar calendar = Calendar.getInstance();
                        CreateAction.this.repositoryFiles = HgCommand.getUnknownStatus(file, file);
                        Calendar calendar2 = Calendar.getInstance();
                        Mercurial.LOG.log(Level.FINE, "getUnknownStatus took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
                        outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_ADD", (Object)CreateAction.this.repositoryFiles.keySet().size()));
                        calendar = Calendar.getInstance();
                        fileStatusCache.addToCache(CreateAction.this.repositoryFiles.keySet());
                        calendar2 = Calendar.getInstance();
                        Mercurial.LOG.log(Level.FINE, "addUnknownsToCache took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
                        if (CreateAction.this.repositoryFiles.keySet().size() < 500) {
                            for (File file2 : CreateAction.this.repositoryFiles.keySet()) {
                                outputLogger.output("\t" + file2.getAbsolutePath());
                            }
                        }
                        HgUtils.createIgnored(file);
                        outputLogger.output("");
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE_WARNING"));
                    }
                    catch (HgException hgException) {
                        NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                        Object var8_10 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                        outputLogger.output("");
                    }
                    Object var8_9 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                    outputLogger.output("");
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                    outputLogger.output("");
                    throw throwable;
                }
            }
        };
        hgProgressSupport2.start(requestProcessor, file, NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Add_Progress"));
    }

    private File selectRootToManage() {
        File file = this.getSuggestedRoot();
        final CreatePanel createPanel = new CreatePanel();
        createPanel.lblMessage.setVisible(false);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createPanel, NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Label"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CreatePanel.class), null);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        final RequestProcessor.Task task = Mercurial.getInstance().getRequestProcessor().create(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2;
                FileObject fileObject3;
                String string = createPanel.tfRootPath.getText();
                String string2 = null;
                boolean bl = true;
                File file = new File(string);
                if (!file.isDirectory()) {
                    string2 = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Error_Directory");
                    if (Mercurial.LOG.isLoggable(Level.FINE) && file.exists()) {
                        Mercurial.LOG.fine("CreateAction.selectRootToManage.validateTask: selected a file: " + file);
                    }
                    bl = false;
                }
                if (bl) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    fileObject2 = fileObject3 = file.listFiles();
                    int n = ((FileObject)fileObject2).length;
                    for (int i = 0; i < n; ++i) {
                        FileObject fileObject4 = fileObject2[i];
                        File file2 = null;
                        if (!fileObject4.isDirectory() || (file2 = Mercurial.getInstance().getRepositoryRoot((File)fileObject4)) == null) continue;
                        bl = false;
                        if (Mercurial.LOG.isLoggable(Level.FINE) && file.exists()) {
                            Mercurial.LOG.fine("CreateAction.selectRootToManage.validateTask: file is versioned: " + fileObject4 + ", root: " + file2);
                        }
                        string2 = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Error_Versioned");
                        break;
                    }
                }
                if (Thread.interrupted()) {
                    return;
                }
                if (bl && (fileObject2 = FileOwnerQuery.getOwner((FileObject)(fileObject3 = FileUtil.toFileObject((File)file)))) != null && FileUtil.isParentOf((FileObject)(fileObject = fileObject2.getProjectDirectory()), (FileObject)fileObject3)) {
                    string2 = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Warning_Under_Project");
                }
                if (Thread.interrupted()) {
                    return;
                }
                dialogDescriptor.setValid(bl);
                if (string2 != null) {
                    createPanel.lblMessage.setText(string2);
                    createPanel.lblMessage.setForeground(UIManager.getDefaults().getColor(bl ? "nb.warningForeground" : "nb.errorForeground"));
                }
                createPanel.lblMessage.setVisible(string2 != null);
                createPanel.invalidate();
            }
        });
        createPanel.tfRootPath.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            private void validate() {
                task.cancel();
                dialogDescriptor.setValid(false);
                task.schedule(300);
            }
        });
        createPanel.tfRootPath.setText(file == null ? "" : file.getAbsolutePath());
        do {
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                file = new File(createPanel.tfRootPath.getText());
                task.run();
                continue;
            }
            file = null;
        } while (!dialogDescriptor.isValid() && dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION);
        return file;
    }

    private File getSuggestedRoot() {
        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        Project project = HgUtils.getProject(this.context);
        File file = HgUtils.getProjectFile(project);
        File file2 = null;
        file2 = this.getCommonAncestor(fileArray);
        if (Mercurial.LOG.isLoggable(Level.FINER)) {
            Mercurial.LOG.finer("CreateAction.getSuggestedRoot: common root for " + this.context.getRootFiles() + ": " + file2);
        }
        if (file != null) {
            file2 = this.getCommonAncestor(file2, file);
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.finer("CreateAction.getSuggestedRoot: root with project at " + file + ": " + file2);
            }
        }
        return file2;
    }
}

