/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.openide.util.NbBundle;

final class ConditionPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private KeywordsFilter filter;
    private JComponent valueField;
    final JPanel emptyPanel = new JPanel();
    final JComboBox propertyCombo = new JComboBox();
    final JComboBox relationCombo = new JComboBox();

    public ConditionPanel(KeywordsFilter keywordsFilter, AppliedFilterCondition appliedFilterCondition) {
        this.filter = keywordsFilter;
        this.initComponents();
        this.initA11y();
        this.valueField = this.emptyPanel;
        TaskProperty[] taskPropertyArray = keywordsFilter.getProperties();
        int n = -1;
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        for (int i = 0; i < taskPropertyArray.length; ++i) {
            AppliedFilterCondition[] appliedFilterConditionArray = keywordsFilter.createConditions(taskPropertyArray[i]);
            if (appliedFilterConditionArray.length != 0) {
                defaultComboBoxModel.addElement(taskPropertyArray[i]);
                if (appliedFilterCondition == null) {
                    appliedFilterCondition = appliedFilterConditionArray[0];
                }
            }
            if (!taskPropertyArray[i].getName().equals(appliedFilterCondition.getProperty().getName())) continue;
            n = i;
        }
        this.propertyCombo.setModel(defaultComboBoxModel);
        this.propertyCombo.addActionListener(this);
        this.propertyCombo.setSelectedIndex(n);
        this.propertyCombo.setRenderer(new PropertyCellRenderer());
        AppliedFilterCondition[] appliedFilterConditionArray = keywordsFilter.createConditions(appliedFilterCondition.getProperty());
        defaultComboBoxModel = new DefaultComboBoxModel();
        for (int i = 0; i < appliedFilterConditionArray.length; ++i) {
            if (appliedFilterConditionArray[i].sameType(appliedFilterCondition)) {
                defaultComboBoxModel.addElement(appliedFilterCondition);
                continue;
            }
            defaultComboBoxModel.addElement(appliedFilterConditionArray[i]);
        }
        this.relationCombo.setModel(defaultComboBoxModel);
        this.relationCombo.addActionListener(this);
        this.relationCombo.setSelectedItem(appliedFilterCondition);
        this.relationCombo.setRenderer(new ConditionCellRenderer());
        this.setValueComponent(appliedFilterCondition.getCondition().createConstantComponent());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.propertyCombo) {
            AppliedFilterCondition[] appliedFilterConditionArray = this.filter.createConditions((TaskProperty)this.propertyCombo.getSelectedItem());
            this.relationCombo.setModel(new DefaultComboBoxModel<AppliedFilterCondition>(appliedFilterConditionArray));
            if (appliedFilterConditionArray.length != 0) {
                this.relationCombo.setSelectedIndex(0);
                AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
                this.setValueComponent(appliedFilterCondition.getCondition().createConstantComponent());
            } else {
                this.setValueComponent(null);
            }
        } else if (actionEvent.getSource() == this.relationCombo) {
            AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
            this.setValueComponent(appliedFilterCondition.getCondition().createConstantComponent());
        }
    }

    public AppliedFilterCondition getCondition() {
        AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
        if (this.valueField != this.emptyPanel) {
            appliedFilterCondition.getCondition().getConstantFrom(this.valueField);
        }
        return appliedFilterCondition;
    }

    private void initA11y() {
        this.propertyCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Property"));
        this.propertyCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Property"));
        this.relationCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Relation"));
        this.relationCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Relation"));
    }

    private void setValueComponent(JComponent jComponent) {
        if (this.valueField == this.emptyPanel && jComponent == null || this.valueField == jComponent) {
            return;
        }
        this.remove(this.valueField);
        if (jComponent == null) {
            this.valueField = this.emptyPanel;
        } else {
            if (jComponent instanceof JTextComponent && this.valueField instanceof JTextComponent && ((JTextComponent)jComponent).getText().length() == 0) {
                ((JTextComponent)jComponent).setText(((JTextComponent)this.valueField).getText());
            }
            this.valueField = jComponent;
            if (jComponent.getAccessibleContext().getAccessibleName() == null) {
                jComponent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionPanel.class, (String)"ACSN_Value"));
            }
            if (jComponent.getAccessibleContext().getAccessibleDescription() == null) {
                jComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionPanel.class, (String)"ACSD_Value"));
            }
            jComponent.addPropertyChangeListener("value-valid", this);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.valueField, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    public void focusPropertyCombo() {
        this.propertyCombo.requestFocusInWindow();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public boolean isValueValid() {
        AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)this.relationCombo.getSelectedItem();
        return this.valueField != this.emptyPanel && appliedFilterCondition.getCondition().isValueValid(this.valueField);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.propertyCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.relationCombo, gridBagConstraints);
        this.emptyPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.emptyPanel, gridBagConstraints);
    }

    private static class ConditionCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)object;
            if (appliedFilterCondition != null) {
                this.setText(appliedFilterCondition.getCondition().getDisplayName());
            }
            return this;
        }
    }

    private static class PropertyCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TaskProperty taskProperty = (TaskProperty)object;
            if (taskProperty != null) {
                this.setText(taskProperty.getName());
            }
            return this;
        }
    }
}

