/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScannerDescriptor
implements Comparable<ScannerDescriptor> {
    public abstract String getType();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getOptionsPath();

    @Override
    public int compareTo(ScannerDescriptor scannerDescriptor) {
        return this.getDisplayName().compareTo(scannerDescriptor.getDisplayName());
    }

    public static String getType(FileTaskScanner fileTaskScanner) {
        return fileTaskScanner.getClass().getName();
    }

    public static String getType(PushTaskScanner pushTaskScanner) {
        return pushTaskScanner.getClass().getName();
    }

    public static List<? extends ScannerDescriptor> getDescriptors() {
        List<FileTaskScanner> list = ScannerList.getFileScannerList().getScanners();
        List<PushTaskScanner> list2 = ScannerList.getPushScannerList().getScanners();
        ArrayList<ScannerDescriptor> arrayList = new ArrayList<ScannerDescriptor>(list.size() + list2.size());
        for (FileTaskScanner fileTaskScanner : list) {
            arrayList.add(new FileDescriptor(fileTaskScanner));
        }
        for (PushTaskScanner pushTaskScanner : list2) {
            arrayList.add(new PushDescriptor(pushTaskScanner));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static class FileDescriptor
    extends ScannerDescriptor {
        private FileTaskScanner scanner;

        public FileDescriptor(FileTaskScanner fileTaskScanner) {
            assert (null != fileTaskScanner);
            this.scanner = fileTaskScanner;
        }

        public String getDisplayName() {
            return Accessor.getDisplayName(this.scanner);
        }

        public String getDescription() {
            return Accessor.getDescription(this.scanner);
        }

        public String getOptionsPath() {
            return Accessor.getOptionsPath(this.scanner);
        }

        public String getType() {
            return FileDescriptor.getType(this.scanner);
        }
    }

    private static class PushDescriptor
    extends ScannerDescriptor {
        private PushTaskScanner scanner;

        public PushDescriptor(PushTaskScanner pushTaskScanner) {
            assert (null != pushTaskScanner);
            this.scanner = pushTaskScanner;
        }

        public String getDisplayName() {
            return Accessor.getDisplayName(this.scanner);
        }

        public String getDescription() {
            return Accessor.getDescription(this.scanner);
        }

        public String getOptionsPath() {
            return Accessor.getOptionsPath(this.scanner);
        }

        public String getType() {
            return PushDescriptor.getType(this.scanner);
        }
    }
}

