/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

class MenuToggleButton
extends JToggleButton {
    private boolean mouseInArrowArea = false;

    public MenuToggleButton(final Icon icon, Icon icon2, int n) {
        assert (null != icon);
        assert (null != icon2);
        final LineIcon lineIcon = new LineIcon(icon2, n);
        this.setIcon(icon);
        this.setRolloverIcon(lineIcon);
        this.setRolloverSelectedIcon(lineIcon);
        this.setFocusable(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                MenuToggleButton.this.mouseInArrowArea = MenuToggleButton.this.isInArrowArea(mouseEvent.getPoint());
                MenuToggleButton.this.setRolloverIcon(MenuToggleButton.this.mouseInArrowArea ? icon : lineIcon);
                MenuToggleButton.this.setRolloverSelectedIcon(MenuToggleButton.this.mouseInArrowArea ? icon : lineIcon);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if (MenuToggleButton.this.isInArrowArea(mouseEvent.getPoint()) && null != (jPopupMenu = MenuToggleButton.this.getPopupMenu())) {
                    jPopupMenu.show(MenuToggleButton.this, 0, MenuToggleButton.this.getHeight());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                MenuToggleButton.this.mouseInArrowArea = MenuToggleButton.this.isInArrowArea(mouseEvent.getPoint());
                MenuToggleButton.this.setRolloverIcon(MenuToggleButton.this.mouseInArrowArea ? icon : lineIcon);
                MenuToggleButton.this.setRolloverSelectedIcon(MenuToggleButton.this.mouseInArrowArea ? icon : lineIcon);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                MenuToggleButton.this.mouseInArrowArea = false;
                MenuToggleButton.this.setRolloverIcon(icon);
                MenuToggleButton.this.setRolloverSelectedIcon(icon);
            }
        });
        this.setModel(new Model());
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    private boolean isInArrowArea(Point point) {
        return point.getLocation().x >= this.getWidth() - 3 - 2 - this.getInsets().right;
    }

    private static class LineIcon
    implements Icon {
        private Icon origIcon;
        private int arrowWidth;

        public LineIcon(Icon icon, int n) {
            this.origIcon = icon;
            this.arrowWidth = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.origIcon.paintIcon(component, graphics, n, n2);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(n + this.origIcon.getIconWidth() - this.arrowWidth - 2, n2, n + this.origIcon.getIconWidth() - this.arrowWidth - 2, n2 + this.getIconHeight());
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n + this.origIcon.getIconWidth() - this.arrowWidth - 3, n2, n + this.origIcon.getIconWidth() - this.arrowWidth - 3, n2 + this.getIconHeight());
        }

        public int getIconWidth() {
            return this.origIcon.getIconWidth();
        }

        public int getIconHeight() {
            return this.origIcon.getIconHeight();
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        public void setPressed(boolean bl) {
            if (MenuToggleButton.this.mouseInArrowArea) {
                return;
            }
            super.setPressed(bl);
        }
    }
}

