/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.OpenTaskAction;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.FiltersMenuButton;
import org.netbeans.modules.tasklist.ui.TaskListTable;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.NbBundle;

class Util {
    private Util() {
    }

    public static Action getDefaultAction(Task task) {
        return new OpenTaskAction(task);
    }

    public static JPopupMenu createPopup(TaskListTable taskListTable) {
        Action[] actionArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Task task = taskListTable.getSelectedTask();
        if (null != task) {
            jPopupMenu.add(Util.getDefaultAction(task));
            jPopupMenu.addSeparator();
            actionArray = Accessor.getActions(task);
            if (null != actionArray) {
                for (Action object : actionArray) {
                    if (null != object) {
                        jPopupMenu.add(object);
                        continue;
                    }
                    jPopupMenu.addSeparator();
                }
                if (actionArray.length > 0 && actionArray[actionArray.length - 1] != null) {
                    jPopupMenu.addSeparator();
                }
            }
        }
        actionArray = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_Scope"));
        Action[] actionArray2 = ScanningScopeList.getDefault();
        for (TaskScanningScope taskScanningScope : actionArray2.getTaskScanningScopes()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SwitchScopeAction(taskScanningScope));
            jRadioButtonMenuItem.setSelected(taskScanningScope.equals(TaskManagerImpl.getInstance().getScope()));
            actionArray.add(jRadioButtonMenuItem);
        }
        jPopupMenu.add((JMenuItem)actionArray);
        JMenu jMenu = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_Filter"));
        FiltersMenuButton.fillMenu(null, jMenu);
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new RefreshAction());
        jPopupMenu.addSeparator();
        JMenu jMenu2 = Util.createSortMenu(taskListTable);
        jPopupMenu.add(jMenu2);
        return jPopupMenu;
    }

    private static JMenu createSortMenu(TaskListTable taskListTable) {
        JMenu jMenu = new JMenu(NbBundle.getMessage(Util.class, (String)"LBL_SortBy"));
        for (int i = 1; i < taskListTable.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new SwitchSortAction(taskListTable, i));
            jCheckBoxMenuItem.setSelected(i == taskListTable.getSortColumn());
            jMenu.add(jCheckBoxMenuItem);
        }
        jMenu.addSeparator();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SwitchSortOrderAction(taskListTable, true));
        jRadioButtonMenuItem.setSelected(taskListTable.isAscendingSort());
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new SwitchSortOrderAction(taskListTable, false));
        jRadioButtonMenuItem.setSelected(!taskListTable.isAscendingSort());
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    private static class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(NbBundle.getMessage(Util.class, (String)"LBL_Refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            taskManagerImpl.clearCache();
            taskManagerImpl.refresh(taskManagerImpl.getScope());
        }
    }

    private static class SwitchScopeAction
    extends AbstractAction {
        private TaskScanningScope scope;

        public SwitchScopeAction(TaskScanningScope taskScanningScope) {
            super(Accessor.getDisplayName(taskScanningScope), new ImageIcon(Accessor.getIcon(taskScanningScope)));
            this.scope = taskScanningScope;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            taskManagerImpl.observe(this.scope, taskManagerImpl.getFilter());
        }
    }

    private static class SwitchSortAction
    extends AbstractAction {
        private TaskListTable table;
        private int col;

        public SwitchSortAction(TaskListTable taskListTable, int n) {
            super(taskListTable.getModel().getColumnName(n));
            this.table = taskListTable;
            this.col = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.col == this.table.getSortColumn()) {
                this.table.setSortColumn(-1);
            } else {
                this.table.setSortColumn(this.col);
            }
            this.table.getTableHeader().repaint();
        }
    }

    private static class SwitchSortOrderAction
    extends AbstractAction {
        private TaskListTable table;
        private boolean asc;

        public SwitchSortOrderAction(TaskListTable taskListTable, boolean bl) {
            super(bl ? NbBundle.getMessage(Util.class, (String)"LBL_Asc") : NbBundle.getMessage(Util.class, (String)"LBL_Desc"));
            this.table = taskListTable;
            this.asc = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.table.setAscendingSort(this.asc);
            this.table.getTableHeader().repaint();
        }
    }
}

