/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution;

import java.nio.charset.Charset;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.openide.windows.InputOutput;

public final class ExecutionDescriptor {
    private final Runnable preExecution;
    private final Runnable postExecution;
    private final boolean suspend;
    private final boolean progress;
    private final boolean front;
    private final boolean input;
    private final boolean controllable;
    private boolean outLineBased;
    private boolean errLineBased;
    private final LineConvertorFactory outConvertorFactory;
    private final LineConvertorFactory errConvertorFactory;
    private final InputProcessorFactory outProcessorFactory;
    private final InputProcessorFactory errProcessorFactory;
    private final InputOutput inputOutput;
    private final RerunCondition rerunCondition;
    private final String optionsPath;
    private final Charset charset;

    public ExecutionDescriptor() {
        this(new DescriptorData());
    }

    private ExecutionDescriptor(DescriptorData descriptorData) {
        this.preExecution = descriptorData.preExecution;
        this.postExecution = descriptorData.postExecution;
        this.suspend = descriptorData.suspend;
        this.progress = descriptorData.progress;
        this.front = descriptorData.front;
        this.input = descriptorData.input;
        this.controllable = descriptorData.controllable;
        this.outLineBased = descriptorData.outLineBased;
        this.errLineBased = descriptorData.errLineBased;
        this.outConvertorFactory = descriptorData.outConvertorFactory;
        this.errConvertorFactory = descriptorData.errConvertorFactory;
        this.outProcessorFactory = descriptorData.outProcessorFactory;
        this.errProcessorFactory = descriptorData.errProcessorFactory;
        this.inputOutput = descriptorData.inputOutput;
        this.rerunCondition = descriptorData.rerunCondition;
        this.optionsPath = descriptorData.optionsPath;
        this.charset = descriptorData.charset;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor inputOutput(@NullAllowed InputOutput inputOutput) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.inputOutput(inputOutput));
    }

    InputOutput getInputOutput() {
        return this.inputOutput;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor controllable(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.controllable(bl));
    }

    boolean isControllable() {
        return this.controllable;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor frontWindow(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.frontWindow(bl));
    }

    boolean isFrontWindow() {
        return this.front;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor inputVisible(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.inputVisible(bl));
    }

    boolean isInputVisible() {
        return this.input;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor showProgress(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.showProgress(bl));
    }

    boolean showProgress() {
        return this.progress;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor showSuspended(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.showSuspended(bl));
    }

    boolean showSuspended() {
        return this.suspend;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor outLineBased(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.outLineBased(bl));
    }

    boolean isOutLineBased() {
        return this.outLineBased;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor errLineBased(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.errLineBased(bl));
    }

    boolean isErrLineBased() {
        return this.errLineBased;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor outProcessorFactory(@NullAllowed InputProcessorFactory inputProcessorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.outProcessorFactory(inputProcessorFactory));
    }

    InputProcessorFactory getOutProcessorFactory() {
        return this.outProcessorFactory;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor errProcessorFactory(@NullAllowed InputProcessorFactory inputProcessorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.errProcessorFactory(inputProcessorFactory));
    }

    InputProcessorFactory getErrProcessorFactory() {
        return this.errProcessorFactory;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor outConvertorFactory(@NullAllowed LineConvertorFactory lineConvertorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.outConvertorFactory(lineConvertorFactory));
    }

    LineConvertorFactory getOutConvertorFactory() {
        return this.outConvertorFactory;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor errConvertorFactory(@NullAllowed LineConvertorFactory lineConvertorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.errConvertorFactory(lineConvertorFactory));
    }

    LineConvertorFactory getErrConvertorFactory() {
        return this.errConvertorFactory;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor preExecution(@NullAllowed Runnable runnable) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.preExecution(runnable));
    }

    Runnable getPreExecution() {
        return this.preExecution;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor postExecution(@NullAllowed Runnable runnable) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.postExecution(runnable));
    }

    Runnable getPostExecution() {
        return this.postExecution;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor rerunCondition(@NullAllowed RerunCondition rerunCondition) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.rerunCondition(rerunCondition));
    }

    RerunCondition getRerunCondition() {
        return this.rerunCondition;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor optionsPath(@NullAllowed String string) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.optionsPath(string));
    }

    String getOptionsPath() {
        return this.optionsPath;
    }

    @NonNull
    @CheckReturnValue
    public ExecutionDescriptor charset(@NullAllowed Charset charset) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.charset(charset));
    }

    Charset getCharset() {
        return this.charset;
    }

    private static final class DescriptorData {
        private Runnable preExecution;
        private Runnable postExecution;
        private boolean suspend;
        private boolean progress;
        private boolean front;
        private boolean input;
        private boolean controllable;
        private boolean outLineBased;
        private boolean errLineBased;
        private LineConvertorFactory outConvertorFactory;
        private LineConvertorFactory errConvertorFactory;
        private InputProcessorFactory outProcessorFactory;
        private InputProcessorFactory errProcessorFactory;
        private InputOutput inputOutput;
        private RerunCondition rerunCondition;
        private String optionsPath;
        private Charset charset;

        public DescriptorData() {
        }

        public DescriptorData(ExecutionDescriptor executionDescriptor) {
            this.preExecution = executionDescriptor.preExecution;
            this.postExecution = executionDescriptor.postExecution;
            this.suspend = executionDescriptor.suspend;
            this.progress = executionDescriptor.progress;
            this.front = executionDescriptor.front;
            this.input = executionDescriptor.input;
            this.controllable = executionDescriptor.controllable;
            this.outLineBased = executionDescriptor.outLineBased;
            this.errLineBased = executionDescriptor.errLineBased;
            this.outConvertorFactory = executionDescriptor.outConvertorFactory;
            this.errConvertorFactory = executionDescriptor.errConvertorFactory;
            this.outProcessorFactory = executionDescriptor.outProcessorFactory;
            this.errProcessorFactory = executionDescriptor.errProcessorFactory;
            this.inputOutput = executionDescriptor.inputOutput;
            this.rerunCondition = executionDescriptor.rerunCondition;
            this.optionsPath = executionDescriptor.optionsPath;
            this.charset = executionDescriptor.charset;
        }

        public DescriptorData inputOutput(InputOutput inputOutput) {
            this.inputOutput = inputOutput;
            return this;
        }

        public DescriptorData controllable(boolean bl) {
            this.controllable = bl;
            return this;
        }

        public DescriptorData frontWindow(boolean bl) {
            this.front = bl;
            return this;
        }

        public DescriptorData inputVisible(boolean bl) {
            this.input = bl;
            return this;
        }

        public DescriptorData showProgress(boolean bl) {
            this.progress = bl;
            return this;
        }

        public DescriptorData showSuspended(boolean bl) {
            this.suspend = bl;
            return this;
        }

        public DescriptorData outLineBased(boolean bl) {
            this.outLineBased = bl;
            return this;
        }

        public DescriptorData errLineBased(boolean bl) {
            this.errLineBased = bl;
            return this;
        }

        public DescriptorData outProcessorFactory(InputProcessorFactory inputProcessorFactory) {
            this.outProcessorFactory = inputProcessorFactory;
            return this;
        }

        public DescriptorData errProcessorFactory(InputProcessorFactory inputProcessorFactory) {
            this.errProcessorFactory = inputProcessorFactory;
            return this;
        }

        public DescriptorData outConvertorFactory(LineConvertorFactory lineConvertorFactory) {
            this.outConvertorFactory = lineConvertorFactory;
            return this;
        }

        public DescriptorData errConvertorFactory(LineConvertorFactory lineConvertorFactory) {
            this.errConvertorFactory = lineConvertorFactory;
            return this;
        }

        public DescriptorData preExecution(Runnable runnable) {
            this.preExecution = runnable;
            return this;
        }

        public DescriptorData postExecution(Runnable runnable) {
            this.postExecution = runnable;
            return this;
        }

        public DescriptorData rerunCondition(RerunCondition rerunCondition) {
            this.rerunCondition = rerunCondition;
            return this;
        }

        public DescriptorData optionsPath(String string) {
            this.optionsPath = string;
            return this;
        }

        public DescriptorData charset(Charset charset) {
            this.charset = charset;
            return this;
        }
    }

    public static interface InputProcessorFactory {
        @NonNull
        public InputProcessor newInputProcessor(@NonNull InputProcessor var1);
    }

    public static interface LineConvertorFactory {
        @NonNull
        public LineConvertor newLineConvertor();
    }

    public static interface RerunCondition {
        public void addChangeListener(@NonNull ChangeListener var1);

        public void removeChangeListener(@NonNull ChangeListener var1);

        public boolean isRerunPossible();
    }
}

