/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.dtd;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public interface DTD {
    public String getIdentifier();

    public List getElementList(String var1);

    public Element getElement(String var1);

    public List getCharRefList(String var1);

    public CharRef getCharRef(String var1);

    public static interface Attribute {
        public static final int TYPE_BOOLEAN = 0;
        public static final int TYPE_SET = 1;
        public static final int TYPE_BASE = 2;
        public static final String MODE_IMPLIED = "#IMPLIED";
        public static final String MODE_REQUIRED = "#REQUIRED";
        public static final String MODE_FIXED = "#FIXED";

        public String getName();

        public int getType();

        public String getBaseType();

        public String getTypeHelper();

        public String getDefaultMode();

        public boolean isRequired();

        public List getValueList(String var1);

        public Value getValue(String var1);
    }

    public static interface CharRef {
        public String getName();

        public char getValue();
    }

    public static interface Content {
        public static final Content EMPTY_CONTENT = new EmptyContent();

        public boolean isDiscardable();

        public Content reduce(String var1);

        public Set getPossibleElements();

        public static class EmptyContent
        implements Content {
            public boolean isDiscardable() {
                return true;
            }

            public Content reduce(String string) {
                return null;
            }

            public Set getPossibleElements() {
                return new TreeSet();
            }
        }
    }

    public static interface ContentLeaf
    extends Content {
        public Element getElement();

        public String getElementName();
    }

    public static interface ContentModel {
        public Content getContent();

        public Set getIncludes();

        public Set getExcludes();
    }

    public static interface ContentNode
    extends Content {
        public char getType();
    }

    public static interface Element {
        public String getName();

        public boolean isEmpty();

        public boolean hasOptionalStart();

        public boolean hasOptionalEnd();

        public List getAttributeList(String var1);

        public Attribute getAttribute(String var1);

        public ContentModel getContentModel();
    }

    public static interface Value {
        public String getName();
    }
}

