/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeRepositoriesJob
extends SynchronizationJob {
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private Set<TaskRepository> repositories;
    private final Object family = new Object();
    private final IRepositoryModel tasksModel;

    public SynchronizeRepositoriesJob(TaskList taskList, TaskDataManager taskDataManager, IRepositoryModel tasksModel, IRepositoryManager repositoryManager) {
        super(Messages.SynchronizeRepositoriesJob_Synchronizing_Task_List);
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.tasksModel = tasksModel;
        this.repositoryManager = repositoryManager;
    }

    public Collection<TaskRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public void setRepositories(Collection<TaskRepository> repositories) {
        this.repositories = repositories != null ? new HashSet<TaskRepository>(repositories) : null;
    }

    public IStatus run(IProgressMonitor monitor) {
        Set<TaskRepository> repositories = this.repositories;
        if (repositories == null) {
            repositories = new HashSet<TaskRepository>(this.repositoryManager.getAllRepositories());
        }
        try {
            monitor.beginTask(Messages.SynchronizeRepositoriesJob_Processing, repositories.size() * 100);
            for (TaskRepository repository : repositories) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    if (repository.isOffline()) {
                        monitor.worked(100);
                        continue;
                    }
                    monitor.setTaskName(MessageFormat.format(Messages.SynchronizeRepositoriesJob_Processing_, repository.getRepositoryLabel()));
                    AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
                    Set<RepositoryQuery> queries = this.taskList.getRepositoryQueries(repository.getRepositoryUrl());
                    if (this.isUser() || queries.isEmpty()) {
                        monitor.worked(20);
                    } else {
                        this.updateRepositoryConfiguration(repository, connector, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    }
                    this.updateQueries(repository, connector, queries, monitor);
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void updateQueries(TaskRepository repository, AbstractRepositoryConnector connector, Set<RepositoryQuery> queries, IProgressMonitor monitor) {
        if (this.isUser()) {
            for (RepositoryQuery query : queries) {
                query.setSynchronizing(true);
            }
            this.taskList.notifySynchronizationStateChanged(queries);
        }
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries){

            public boolean belongsTo(Object family) {
                return SynchronizeRepositoriesJob.this.family == family;
            }
        };
        job.setUser(this.isUser());
        job.setFullSynchronization(true);
        job.setPriority(50);
        if (this.isUser()) {
            job.schedule();
        } else {
            job.run((IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
    }

    public Object getFamily() {
        return this.family;
    }

    private void updateRepositoryConfiguration(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) throws InterruptedException {
        try {
            try {
                if (!this.isUser()) {
                    monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
                }
                monitor.beginTask(MessageFormat.format(Messages.SynchronizeRepositoriesJob_Updating_repository_configuration_for_X, repository.getRepositoryUrl()), 100);
                if (connector.isRepositoryConfigurationStale(repository, monitor)) {
                    connector.updateRepositoryConfiguration(repository, monitor);
                    repository.setConfigurationDate(new Date());
                }
            }
            catch (CoreException e) {
                repository.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Updating of repository configuration failed", (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

