/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ui.Hacks;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProjectChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private RequestProcessor.Task updateSubprojectsTask;
    private RequestProcessor.Task displayNameTask;
    private RequestProcessor RP;
    private RequestProcessor RP2;
    ModelUpdater modelUpdater;
    private Boolean tempSetAsMain;
    private Map<Project, Set<? extends Project>> subprojectsCache = new HashMap<Project, Set<? extends Project>>();
    private JCheckBox jCheckBoxMain;
    private JCheckBox jCheckBoxSubprojects;
    private JLabel jLabelProjectName;
    private JList jListSubprojects;
    private JScrollPane jScrollPaneSubprojects;
    private JTextField jTextFieldProjectName;

    public ProjectChooserAccessory(JFileChooser jFileChooser, boolean bl, boolean bl2) {
        this.initComponents();
        this.modelUpdater = new ModelUpdater();
        this.RP = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.RP2 = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.updateSubprojectsTask = this.RP.create((Runnable)this.modelUpdater);
        this.updateSubprojectsTask.setPriority(1);
        this.jCheckBoxSubprojects.setSelected(bl);
        this.jCheckBoxSubprojects.addActionListener(this);
        this.jCheckBoxMain.setSelected(bl2);
        this.jCheckBoxMain.addActionListener(this);
        jFileChooser.addPropertyChangeListener(this);
        this.jListSubprojects.setModel(new DefaultListModel());
        this.setAccessoryEnablement(false, 0);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jCheckBoxMain = new JCheckBox();
        this.jCheckBoxSubprojects = new JCheckBox();
        this.jScrollPaneSubprojects = new JScrollPane();
        this.jListSubprojects = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 12, 0, 0)));
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabelProjectName, gridBagConstraints);
        this.jLabelProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectName"));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectName"));
        this.jTextFieldProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldProjectName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMain, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Main_CheckBox"));
        this.jCheckBoxMain.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxMain, gridBagConstraints);
        this.jCheckBoxMain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxMain"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubprojects, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Subprojects_CheckBox"));
        this.jCheckBoxSubprojects.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxSubprojects, gridBagConstraints);
        this.jCheckBoxSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxSubprojects"));
        this.jListSubprojects.setSelectionMode(0);
        this.jListSubprojects.setEnabled(false);
        this.jScrollPaneSubprojects.setViewportView(this.jListSubprojects);
        this.jListSubprojects.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSN_ProjectChooserAccessory_jListSubprojects"));
        this.jListSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jListSubprojects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPaneSubprojects, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jCheckBoxSubprojects) {
            OpenProjectListSettings.getInstance().setOpenSubprojects(this.jCheckBoxSubprojects.isSelected());
        } else if (actionEvent.getSource() == this.jCheckBoxMain) {
            OpenProjectListSettings.getInstance().setOpenAsMain(this.jCheckBoxMain.isSelected());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            final ListModel listModel = this.jListSubprojects.getModel();
            final File[] fileArray = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage"));
            if (this.displayNameTask != null) {
                this.displayNameTask.cancel();
            }
            this.displayNameTask = this.RP2.post(new Runnable(){

                public void run() {
                    final ArrayList<Project> arrayList = new ArrayList<Project>(fileArray.length);
                    final ArrayList<String> arrayList2 = new ArrayList<String>(fileArray.length);
                    for (File file : fileArray) {
                        if (file == null) continue;
                        if (Thread.interrupted()) {
                            return;
                        }
                        Project project = ProjectChooserAccessory.getProject(FileUtil.normalizeFile((File)file));
                        if (project == null) continue;
                        arrayList.add(project);
                        arrayList2.add(ProjectUtils.getInformation((Project)project).getDisplayName());
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (!arrayList.isEmpty()) {
                                ProjectChooserAccessory.this.setAccessoryEnablement(true, arrayList.size());
                                if (arrayList.size() == 1) {
                                    String string = (String)arrayList2.get(0);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(string);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(string);
                                } else {
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Multiselection", (Object)arrayList.size()));
                                    StringBuffer stringBuffer = new StringBuffer("<html>");
                                    for (String string : arrayList2) {
                                        stringBuffer.append(string);
                                        stringBuffer.append("<br>");
                                    }
                                    stringBuffer.setLength(stringBuffer.length() - "<br>".length());
                                    stringBuffer.append("</html>");
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(stringBuffer.toString());
                                }
                                if (listModel instanceof DefaultListModel) {
                                    ((DefaultListModel)listModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ProjectChooserAccessory.this.modelUpdater.projects = arrayList;
                                    ProjectChooserAccessory.this.updateSubprojectsTask.schedule(100);
                                }
                            } else {
                                ProjectChooserAccessory.this.jTextFieldProjectName.setText("");
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ProjectChooserAccessory.this.modelUpdater.projects = null;
                                }
                                if (listModel instanceof DefaultListModel) {
                                    ((DefaultListModel)listModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                ProjectChooserAccessory.this.setAccessoryEnablement(false, 0);
                                if (fileArray.length == 1 && fileArray[0] != null) {
                                    File file = FileUtil.normalizeFile((File)fileArray[0]);
                                    FileObject fileObject = FileUtil.toFileObject((File)file);
                                    ProjectManager.getDefault().clearNonProjectCache();
                                    if (fileObject != null && fileObject.isFolder() && ProjectManager.getDefault().isProject(fileObject)) {
                                        try {
                                            Project project = ProjectManager.getDefault().findProject(fileObject);
                                            if (project == null) {
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Unrecognized"));
                                                ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                            }
                                        }
                                        catch (IOException iOException) {
                                            String string = Exceptions.findLocalizedMessage((Throwable)iOException);
                                            if (string == null) {
                                                string = iOException.getLocalizedMessage();
                                            }
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setText(string);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setCaretPosition(0);
                                            Color color = UIManager.getColor("nb.errorForeground");
                                            if (color != null) {
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setForeground(color);
                                            }
                                            ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            }, 100, 1);
        } else if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.setAccessoryEnablement(false, 0);
        }
    }

    private static boolean isProjectDir(File file) {
        FileObject fileObject;
        boolean bl = false;
        if (file != null && (fileObject = ProjectChooserAccessory.convertToValidDir(file)) != null) {
            bl = Utilities.isUnix() && fileObject.getParent() != null && fileObject.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fileObject);
        }
        return bl;
    }

    private static FileObject convertToValidDir(File file) {
        File file2 = new File(file.getPath());
        if (file2 == null || file2.getParent() == null) {
            return null;
        }
        if (!file2.isDirectory()) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        return fileObject;
    }

    private static Project getProject(File file) {
        return OpenProjectList.fileToProject(file);
    }

    private static ProjectManager.Result getProjectResult(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null && fileObject.isFolder()) {
            return ProjectManager.getDefault().isProject2(fileObject);
        }
        return null;
    }

    private void setAccessoryEnablement(boolean bl, int n) {
        this.jLabelProjectName.setEnabled(bl);
        this.jTextFieldProjectName.setEnabled(bl);
        this.jTextFieldProjectName.setForeground(null);
        this.jCheckBoxSubprojects.setEnabled(bl);
        this.jScrollPaneSubprojects.setEnabled(bl);
        if (n <= 1) {
            if (this.tempSetAsMain != null) {
                this.jCheckBoxMain.setSelected(this.tempSetAsMain);
                this.tempSetAsMain = null;
            }
            this.jCheckBoxMain.setEnabled(bl);
        } else if (this.tempSetAsMain == null) {
            this.tempSetAsMain = this.jCheckBoxMain.isSelected();
            this.jCheckBoxMain.setSelected(false);
            this.jCheckBoxMain.setEnabled(false);
        }
    }

    private static String relativizePath(File file, File file2) {
        if (file == null || file2 == null) {
            return null;
        }
        if (!CollocationQuery.areCollocated((File)file, (File)file2)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(ProjectChooserAccessory.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    public static JFileChooser createProjectChooser(boolean bl) {
        File file;
        ProjectManager.getDefault().clearNonProjectCache();
        OpenProjectListSettings openProjectListSettings = OpenProjectListSettings.getInstance();
        ProjectFileChooser projectFileChooser = new ProjectFileChooser();
        projectFileChooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            projectFileChooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        projectFileChooser.setApproveButtonText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonText"));
        projectFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MNM_PrjChooser_ApproveButtonText").charAt(0));
        projectFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonTooltipText"));
        projectFileChooser.setDialogTitle(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Title"));
        projectFileChooser.setAcceptAllFileFilterUsed(false);
        projectFileChooser.setFileFilter(ProjectDirFilter.INSTANCE);
        projectFileChooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectChooserAccessory"));
        projectFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectChooserAccessory"));
        if (bl) {
            projectFileChooser.setAccessory(new ProjectChooserAccessory(projectFileChooser, openProjectListSettings.isOpenSubprojects(), openProjectListSettings.isOpenAsMain()));
        }
        File file2 = null;
        String string = openProjectListSettings.getLastOpenProjectDir();
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            file2 = file;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)projectFileChooser, file2);
        new ProjectFileView(projectFileChooser);
        return projectFileChooser;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.modelUpdater != null) {
            this.modelUpdater.cancel();
        }
        if (this.updateSubprojectsTask != null) {
            this.updateSubprojectsTask.cancel();
        }
        if (this.displayNameTask != null) {
            this.displayNameTask.cancel();
        }
        this.modelUpdater = null;
        this.subprojectsCache = null;
        this.updateSubprojectsTask = null;
        this.displayNameTask = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelUpdater
    implements Runnable,
    Cancellable {
        volatile List<Project> projects;
        private DefaultListModel subprojectsToSet;
        private boolean cancel = false;

        ModelUpdater() {
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                Object object;
                if (this.cancel) {
                    return;
                }
                List<Project> list = this.projects;
                if (list == null) {
                    return;
                }
                Map map = ProjectChooserAccessory.this.subprojectsCache;
                if (map == null) {
                    return;
                }
                ProjectChooserAccessory.this.jListSubprojects.setListData(new String[]{NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage")});
                ArrayList<Project> arrayList = new ArrayList<Project>(list.size() * 5);
                for (Project object22 : list) {
                    if (this.cancel) {
                        return;
                    }
                    this.addSubprojects(object22, arrayList, map);
                }
                if (this.cancel) {
                    return;
                }
                ArrayList arrayList2 = new ArrayList(arrayList.size());
                if (!arrayList.isEmpty()) {
                    String string = NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_SubprojectName_Format");
                    object = list.size() == 1 ? FileUtil.toFile((FileObject)list.get(0).getProjectDirectory()) : null;
                    for (Project project : arrayList) {
                        if (this.cancel) {
                            return;
                        }
                        FileObject fileObject = project.getProjectDirectory();
                        String string2 = null;
                        if (object != null) {
                            string2 = ProjectChooserAccessory.relativizePath((File)object, FileUtil.toFile((FileObject)fileObject));
                        }
                        if (string2 == null) {
                            string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
                        }
                        String string3 = MessageFormat.format(string, ProjectUtils.getInformation((Project)project).getDisplayName(), string2);
                        arrayList2.add(string3);
                    }
                    Collections.sort(arrayList2, Collator.getInstance());
                }
                if (list != this.projects || this.cancel) {
                    return;
                }
                DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    defaultListModel.addElement(string);
                }
                this.subprojectsToSet = defaultListModel;
                if (this.cancel) {
                    return;
                }
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.projects == null) {
                ListModel listModel = ProjectChooserAccessory.this.jListSubprojects.getModel();
                if (listModel instanceof DefaultListModel) {
                    ((DefaultListModel)listModel).clear();
                } else {
                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                }
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(false);
            } else {
                ProjectChooserAccessory.this.jListSubprojects.setModel(this.subprojectsToSet);
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(!this.subprojectsToSet.isEmpty());
                this.projects = null;
            }
        }

        void addSubprojects(Project project, List<Project> list, Map<Project, Set<? extends Project>> map) {
            if (this.cancel) {
                return;
            }
            Set<? extends Project> set = map.get(project);
            if (set == null) {
                SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
                if (subprojectProvider != null) {
                    if (this.cancel) {
                        return;
                    }
                    set = subprojectProvider.getSubprojects();
                } else {
                    set = Collections.emptySet();
                }
                map.put(project, set);
            }
            for (Project project2 : set) {
                if (this.cancel) {
                    return;
                }
                if (list.contains(project2)) continue;
                list.add(project2);
                this.addSubprojects(project2, list, map);
            }
        }

        public boolean cancel() {
            this.cancel = true;
            return true;
        }
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return !"CVS".equalsIgnoreCase(file.getName()) || !new File(file, "Entries").exists();
            }
            return false;
        }

        public String getDescription() {
            return NbBundle.getMessage(ProjectDirFilter.class, (String)"LBL_PrjChooser_ProjectDirectoryFilter_Name");
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null) {
                File file2 = FileUtil.normalizeFile((File)file);
                if (ProjectChooserAccessory.isProjectDir(file2) && ProjectChooserAccessory.getProject(file2) != null) {
                    super.approveSelection();
                } else {
                    this.setCurrentDirectory(file2);
                }
            }
        }
    }

    private static class ProjectFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = Hacks.RP.create((Runnable)this);
        private File lookingForIcon;

        public ProjectFileView(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            jFileChooser.setFileView(this);
            this.task.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Icon getIcon(File file) {
            if (!file.exists()) {
                return null;
            }
            File file2 = FileUtil.normalizeFile((File)file);
            if (ProjectChooserAccessory.isProjectDir(file2)) {
                ProjectFileView projectFileView = this;
                synchronized (projectFileView) {
                    Icon icon = this.knownProjectIcons.get(file2);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = file2;
                        this.task.schedule(20);
                    }
                }
            }
            if (file2.exists()) {
                return this.chooser.getFileSystemView().getSystemIcon(file2);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProjectFileView projectFileView;
            Icon icon;
            ProjectManager.Result result = ProjectChooserAccessory.getProjectResult(this.lookingForIcon);
            if (result != null) {
                icon = result.getIcon();
                if (icon == null) {
                    projectFileView = ProjectChooserAccessory.getProject(this.lookingForIcon);
                    icon = projectFileView != null ? ProjectUtils.getInformation((Project)projectFileView).getIcon() : this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
                }
            } else {
                icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            }
            projectFileView = this;
            synchronized (projectFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

