/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ui.groups.DirectoryGroupEditPanel;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(DirectoryGroup.class.getName());
    static final String KIND = "directory";

    public static DirectoryGroup create(String string, FileObject fileObject) throws FileStateInvalidException {
        String string2 = fileObject.getURL().toExternalForm();
        String string3 = DirectoryGroup.sanitizeNameAndUniquifyForId(string);
        LOG.log(Level.FINE, "Creating: {0}", string3);
        Preferences preferences = NODE.node(string3);
        preferences.put("name", string);
        preferences.put("kind", KIND);
        preferences.put("path", string2);
        return new DirectoryGroup(string3);
    }

    DirectoryGroup(String string) {
        super(string);
    }

    @Override
    protected void findProjects(Set<Project> set, ProgressHandle progressHandle, int n, int n2) {
        String string = this.prefs().get("path", null);
        FileObject fileObject = null;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.WARNING, "MalformedURLException: {0}", string);
        }
        if (fileObject != null && fileObject.isFolder()) {
            Object object;
            try {
                object = ProjectManager.getDefault().findProject(fileObject);
                if (object != null) {
                    set.add((Project)object);
                    if (progressHandle != null) {
                        progressHandle.progress(DirectoryGroup.progressMessage(object), Math.min(++n, n2));
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            object = new Counter();
            object.start = n;
            object.end = n2;
            this.processFolderChildren(fileObject, set, progressHandle, (Counter)object, true);
        }
    }

    public FileObject getDirectory() {
        String string = this.prefs().get("path", null);
        if (string != null && string.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, null, malformedURLException);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new DirectoryGroupEditPanel(this);
    }

    private void processFolderChildren(FileObject fileObject, Set<Project> set, ProgressHandle progressHandle, Counter counter, boolean bl) throws IllegalArgumentException {
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            try {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                File file = FileUtil.toFile((FileObject)fileObject);
                int n = 0;
                if (bl && (n = SharabilityQuery.getSharability((File)file)) == 2) continue;
                Project project = ProjectManager.getDefault().findProject(fileObject2);
                if (project != null) {
                    set.add(project);
                    if (progressHandle != null) {
                        progressHandle.progress(DirectoryGroup.progressMessage(project), Math.min(++counter.start, counter.end));
                    }
                }
                bl = n != 1;
                this.processFolderChildren(fileObject2, set, progressHandle, counter, bl);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static class Counter {
        int start;
        int end;

        private Counter() {
        }
    }
}

