/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.SchemaParser;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDataNode;
import org.netbeans.modules.xml.wizard.impl.SchemaImportGUI;
import org.netbeans.modules.xml.wizard.impl.SchemaObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SchemaPanel
extends AbstractPanel
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = -7568909683682244030L;
    private TemplateWizard templateWizard;
    private FileObject primarySchema = null;
    private Vector rows;
    private static final int PRIMARY_COL = 0;
    private static final int SCHEMA_COL = 1;
    private static final int ROOT_COL = 2;
    private static final int PREFIX_COL = 3;
    private SchemaTableModel tableModel;
    private SchemaImportGUI gui;
    private static String startString;
    private static final String PREFIX = "ns";
    private JButton browseButton;
    private JScrollPane jScrollPane1;
    private JLabel locationLabel;
    private JPanel locationPanel;
    private JButton removeButton;
    private JTable schemaTable;

    public SchemaPanel(TemplateWizard templateWizard) {
        this.templateWizard = templateWizard;
        this.rows = new Vector();
        this.tableModel = new SchemaTableModel();
        this.initComponents();
        this.initAccessibility();
        this.initComp();
    }

    private void initComponents() {
        this.locationPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.schemaTable = new JTable();
        this.locationLabel = new JLabel();
        this.browseButton = new JButton();
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton = new JButton();
        this.setName(Util.THIS.getString(SchemaPanel.class, "PROP_schema_panel_name"));
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationPanel.setLayout(new BorderLayout());
        this.schemaTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.schemaTable);
        this.schemaTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Schema_table"));
        this.schemaTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Schema_table"));
        this.locationPanel.add((Component)this.jScrollPane1, "Center");
        this.locationLabel.setLabelFor(this.locationPanel);
        this.locationLabel.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_SchemaPanel_Location"));
        this.locationLabel.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_SchemaPanel_Location"));
        this.browseButton.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_BrowseButton"));
        this.removeButton.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.locationPanel, -1, 582, Short.MAX_VALUE).add((Component)this.locationLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.browseButton).add(18, 18, 18).add((Component)this.removeButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationPanel, -2, 268, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.removeButton)).addContainerGap(82, Short.MAX_VALUE)));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_BrowseButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_RemoveButton"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"PROP_schema_panel_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"PROP_schema_panel_name"));
    }

    private boolean isDuplicate(String string) {
        if (this.rows.size() == 1) {
            return false;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            List list = (List)this.rows.get(i);
            SchemaObject schemaObject = (SchemaObject)list.get(1);
            if (schemaObject.toString().equals(startString) || !schemaObject.getSchemaFileName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void primarySchemaCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.schemaTable.getSelectedRow();
        this.deleteRow(n);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        this.gui = new SchemaImportGUI(this.templateWizard);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.gui, NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Browser"), true, (ActionListener)this);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription("DSC_Browser");
        dialog.setVisible(true);
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.locationLabel.setDisplayedMnemonic(util.getChar(SchemaPanel.class, "PROP_schema_locationLabel_mne"));
        this.browseButton.setMnemonic(util.getChar(SchemaPanel.class, "LBL_BrowseButton_mme"));
        this.removeButton.setMnemonic(util.getChar(SchemaPanel.class, "LBL_RemoveButton_mne"));
    }

    private void updatePossibilities() {
    }

    protected void initView() {
    }

    protected void updateModel() {
        int n = this.tableModel.getRowCount();
        int n2 = this.tableModel.getColumnCount();
        String string = null;
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (int i = 0; i < n; ++i) {
            List list = (List)this.rows.get(i);
            boolean bl = (Boolean)list.get(0);
            String string2 = (String)list.get(3);
            SchemaObject schemaObject = (SchemaObject)list.get(1);
            if (schemaObject.toString().equals(startString)) continue;
            schemaObject.setPrefix(string2);
            String string3 = (String)list.get(2);
            if (bl) {
                this.model.setPrimarySchema(schemaObject.toString());
                this.model.setNamespace(schemaObject.getNamespace());
                this.model.setPrefix(string2);
                this.model.setRoot(string3);
                File file = new File(schemaObject.toString());
                string = file.getName();
                if (string != null) {
                    string = string.replaceAll(" ", "%20");
                    try {
                        string = new URI(string).toASCIIString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.model.setSystemID(string == null || string.length() == 0 ? null : string);
            }
            arrayList.add(schemaObject);
        }
        this.model.setSchemaNodes(arrayList);
    }

    protected void updateView() {
    }

    private String getStartString() {
        return NbBundle.getMessage(SchemaPanel.class, (String)"LBL_TABLE_SCHEMA_PROMPT");
    }

    private void tableKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            int n = this.schemaTable.getSelectedRow();
            this.deleteRow(n);
        }
    }

    private void deleteRow(int n) {
        if (n != -1) {
            SchemaObject schemaObject = (SchemaObject)this.tableModel.getValueAt(n, 1);
            if (schemaObject.toString().equals(startString)) {
                return;
            }
            this.rows.remove(n);
            this.schemaTable.addNotify();
            this.fireChange();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
            List list = this.gui.getSelectedNodes();
            if (list != null) {
                String string = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_No_Root_Elements");
                for (int i = 0; i < list.size(); ++i) {
                    Object object;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    ExternalReferenceDataNode externalReferenceDataNode = (ExternalReferenceDataNode)((Object)list.get(i));
                    DataObject dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class);
                    if (this.isDuplicate(externalReferenceDataNode.getSchemaFileName())) continue;
                    FileObject fileObject = dataObject.getPrimaryFile();
                    SchemaObject schemaObject = new SchemaObject(externalReferenceDataNode.getSchemaFileName());
                    schemaObject.setNamespace(externalReferenceDataNode.getNamespace());
                    schemaObject.setSchemaFileName(externalReferenceDataNode.getSchemaFileName());
                    arrayList.add(false);
                    arrayList.add(schemaObject);
                    SchemaParser.SchemaInfo schemaInfo = SchemaParser.getRootElements(fileObject);
                    if (schemaInfo != null && schemaInfo.roots.size() > 0) {
                        object = schemaInfo.roots.iterator();
                        String[] stringArray = new String[schemaInfo.roots.size()];
                        schemaInfo.roots.toArray(stringArray);
                        schemaObject.setRootElements(stringArray);
                        arrayList.add(stringArray[0]);
                    } else {
                        arrayList.add(string);
                    }
                    object = this.generateUniquePrefix();
                    schemaObject.setPrefix((String)object);
                    arrayList.add(object);
                    this.tableModel.addRow(0, arrayList);
                }
                this.schemaTable.addNotify();
            }
        } else if (actionEvent.getSource().equals(DialogDescriptor.CANCEL_OPTION)) {
            this.gui.setVisible(false);
        }
    }

    private List createBlankElement(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Boolean(false));
        arrayList.add(new SchemaObject(string));
        arrayList.add(" ");
        arrayList.add(" ");
        return arrayList;
    }

    private void addRow(String string) {
        List list = this.createBlankElement(string);
        this.tableModel.addRow(list);
        this.schemaTable.addNotify();
    }

    private void initComp() {
        this.schemaTable.getModel().addTableModelListener(this);
        this.schemaTable.getTableHeader().setReorderingAllowed(false);
        startString = this.getStartString();
        this.schemaTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SchemaPanel.this.tableKeyPressed(keyEvent);
            }
        });
        this.addRow(startString);
        TableColumn tableColumn = null;
        for (int i = 0; i < 4; ++i) {
            tableColumn = this.schemaTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(40);
                continue;
            }
            if (i == 1) {
                tableColumn.setPreferredWidth(250);
                continue;
            }
            tableColumn.setPreferredWidth(80);
        }
        this.schemaTable.getColumnModel().getColumn(0).setCellRenderer(new RadioColumnRenderer());
        this.schemaTable.getColumnModel().getColumn(0).setCellEditor(new RadioColumnEditor());
        TableColumn tableColumn2 = this.schemaTable.getColumnModel().getColumn(2);
        tableColumn2.setCellEditor(new ComboBoxColumnEditor());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_COMBO_COL"));
        tableColumn2.setCellRenderer(defaultTableCellRenderer);
        int n = this.schemaTable.getRowHeight();
        for (int i = 0; i < this.schemaTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = this.schemaTable.getCellRenderer(0, i);
            Component component = this.schemaTable.prepareRenderer(tableCellRenderer, 0, i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
        }
        this.schemaTable.setRowHeight(n);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        AbstractTableModel abstractTableModel = (AbstractTableModel)tableModelEvent.getSource();
        Object object = abstractTableModel.getValueAt(n, n2);
        if (n2 == 1) {
            SchemaObject schemaObject = (SchemaObject)object;
            if (schemaObject.toString().equals(startString)) {
                return;
            }
            String string = (String)abstractTableModel.getValueAt(n, 3);
            if (string == null || string.equals(" ")) {
                String string2 = this.generateUniquePrefix();
                this.tableModel.setValueAt(string2, n, 3);
            }
            if (n == this.tableModel.getRowCount() - 1) {
                this.addRow(startString);
            }
            if (n == 0) {
                abstractTableModel.setValueAt(new Boolean(true), 0, 0);
            }
        }
    }

    private String generateUniquePrefix() {
        int n = 1;
        String string = PREFIX + n++;
        while (!this.isPrefixUnique(string)) {
            string = PREFIX + n++;
        }
        return string;
    }

    private boolean isPrefixUnique(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Object object = this.tableModel.getValueAt(i, 3);
            if (!(object instanceof String)) continue;
            hashSet.add((String)object);
        }
        return !hashSet.contains(string);
    }

    public boolean isPanelValid() {
        if (this.tableModel.getRowCount() == 1) {
            return false;
        }
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            List list = (List)this.rows.get(i);
            boolean bl = (Boolean)list.get(0);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    class ComboBoxColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox comboBox;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String[] stringArray;
            this.comboBox = new JComboBox();
            this.comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ComboBoxColumnEditor.this.fireEditingStopped();
                }
            });
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            SchemaObject schemaObject = (SchemaObject)jTable.getModel().getValueAt(n, 1);
            if (!schemaObject.toString().equals(startString) && (stringArray = schemaObject.getRootElements()) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultComboBoxModel.addElement(stringArray[i]);
                }
            }
            this.comboBox.setModel(defaultComboBoxModel);
            return this.comboBox;
        }

        public Object getCellEditorValue() {
            return this.comboBox.getModel().getSelectedItem();
        }
    }

    class RadioColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JRadioButton theRadioButton = new JRadioButton();

        public RadioColumnEditor() {
            this.theRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RadioColumnEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.theRadioButton.setHorizontalAlignment(0);
            if (object != null) {
                Boolean bl2 = (Boolean)object;
                this.theRadioButton.setSelected(bl2);
            }
            return this.theRadioButton;
        }

        public Object getCellEditorValue() {
            return new Boolean(this.theRadioButton.isSelected());
        }
    }

    class RadioColumnRenderer
    extends JRadioButton
    implements TableCellRenderer {
        RadioColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(Color.WHITE);
            if (object == null) {
                this.setSelected(false);
            } else {
                Boolean bl3 = (Boolean)object;
                this.setSelected(bl3);
            }
            this.setHorizontalAlignment(0);
            this.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_PREFIX_COL"));
            return this;
        }
    }

    class SchemaTableModel
    extends AbstractTableModel {
        SchemaTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return SchemaPanel.this.rows.size();
        }

        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_PRIMARY_COL");
                    break;
                }
                case 1: {
                    string = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_SCHEMA_COL");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_ROOT_COL");
                    break;
                }
                case 3: {
                    string = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_PREIFX_COL");
                }
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            List list = (List)SchemaPanel.this.rows.elementAt(n);
            if (n2 == 1) {
                SchemaObject schemaObject = (SchemaObject)list.get(n2);
                return schemaObject;
            }
            return list.get(n2);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return true;
            }
            if (n2 == 0) {
                SchemaObject schemaObject = (SchemaObject)this.getValueAt(n, 1);
                return !schemaObject.toString().equals(startString);
            }
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < 0 || n2 < 0 || n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                return;
            }
            if (object == null) {
                return;
            }
            List list = (List)SchemaPanel.this.rows.elementAt(n);
            if (n2 == 0 && ((Boolean)object).booleanValue()) {
                SchemaObject schemaObject = (SchemaObject)this.getValueAt(n, 1);
                if (schemaObject.getRootElements() == null || schemaObject.getRootElements().length == 0) {
                    String string = NbBundle.getMessage(SchemaPanel.class, (String)"MSG_SchemaPanel_Incorrect_Primary");
                    SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)string);
                    return;
                }
                SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)"");
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (i == n) continue;
                    this.setValueAt(new Boolean(false), i, 0);
                }
                list.set(n2, object);
            } else if (n2 == 1) {
                Object object2;
                Object object3;
                String string = (String)object;
                if (string.equals(startString)) {
                    return;
                }
                try {
                    object3 = new File(string);
                    if (!((File)object3).exists() && !string.startsWith("http")) {
                        return;
                    }
                    object2 = SchemaPanel.this.model.getTargetFolderURL();
                    if (object2 != null) {
                        string = new URL((URL)object2, string).toExternalForm();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    return;
                }
                object3 = new SchemaParser();
                object2 = ((SchemaParser)object3).parse(string);
                SchemaObject schemaObject = new SchemaObject((String)object);
                if (((SchemaParser.SchemaInfo)object2).namespace != null) {
                    schemaObject.setNamespace(((SchemaParser.SchemaInfo)object2).namespace);
                }
                if (object2 != null && ((SchemaParser.SchemaInfo)object2).roots.size() > 0) {
                    Iterator iterator = ((SchemaParser.SchemaInfo)object2).roots.iterator();
                    String[] stringArray = new String[((SchemaParser.SchemaInfo)object2).roots.size()];
                    ((SchemaParser.SchemaInfo)object2).roots.toArray(stringArray);
                    schemaObject.setRootElements(stringArray);
                    list.set(2, stringArray[0]);
                }
                schemaObject.setSchemaFileName((String)object);
                list.set(n2, schemaObject);
            } else if (n2 == 3) {
                String string = ((String)object).trim();
                if (SchemaPanel.this.isPrefixUnique(string)) {
                    list.set(n2, string);
                }
            } else {
                list.set(n2, object);
            }
            SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)"");
            SchemaPanel.this.fireChange();
            this.fireTableCellUpdated(n, n2);
        }

        private void addRow(List list) {
            SchemaPanel.this.rows.add(list);
        }

        private void addRow(int n, List list) {
            SchemaPanel.this.rows.add(n, list);
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

