/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BooleanUtils {
    public static Boolean negate(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean isNotTrue(Boolean bl) {
        return !BooleanUtils.isTrue(bl);
    }

    public static boolean isFalse(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl == false;
    }

    public static boolean isNotFalse(Boolean bl) {
        return !BooleanUtils.isFalse(bl);
    }

    public static Boolean toBooleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean toBoolean(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl != false;
    }

    public static boolean toBoolean(int n) {
        return n != 0;
    }

    public static Boolean toBooleanObject(int n) {
        return n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Boolean toBooleanObject(Integer n) {
        if (n == null) {
            return null;
        }
        return n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean toBoolean(int n, int n2, int n3) {
        if (n == n2) {
            return true;
        }
        if (n == n3) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Integer n, Integer n2, Integer n3) {
        if (n == null) {
            if (n2 == null) {
                return true;
            }
            if (n3 == null) {
                return false;
            }
        } else {
            if (n.equals(n2)) {
                return true;
            }
            if (n.equals(n3)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static Boolean toBooleanObject(int n, int n2, int n3, int n4) {
        if (n == n2) {
            return Boolean.TRUE;
        }
        if (n == n3) {
            return Boolean.FALSE;
        }
        if (n == n4) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer n, Integer n2, Integer n3, Integer n4) {
        if (n == null) {
            if (n2 == null) {
                return Boolean.TRUE;
            }
            if (n3 == null) {
                return Boolean.FALSE;
            }
            if (n4 == null) {
                return null;
            }
        } else {
            if (n.equals(n2)) {
                return Boolean.TRUE;
            }
            if (n.equals(n3)) {
                return Boolean.FALSE;
            }
            if (n.equals(n4)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static int toInteger(boolean bl) {
        return bl ? 1 : 0;
    }

    public static Integer toIntegerObject(boolean bl) {
        return bl ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static Integer toIntegerObject(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static int toInteger(boolean bl, int n, int n2) {
        return bl ? n : n2;
    }

    public static int toInteger(Boolean bl, int n, int n2, int n3) {
        if (bl == null) {
            return n3;
        }
        return bl != false ? n : n2;
    }

    public static Integer toIntegerObject(boolean bl, Integer n, Integer n2) {
        return bl ? n : n2;
    }

    public static Integer toIntegerObject(Boolean bl, Integer n, Integer n2, Integer n3) {
        if (bl == null) {
            return n3;
        }
        return bl != false ? n : n2;
    }

    public static Boolean toBooleanObject(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("on".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("off".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("yes".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean toBooleanObject(String string, String string2, String string3, String string4) {
        if (string == null) {
            if (string2 == null) {
                return Boolean.TRUE;
            }
            if (string3 == null) {
                return Boolean.FALSE;
            }
            if (string4 == null) {
                return null;
            }
        } else {
            if (string.equals(string2)) {
                return Boolean.TRUE;
            }
            if (string.equals(string3)) {
                return Boolean.FALSE;
            }
            if (string.equals(string4)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static boolean toBoolean(String string) {
        if (string == "true") {
            return true;
        }
        if (string == null) {
            return false;
        }
        switch (string.length()) {
            case 2: {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                return !(c != 'o' && c != 'O' || c2 != 'n' && c2 != 'N');
            }
            case 3: {
                char c = string.charAt(0);
                if (c == 'y') {
                    return !(string.charAt(1) != 'e' && string.charAt(1) != 'E' || string.charAt(2) != 's' && string.charAt(2) != 'S');
                }
                if (c == 'Y') {
                    return !(string.charAt(1) != 'E' && string.charAt(1) != 'e' || string.charAt(2) != 'S' && string.charAt(2) != 's');
                }
                return false;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 't') {
                    return !(string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
                }
                if (c != 'T') break;
                return !(string.charAt(1) != 'R' && string.charAt(1) != 'r' || string.charAt(2) != 'U' && string.charAt(2) != 'u' || string.charAt(3) != 'E' && string.charAt(3) != 'e');
            }
        }
        return false;
    }

    public static boolean toBoolean(String string, String string2, String string3) {
        if (string == null) {
            if (string2 == null) {
                return true;
            }
            if (string3 == null) {
                return false;
            }
        } else {
            if (string.equals(string2)) {
                return true;
            }
            if (string.equals(string3)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static String toStringTrueFalse(Boolean bl) {
        return BooleanUtils.toString(bl, "true", "false", null);
    }

    public static String toStringOnOff(Boolean bl) {
        return BooleanUtils.toString(bl, "on", "off", null);
    }

    public static String toStringYesNo(Boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no", null);
    }

    public static String toString(Boolean bl, String string, String string2, String string3) {
        if (bl == null) {
            return string3;
        }
        return bl != false ? string : string2;
    }

    public static String toStringTrueFalse(boolean bl) {
        return BooleanUtils.toString(bl, "true", "false");
    }

    public static String toStringOnOff(boolean bl) {
        return BooleanUtils.toString(bl, "on", "off");
    }

    public static String toStringYesNo(boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no");
    }

    public static String toString(boolean bl, String string, String string2) {
        return bl ? string : string2;
    }

    public static boolean xor(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            if (n < 1) {
                ++n;
                continue;
            }
            return false;
        }
        return n == 1;
    }

    public static Boolean xor(Boolean[] booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean[] blArray = null;
        try {
            blArray = ArrayUtils.toPrimitive(booleanArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
        return BooleanUtils.xor(blArray) ? Boolean.TRUE : Boolean.FALSE;
    }
}

