/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXPanel;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewTablePanel
extends JXPanel {
    private final DataViewTableUI tableUI;
    private DataViewUI dataViewUI;
    private DataView dataView;
    private boolean isDirty = false;
    private UpdatedRowContext updatedRowCtx;
    private JXTableRowHeader rowHeader;
    private boolean editable;

    public DataViewTablePanel(DataView dataView, DataViewUI dataViewUI, DataViewActionHandler dataViewActionHandler) {
        this.setLayout(new BorderLayout());
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.tableUI = new DataViewTableUI(this, dataViewActionHandler, dataView);
        this.updatedRowCtx = new UpdatedRowContext();
        this.rowHeader = new JXTableRowHeader((JTable)((Object)this.tableUI));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tableUI));
        jScrollPane.setRowHeaderView(this.rowHeader);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", this.rowHeader.getTableHeader());
        this.add(jScrollPane, "Center");
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    protected boolean isEditable() {
        return this.editable;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        if (!this.isDirty) {
            this.updatedRowCtx.removeAllUpdates();
        }
    }

    DataViewTableUI getDataViewTableUI() {
        return this.tableUI;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.updatedRowCtx;
    }

    boolean isCommitEnabled() {
        return this.dataViewUI.isCommitEnabled();
    }

    public void createTableModel(List<Object[]> list) {
        this.setDirty(false);
        this.tableUI.createTableModel(list, this.rowHeader);
    }

    void handleColumnUpdated() {
        this.isDirty = true;
        this.dataViewUI.setCommitEnabled(true);
        this.dataViewUI.setCancelEnabled(true);
    }

    List<Object[]> getPageDataFromTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.tableUI.getModel();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = defaultTableModel.getColumnCount();
        for (Vector vector : defaultTableModel.getDataVector()) {
            Object[] objectArray = new Object[n];
            int n2 = 0;
            for (Object e : vector) {
                objectArray[n2++] = e;
            }
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public void enableDeleteBtn(boolean bl) {
        this.dataViewUI.enableDeleteBtn(bl);
    }

    void setValueAt(Object object, int n, int n2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.tableUI.getModel();
        defaultTableModel.setValueAt(object, n, n2);
    }
}

