/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewTablePanel;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.ShowSQLDialog;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

class DataViewTableUI
extends ResultSetJXTable {
    private JPopupMenu tablePopupMenu;
    private final DataViewTablePanel tablePanel;
    private DataViewActionHandler handler;
    private int selectedRow = -1;
    private int selectedColumn = -1;

    public DataViewTableUI(DataViewTablePanel dataViewTablePanel, DataViewActionHandler dataViewActionHandler, DataView dataView) {
        super(dataView);
        this.tablePanel = dataViewTablePanel;
        this.handler = dataViewActionHandler;
        TableSelectionListener tableSelectionListener = new TableSelectionListener((JTable)((Object)this));
        this.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.addKeyListener(this.createControKeyListener());
        this.createPopupMenu(dataViewActionHandler, dataView);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.dView.getUpdatedRowContext().hasUpdates(n, n2)) {
            return new UpdatedResultSetCellRenderer(this.dView);
        }
        return super.getCellRenderer(n, n2);
    }

    protected KeyListener createControKeyListener() {
        return new Control0KeyListener();
    }

    protected DefaultTableModel getDefaultTableModel() {
        return new DataViewTableUIModel(this);
    }

    private void createPopupMenu(final DataViewActionHandler dataViewActionHandler, final DataView dataView) {
        this.tablePopupMenu = new JPopupMenu();
        final JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_insert"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.insertActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_deleterow"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.deleteRecordActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_commit"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.commitActionPerformed(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem3);
        final JMenuItem jMenuItem4 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_cancel_edits"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.cancelEditPerformed(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem4);
        final JMenuItem jMenuItem5 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_truncate_table"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.truncateActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem5);
        this.tablePopupMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_cell_value"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = DataViewTableUI.this.getValueAt(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn);
                    String string = object != null ? object.toString() : "";
                    ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    StringSelection stringSelection = new StringSelection(string);
                    exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_value"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataViewTableUI.this.copyRowValues(false);
            }
        });
        this.tablePopupMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_header"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataViewTableUI.this.copyRowValues(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem8);
        this.tablePopupMenu.addSeparator();
        final JMenuItem jMenuItem9 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_create_sql"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DBTable dBTable = dataView.getDataViewDBTable().geTable(0);
                    String string = dataView.getSQLStatementGenerator().generateCreateStatement(dBTable);
                    ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                    showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    showSQLDialog.setText(string + ";\n");
                    showSQLDialog.setVisible(true);
                }
                catch (Exception exception) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem9);
        final JMenuItem jMenuItem10 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_insert_sql"));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray = DataViewTableUI.this.getSelectedRows();
                    String string = "";
                    for (int i = 0; i < nArray.length; ++i) {
                        Object[] objectArray = dataView.getDataViewPageContext().getCurrentRows().get(nArray[i]);
                        String string2 = dataView.getSQLStatementGenerator().generateRawInsertStatement(objectArray);
                        string = string + string2.replaceAll("\n", "").replaceAll("\t", "") + ";\n";
                    }
                    ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                    showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    showSQLDialog.setText(string);
                    showSQLDialog.setVisible(true);
                }
                catch (DBException dBException) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)dBException.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem10);
        final JMenuItem jMenuItem11 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_delete_sql"));
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DataViewTableUI.this.getSelectedRows();
                String string = "";
                for (int i = 0; i < nArray.length; ++i) {
                    SQLStatementGenerator sQLStatementGenerator = dataView.getSQLStatementGenerator();
                    String string2 = sQLStatementGenerator.generateDeleteStatement(nArray[i], DataViewTableUI.this.getModel());
                    string = string + string2 + ";\n";
                }
                ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                showSQLDialog.setText(string);
                showSQLDialog.setVisible(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem11);
        final JMenuItem jMenuItem12 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_update_sql"));
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                UpdatedRowContext updatedRowContext = dataView.getUpdatedRowContext();
                SQLStatementGenerator sQLStatementGenerator = dataView.getSQLStatementGenerator();
                try {
                    for (Integer n : updatedRowContext.getUpdateKeys()) {
                        Map<Integer, Object> map = updatedRowContext.getChangedData(n);
                        string = string + sQLStatementGenerator.generateUpdateStatement(n, map, DataViewTableUI.this.dataModel) + ";\n";
                    }
                    ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                    showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    showSQLDialog.setText(string);
                    showSQLDialog.setVisible(true);
                }
                catch (DBException dBException) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)dBException.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem12);
        this.tablePopupMenu.addSeparator();
        JMenuItem jMenuItem13 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_print_data"));
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Logger logger = Logger.getLogger(DataViewTableUI.class.getName());
                try {
                    if (!DataViewTableUI.this.print()) {
                        logger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)"MSG_cancel_printing"));
                    }
                }
                catch (PrinterException printerException) {
                    logger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)("MSG_failure_to_print" + printerException.getMessage())));
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_refresh"));
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.refreshActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem14);
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    DataViewTableUI.this.selectedRow = DataViewTableUI.this.rowAtPoint(mouseEvent.getPoint());
                    DataViewTableUI.this.selectedColumn = DataViewTableUI.this.columnAtPoint(mouseEvent.getPoint());
                    boolean bl = false;
                    int[] nArray = DataViewTableUI.this.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != DataViewTableUI.this.selectedRow) continue;
                        bl = true;
                        break;
                    }
                    if (!DataViewTableUI.this.getRowSelectionAllowed()) {
                        bl = false;
                        int[] nArray2 = DataViewTableUI.this.getSelectedColumns();
                        for (int i = 0; i < nArray2.length; ++i) {
                            if (nArray2[i] != DataViewTableUI.this.selectedColumn) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        DataViewTableUI.this.changeSelection(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn, false, false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isEditable()) {
                        jMenuItem.setEnabled(false);
                        jMenuItem2.setEnabled(false);
                        jMenuItem5.setEnabled(false);
                        jMenuItem10.setEnabled(false);
                        jMenuItem9.setEnabled(false);
                        jMenuItem11.setEnabled(false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isCommitEnabled()) {
                        jMenuItem3.setEnabled(false);
                        jMenuItem4.setEnabled(false);
                        jMenuItem12.setEnabled(false);
                    } else {
                        jMenuItem3.setEnabled(true);
                        jMenuItem4.setEnabled(true);
                        jMenuItem12.setEnabled(true);
                    }
                    DataViewTableUI.this.tablePopupMenu.show((Component)((Object)DataViewTableUI.this), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void copyRowValues(boolean bl) {
        try {
            int[] nArray;
            int[] nArray2 = this.getSelectedRows();
            if (this.getRowSelectionAllowed()) {
                nArray = new int[this.getColumnCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
            } else {
                nArray = this.getSelectedColumns();
            }
            if (nArray2 != null && nArray != null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl) {
                    for (n = 0; n < nArray.length; ++n) {
                        Object object;
                        if (n > 0) {
                            stringBuffer.append('\t');
                        }
                        stringBuffer.append((object = this.getColumnModel().getColumn(n).getHeaderValue()) != null ? object.toString() : "");
                    }
                    stringBuffer.append('\n');
                }
                for (n = 0; n < nArray2.length; ++n) {
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object;
                        if (i > 0) {
                            stringBuffer.append('\t');
                        }
                        stringBuffer.append((object = this.getValueAt(nArray2[n], nArray[i])) != null ? object.toString() : "");
                    }
                    stringBuffer.append('\n');
                }
                ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Exceptions.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private class Control0KeyListener
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 127) {
                TableCellEditor tableCellEditor = DataViewTableUI.this.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                DataViewTableUI.this.handler.deleteRecordActionPerformed();
            } else if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '0') {
                int n = DataViewTableUI.this.getSelectedRow();
                int n2 = DataViewTableUI.this.getSelectedColumn();
                if (n == -1) {
                    return;
                }
                DataViewTableUI.this.editCellAt(n, n2);
                TableCellEditor tableCellEditor = DataViewTableUI.this.getCellEditor();
                if (tableCellEditor != null) {
                    DBColumn dBColumn = DataViewTableUI.this.getDBColumn(n2);
                    if (dBColumn.isGenerated() || !dBColumn.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                        tableCellEditor.stopCellEditing();
                    } else {
                        tableCellEditor.getTableCellEditorComponent((JTable)((Object)DataViewTableUI.this), null, DataViewTableUI.this.rowSelectionAllowed, n, n2);
                        DataViewTableUI.this.setValueAt(null, n, n2);
                        tableCellEditor.stopCellEditing();
                    }
                    DataViewTableUI.this.setRowSelectionInterval(n, n);
                }
            } else if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '1') {
                int n = DataViewTableUI.this.getSelectedRow();
                int n3 = DataViewTableUI.this.getSelectedColumn();
                if (n == -1) {
                    return;
                }
                DataViewTableUI.this.editCellAt(n, n3);
                TableCellEditor tableCellEditor = DataViewTableUI.this.getCellEditor();
                if (tableCellEditor != null) {
                    DBColumn dBColumn = DataViewTableUI.this.getDBColumn(n3);
                    Object object = DataViewTableUI.this.getValueAt(n, n3);
                    if (dBColumn.isGenerated() || !dBColumn.hasDefault()) {
                        Toolkit.getDefaultToolkit().beep();
                        tableCellEditor.stopCellEditing();
                    } else if (object != null && object instanceof String && ((String)object).equals("<DEFAULT>")) {
                        tableCellEditor.getTableCellEditorComponent((JTable)((Object)DataViewTableUI.this), "", DataViewTableUI.this.rowSelectionAllowed, n, n3);
                        DataViewTableUI.this.setValueAt(null, n, n3);
                        tableCellEditor.stopCellEditing();
                    } else {
                        tableCellEditor.getTableCellEditorComponent((JTable)((Object)DataViewTableUI.this), "<DEFAULT>", DataViewTableUI.this.rowSelectionAllowed, n, n3);
                        DataViewTableUI.this.setValueAt("<DEFAULT>", n, n3);
                        tableCellEditor.stopCellEditing();
                    }
                    DataViewTableUI.this.setRowSelectionInterval(n, n);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class DataViewTableUIModel
    extends ResultSetTableModel {
        protected DataViewTableUIModel(ResultSetJXTable resultSetJXTable) {
            super(resultSetJXTable);
        }

        protected void handleColumnUpdated(int n, int n2, Object object) {
            DataViewTableUI.this.dView.getUpdatedRowContext().addUpdates(n, n2, object, DataViewTableUI.this.getModel());
            DataViewTableUI.this.tablePanel.handleColumnUpdated();
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (DataViewTableUI.this.tablePanel == null) {
                return;
            }
            if (listSelectionEvent.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int n = listSelectionEvent.getFirstIndex();
                if (n >= 0 && DataViewTableUI.this.tablePanel.isEditable()) {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(true);
                } else {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(false);
                }
            }
        }
    }

    private static class UpdatedResultSetCellRenderer
    extends ResultSetCellRenderer {
        static Color green = new Color(0, 128, 0);
        static Color gray = new Color(245, 245, 245);
        DataView dataView;

        public UpdatedResultSetCellRenderer(DataView dataView) {
            this.dataView = dataView;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object object2 = this.dataView.getDataViewPageContext().getColumnData(n, n2);
            if (object == null) {
                return component;
            }
            if (bl) {
                if (object2 != null && object.equals(object2)) {
                    component.setForeground(gray);
                } else {
                    component.setForeground(Color.ORANGE);
                }
            } else if (object2 != null && object.equals(object2)) {
                component.setForeground(jTable.getForeground());
            } else {
                component.setForeground(green);
            }
            return component;
        }
    }
}

