/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public class JXTableDecorator
extends JXTable {
    public static final Color ALTERNATE_ROW_COLOR = new Color(0.92f, 0.95f, 0.99f);
    public static final Color GRID_COLOR = new Color(0xD9D9D9);
    public static final Color ROLLOVER_ROW_COLOR = new Color(0.94f, 0.96f, 0.96f);

    JXTableDecorator() {
    }

    public JXTableDecorator(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintEmptyRows(graphics);
    }

    protected void paintEmptyRows(Graphics graphics) {
        int n = this.getRowCount();
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.y + rectangle.height;
        if (n * this.rowHeight < n2) {
            for (int i = n; i <= n2 / this.rowHeight; ++i) {
                graphics.setColor(this.backgroundColorForRow(i));
                graphics.fillRect(rectangle.x, i * this.rowHeight, rectangle.width, this.rowHeight);
                this.drawHorizontalLine(graphics, rectangle, i);
            }
            this.drawVerticalLines(graphics, n, n2);
        }
    }

    protected void drawHorizontalLine(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(ResultSetJXTable.GRID_COLOR);
        graphics.drawLine(rectangle.x, n * this.rowHeight - 1, rectangle.x + rectangle.width, n * this.rowHeight - 1);
    }

    protected void drawVerticalLines(Graphics graphics, int n, int n2) {
        graphics.setColor(ResultSetJXTable.GRID_COLOR);
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n3 = 0;
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            graphics.drawLine((n3 += tableColumn.getWidth()) - 1, n * this.rowHeight, n3 - 1, n2);
        }
    }

    protected Color backgroundColorForRow(int n) {
        return n % 2 == 0 ? Color.WHITE : ResultSetJXTable.ALTERNATE_ROW_COLOR;
    }
}

