/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextManager {
    private static final Map<LookupRef, Reference<ContextManager>> CACHE = new HashMap<LookupRef, Reference<ContextManager>>();
    private static final Map<LookupRef, Reference<ContextManager>> SURVIVE = new HashMap<LookupRef, Reference<ContextManager>>();
    private Map<Class, LSet> listeners = new HashMap<Class, LSet>();
    private Lookup lookup;
    private LSet<Lookup.Provider> selectionAll;

    private ContextManager(Lookup lookup) {
        this.lookup = lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextManager findManager(Lookup lookup, boolean bl) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            ContextManager contextManager;
            Map<LookupRef, Reference<ContextManager>> map2 = bl ? SURVIVE : CACHE;
            LookupRef lookupRef = new LookupRef(lookup);
            GMReference gMReference = map2.get(lookupRef);
            ContextManager contextManager2 = contextManager = gMReference == null ? null : gMReference.get();
            if (contextManager == null) {
                contextManager = bl ? new SurviveManager(lookup) : new ContextManager(lookup);
                gMReference = new GMReference(contextManager, lookupRef, bl);
                map2.put(lookupRef, gMReference);
            }
            return contextManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(LookupRef lookupRef, GMReference gMReference, boolean bl) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            Map<LookupRef, Reference<ContextManager>> map2;
            Map<LookupRef, Reference<ContextManager>> map3 = map2 = bl ? SURVIVE : CACHE;
            if (map2.get(lookupRef) == gMReference) {
                map2.remove(lookupRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerListener(Class<T> clazz, ContextAction<T> contextAction) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            LSet<T> lSet = this.findLSet(clazz);
            if (lSet == null) {
                lSet = new LSet<T>(this.lookup, clazz);
                this.listeners.put(clazz, lSet);
            }
            lSet.add(contextAction);
            if (contextAction.selectMode == ContextSelection.ALL) {
                if (this.selectionAll == null) {
                    this.selectionAll = new LSet<Lookup.Provider>(this.lookup, Lookup.Provider.class);
                }
                this.selectionAll.add(contextAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterListener(Class<T> clazz, ContextAction<T> contextAction) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            LSet<T> lSet = this.findLSet(clazz);
            if (lSet != null) {
                lSet.remove(contextAction);
                if (lSet.isEmpty()) {
                    this.listeners.remove(clazz);
                }
            }
            if (contextAction.selectMode == ContextSelection.ALL && this.selectionAll != null) {
                this.selectionAll.remove(contextAction);
                if (this.selectionAll.isEmpty()) {
                    this.selectionAll = null;
                }
            }
        }
    }

    public boolean isSurvive() {
        return false;
    }

    public <T> boolean isEnabled(Class<T> clazz, ContextSelection contextSelection, ContextAction.Performer<? super T> performer) {
        Lookup.Result<T> result = this.findResult(clazz);
        boolean bl = this.isEnabledOnData(result, clazz, contextSelection);
        if (bl && performer != null) {
            bl = performer.enabled(this.listFromResult(result));
        }
        return bl;
    }

    private <T> boolean isEnabledOnData(Lookup.Result<T> result, Class<T> clazz, ContextSelection contextSelection) {
        switch (contextSelection) {
            case EXACTLY_ONE: {
                HashSet hashSet = new HashSet(result.allItems());
                return hashSet.size() == 1;
            }
            case ANY: {
                return !result.allItems().isEmpty();
            }
            case EACH: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result result2 = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() != result2.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(clazz);
                for (Lookup.Provider provider : result2.allInstances()) {
                    if (provider.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
            case ALL: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result result3 = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() < result3.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(clazz);
                for (Lookup.Provider provider : result3.allInstances()) {
                    if (provider.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> LSet<T> findLSet(Class<T> clazz) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            return this.listeners.get(clazz);
        }
    }

    private <T> Lookup.Result<T> findResult(Class<T> clazz) {
        LSet<T> lSet = this.findLSet(clazz);
        Lookup.Result result = lSet != null ? lSet.result : this.lookup.lookupResult(clazz);
        return result;
    }

    public <T> void actionPerformed(ActionEvent actionEvent, ContextAction.Performer<? super T> performer, final Class<T> clazz, ContextSelection contextSelection) {
        Lookup.Result<T> result = this.findResult(clazz);
        final List<T> list = this.listFromResult(result);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LkpAE
        implements Lookup.Provider {
            private Lookup lookup;

            LkpAE() {
            }

            public Lookup getLookup() {
                if (this.lookup == null) {
                    this.lookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])list.toArray()), Lookups.exclude((Lookup)ContextManager.this.lookup, (Class[])new Class[]{clazz})});
                }
                return this.lookup;
            }
        }
        performer.actionPerformed(actionEvent, Collections.unmodifiableList(list), new LkpAE());
    }

    private <T> List<? extends T> listFromResult(Lookup.Result<T> result) {
        ArrayList arrayList;
        Collection collection = result.allInstances();
        if (collection instanceof List) {
            arrayList = (ArrayList)collection;
        } else {
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(collection);
            arrayList = arrayList2;
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GMReference
    extends WeakReference<ContextManager>
    implements Runnable {
        private LookupRef context;
        private boolean survive;

        public GMReference(ContextManager contextManager, LookupRef lookupRef, boolean bl) {
            super(contextManager, Utilities.activeReferenceQueue());
            this.context = lookupRef;
            this.survive = bl;
        }

        @Override
        public void run() {
            ContextManager.clearCache(this.context, this, this.survive);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LSet<T>
    extends WeakSet<ContextAction>
    implements LookupListener,
    Runnable {
        final Lookup.Result<T> result;

        public LSet(Lookup lookup, Class<T> clazz) {
            this.result = lookup.lookupResult(clazz);
            this.result.addLookupListener((LookupListener)this);
            this.result.allItems();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Mutex.EVENT.readAccess((Runnable)this);
        }

        @Override
        public void run() {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContextAction contextAction = (ContextAction)iterator.next();
                contextAction.updateState();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LookupRef
    extends WeakReference<Lookup> {
        private final int hashCode;

        public LookupRef(Lookup lookup) {
            super(lookup);
            this.hashCode = System.identityHashCode(lookup);
        }

        public boolean equals(Object object) {
            if (object instanceof LookupRef) {
                LookupRef lookupRef = (LookupRef)object;
                return this.get() == lookupRef.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class SurviveManager
    extends ContextManager {
        private SurviveManager(Lookup lookup) {
            super(lookup);
        }

        public boolean isSurvive() {
            return true;
        }
    }
}

