/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.openide.awt.ContextManager;
import org.openide.awt.GeneralAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

class GlobalManager
implements LookupListener {
    private static Logger LOG = GeneralAction.LOG;
    private static final Map<ContextManager.LookupRef, Reference<GlobalManager>> CACHE = new HashMap<ContextManager.LookupRef, Reference<GlobalManager>>();
    private static final Map<ContextManager.LookupRef, Reference<GlobalManager>> SURVIVE = new HashMap<ContextManager.LookupRef, Reference<GlobalManager>>();
    private Lookup.Result<ActionMap> result;
    private Reference<ActionMap> actionMap = new WeakReference<Object>(null);
    private Map<Object, Set<GeneralAction.DelegateAction>> listeners = new HashMap<Object, Set<GeneralAction.DelegateAction>>();
    private PropertyChangeListener changeL;

    private GlobalManager(Lookup lookup) {
        this.result = lookup.lookupResult(ActionMap.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalManager findManager(Lookup lookup, boolean bl) {
        Map<ContextManager.LookupRef, Reference<GlobalManager>> map = CACHE;
        synchronized (map) {
            GlobalManager globalManager;
            Map<ContextManager.LookupRef, Reference<GlobalManager>> map2 = bl ? SURVIVE : CACHE;
            ContextManager.LookupRef lookupRef = new ContextManager.LookupRef(lookup);
            GMReference gMReference = map2.get(lookupRef);
            GlobalManager globalManager2 = globalManager = gMReference == null ? null : gMReference.get();
            if (globalManager == null) {
                globalManager = bl ? new SurviveManager(lookup) : new GlobalManager(lookup);
                gMReference = new GMReference(globalManager, lookupRef, bl);
                map2.put(lookupRef, gMReference);
            }
            return globalManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(ContextManager.LookupRef lookupRef, GMReference gMReference, boolean bl) {
        Map<ContextManager.LookupRef, Reference<GlobalManager>> map = CACHE;
        synchronized (map) {
            Map<ContextManager.LookupRef, Reference<GlobalManager>> map2;
            Map<ContextManager.LookupRef, Reference<GlobalManager>> map3 = map2 = bl ? SURVIVE : CACHE;
            if (map2.get(lookupRef) == gMReference) {
                map2.remove(lookupRef);
            }
        }
    }

    public Action findGlobalAction(Object object) {
        Action action;
        if (object == null) {
            return null;
        }
        ActionMap actionMap = this.actionMap.get();
        Action action2 = action = actionMap == null ? null : actionMap.get(object);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action for key: " + object + " is: " + action);
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(Object object, GeneralAction.DelegateAction delegateAction) {
        if (object == null) {
            return;
        }
        Map<ContextManager.LookupRef, Reference<GlobalManager>> map = CACHE;
        synchronized (map) {
            WeakSet weakSet = this.listeners.get(object);
            if (weakSet == null) {
                weakSet = new WeakSet();
                this.listeners.put(object, (Set<GeneralAction.DelegateAction>)weakSet);
            }
            weakSet.add((GeneralAction.DelegateAction)delegateAction);
            delegateAction.updateState(new ActionMap(), this.actionMap.get(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterListener(Object object, GeneralAction.DelegateAction delegateAction) {
        if (object == null) {
            return;
        }
        Map<ContextManager.LookupRef, Reference<GlobalManager>> map = CACHE;
        synchronized (map) {
            Set<GeneralAction.DelegateAction> set = this.listeners.get(object);
            if (set != null) {
                set.remove(delegateAction);
                if (set.isEmpty()) {
                    this.listeners.remove(object);
                }
            }
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        ActionMap actionMap;
        ActionMap actionMap2;
        Collection collection = this.result.allItems();
        ActionMap actionMap3 = actionMap2 = collection.isEmpty() ? null : (ActionMap)((Lookup.Item)collection.iterator().next()).getInstance();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("changed map : " + actionMap2);
            LOG.fine("previous map: " + this.actionMap.get());
        }
        if (actionMap2 == (actionMap = this.actionMap.get())) {
            return;
        }
        final ActionMap actionMap4 = this.newMap(actionMap, actionMap2);
        this.actionMap = new WeakReference<ActionMap>(actionMap2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("clearActionPerformers");
        }
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                GlobalManager.this.notifyListeners(actionMap, actionMap4);
            }
        });
    }

    final void notifyListeners(ActionMap actionMap, ActionMap actionMap2) {
        if (actionMap == null) {
            actionMap = new ActionMap();
        }
        if (actionMap2 == null) {
            actionMap2 = new ActionMap();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray = actionMap.allKeys();
        Object[] objectArray2 = actionMap2.allKeys();
        if (objectArray != null) {
            hashSet.addAll(Arrays.asList(objectArray));
        }
        if (objectArray2 != null) {
            hashSet.addAll(Arrays.asList(objectArray2));
        }
        for (Object e : hashSet) {
            Set<GeneralAction.DelegateAction> set = this.listeners.get(e);
            if (set == null) continue;
            for (GeneralAction.DelegateAction delegateAction : set) {
                if (delegateAction == null) continue;
                delegateAction.updateState(actionMap, actionMap2, true);
            }
        }
    }

    public boolean isSurvive() {
        return false;
    }

    protected ActionMap newMap(ActionMap actionMap, ActionMap actionMap2) {
        return actionMap2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GMReference
    extends WeakReference<GlobalManager>
    implements Runnable {
        private ContextManager.LookupRef context;
        private boolean survive;

        public GMReference(GlobalManager globalManager, ContextManager.LookupRef lookupRef, boolean bl) {
            super(globalManager, Utilities.activeReferenceQueue());
            this.context = lookupRef;
            this.survive = bl;
        }

        @Override
        public void run() {
            GlobalManager.clearCache(this.context, this, this.survive);
        }
    }

    private static final class SurviveManager
    extends GlobalManager {
        private SurviveManager(Lookup lookup) {
            super(lookup);
        }

        public boolean isSurvive() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        protected ActionMap newMap(ActionMap actionMap, ActionMap actionMap2) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (actionMap != null && (object2 = actionMap.allKeys()) != null) {
                arrayList.addAll(Arrays.asList(object2));
                if (actionMap2 != null) {
                    arrayList.removeAll(Arrays.asList(actionMap2.allKeys()));
                }
            }
            object2 = new ActionMap();
            if (actionMap2 != null && (object = actionMap2.allKeys()) != null) {
                void e;
                boolean i = false;
                while (e < ((Object)object).length) {
                    Object object3 = object[e];
                    ((ActionMap)object2).put(object3, actionMap2.get(object3));
                    ++e;
                }
            }
            for (Object e : arrayList) {
                ((ActionMap)object2).put(e, actionMap.get(e));
            }
            return object2;
        }
    }
}

