/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ui;

import java.beans.PropertyChangeListener;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjectsListener;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.netbeans.modules.project.uiapi.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenProjects {
    public static final String PROPERTY_OPEN_PROJECTS = "openProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    private static OpenProjects INSTANCE = new OpenProjects();
    private OpenProjectsTrampoline trampoline = Utilities.getOpenProjectsTrampoline();

    private OpenProjects() {
        this.addPropertyChangeListener(new OpenProjectsListener());
    }

    public static OpenProjects getDefault() {
        return INSTANCE;
    }

    public Project[] getOpenProjects() {
        return this.trampoline.getOpenProjectsAPI();
    }

    public Future<Project[]> openProjects() {
        return this.trampoline.openProjectsAPI();
    }

    public void open(Project[] projectArray, boolean bl) {
        this.trampoline.openAPI(projectArray, bl, false);
    }

    public void open(Project[] projectArray, boolean bl, boolean bl2) {
        this.trampoline.openAPI(projectArray, bl, bl2);
    }

    public boolean isProjectOpen(Project project) {
        if (project == null) {
            return false;
        }
        for (Project project2 : this.getOpenProjects()) {
            if (!project.equals(project2) && !project2.equals(project)) continue;
            return true;
        }
        return false;
    }

    public void close(Project[] projectArray) {
        this.trampoline.closeAPI(projectArray);
    }

    public Project getMainProject() {
        return this.trampoline.getMainProject();
    }

    public void setMainProject(Project project) throws IllegalArgumentException {
        this.trampoline.setMainProject(project);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.trampoline.addPropertyChangeListenerAPI(propertyChangeListener, this);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.trampoline.removePropertyChangeListenerAPI(propertyChangeListener);
    }
}

