/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class DefaultProjectRenamePanel
extends JPanel
implements DocumentListener,
DefaultProjectOperationsImplementation.InvalidablePanel {
    private Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private ProgressHandle handle;
    private JCheckBox alsoRenameFolder;
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextArea jTextArea1;
    private JPanel progress;
    private JPanel progressImpl;
    private JTextField projectFolder;
    private JLabel projectFolderLabel;
    private JTextField projectName;

    public DefaultProjectRenamePanel(ProgressHandle progressHandle, Project project, String string) {
        this.project = project;
        this.handle = progressHandle;
        if (string == null) {
            string = ProjectUtils.getInformation((Project)project).getDisplayName();
        }
        this.initComponents();
        this.projectName.setText(string);
        this.projectName.getDocument().addDocumentListener(this);
        this.updateProjectFolder();
        this.validateDialog();
        if (Boolean.getBoolean("org.netbeans.modules.project.uiapi.DefaultProjectOperations.showProgress")) {
            ((CardLayout)this.progress.getLayout()).show(this.progress, "progress");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectName = new JTextField();
        this.projectFolder = new JTextField();
        this.alsoRenameFolder = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.errorMessage = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.progress = new JPanel();
        this.jPanel4 = new JPanel();
        this.progressImpl = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"LBL_Project_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectFolderLabel.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"LBL_Project_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        this.projectName.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSN_Project_Name", (Object[])new Object[0]));
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSD_Project_Name", (Object[])new Object[0]));
        this.projectFolder.setColumns(30);
        this.projectFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.projectFolder, gridBagConstraints);
        this.projectFolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSN_Project_Folder", (Object[])new Object[0]));
        this.projectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSD_Project_Folder", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((AbstractButton)this.alsoRenameFolder, (String)NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"LBL_Also_Rename_Project_Folder"));
        this.alsoRenameFolder.setMargin(new Insets(0, 0, 0, 0));
        this.alsoRenameFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultProjectRenamePanel.this.alsoRenameFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.alsoRenameFolder, gridBagConstraints);
        this.alsoRenameFolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSN_Also_Rename_Project_Folder", (Object[])new Object[0]));
        this.alsoRenameFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSD_Also_Rename_Project_Folder", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"LBL_Rename_Dialog_Text", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.errorMessage.setForeground(UIManager.getColor("nb.errorForeground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.errorMessage, gridBagConstraints);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(UIManager.getColor("nb.errorForeground"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"VCSWarningMessage"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.progress.setLayout(new CardLayout());
        this.progress.add((Component)this.jPanel4, "not-progress");
        this.progressImpl.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"LBL_Renaming_Project", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.progressImpl.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel3.add(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle));
        this.jPanel3.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.progressImpl.add((Component)this.jPanel3, gridBagConstraints);
        this.progress.add((Component)this.progressImpl, "progress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.progress, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectRenamePanel.class, (String)"ACSD_Project_Rename", (Object[])new Object[0]));
    }

    private void alsoRenameFolderActionPerformed(ActionEvent actionEvent) {
        this.updateProjectFolder();
        this.validateDialog();
    }

    public String getNewName() {
        return this.projectName.getText();
    }

    public boolean getRenameProjectFolder() {
        return this.alsoRenameFolder.isSelected();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateProjectFolder();
        this.validateDialog();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateProjectFolder();
        this.validateDialog();
    }

    private void updateProjectFolder() {
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory().getParent());
        File file2 = this.alsoRenameFolder.isSelected() ? new File(file, this.projectName.getText()) : new File(file, this.project.getProjectDirectory().getNameExt());
        this.projectFolder.setText(file2.getAbsolutePath());
    }

    public boolean isPanelValid() {
        return " ".equals(this.errorMessage.getText());
    }

    private void validateDialog() {
        String string = this.computeError();
        boolean bl = false;
        String string2 = this.errorMessage.getText();
        string = string != null ? string : " ";
        bl = !string2.equals(string);
        this.errorMessage.setText(string);
        if (bl) {
            this.changeSupport.fireChange();
        }
    }

    private String computeError() {
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory().getParent());
        return DefaultProjectOperationsImplementation.computeError(file, this.projectName.getText(), !this.getRenameProjectFolder());
    }

    public void showProgress() {
        this.projectFolder.setEnabled(false);
        this.projectName.setEnabled(false);
        this.alsoRenameFolder.setEnabled(false);
        this.progress.setVisible(true);
        ((CardLayout)this.progress.getLayout()).last(this.progress);
    }
}

